import React from "react";
import { useMediaQuery, useTheme } from "@mui/material";

const SubscribeImage = () => {
  const theme = useTheme();
  const isSmall = useMediaQuery(theme.breakpoints.down("sm"));
  return (
    <svg
      width={isSmall ? "200" : "335"}
      height={isSmall ? "160" : "240"}
      viewBox="0 0 331 249"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clipPath="url(#clip0_1404_8548)">
        <path
          d="M301.289 164.752C300.871 172.929 308.223 177.656 315.244 173.55C317.565 172.193 319.77 169.891 321.508 166.145C328.103 151.877 322.286 141.239 310.739 144.017C303.61 145.735 301.708 156.647 301.297 164.745L301.289 164.752Z"
          fill="#039D55"
          fillOpacity="0.3"
        />
        <path
          d="M27.1811 96.7319C25.9846 102.145 20.3409 103.913 16.4918 99.9724C15.2233 98.6733 14.1925 96.768 13.7312 94.0183C11.9797 83.5175 17.6884 77.6139 24.7305 81.5039C29.0768 83.9072 28.3632 91.3696 27.1811 96.7319Z"
          fill="#039D55"
          fillOpacity="0.3"
        />
        <path
          d="M260.248 88.7863C260.248 89.6235 259.909 90.3885 259.347 90.9442C258.799 91.4999 258.035 91.8464 257.199 91.8464H191.953C190.274 91.8464 188.904 90.4751 188.904 88.7935C188.904 87.9564 189.243 87.1914 189.805 86.6356C190.353 86.0799 191.117 85.7335 191.953 85.7335H195.038C196.256 82.8972 199.067 80.9197 202.34 80.9197C204.545 80.9197 206.535 81.8219 207.976 83.2653C209.901 80.0032 213.44 77.8092 217.505 77.8092C218.622 77.8092 219.696 77.9752 220.705 78.2855C222.832 74.2872 227.027 71.5664 231.863 71.5664C237.673 71.5664 242.56 75.4925 244.03 80.8403C245.097 80.3063 246.308 79.9959 247.591 79.9959C251.216 79.9959 254.273 82.4209 255.231 85.7335H257.199C258.871 85.7335 260.248 87.112 260.248 88.7863Z"
          fill="#039D55"
          fillOpacity="0.3"
        />
        <path
          d="M276.472 39.1918C273.942 39.1918 271.888 37.135 271.888 34.6018C271.888 32.0686 273.942 30.0117 276.472 30.0117C279.002 30.0117 281.056 32.0686 281.056 34.6018C281.056 37.135 279.002 39.1918 276.472 39.1918ZM276.472 31.4479C274.735 31.4479 273.322 32.8625 273.322 34.6018C273.322 36.3411 274.735 37.7556 276.472 37.7556C278.209 37.7556 279.622 36.3411 279.622 34.6018C279.622 32.8625 278.209 31.4479 276.472 31.4479Z"
          fill="#039D55"
        />
        <path
          d="M292.978 55.3012C290.448 55.3012 288.394 53.2443 288.394 50.7112C288.394 48.178 290.448 46.1211 292.978 46.1211C295.508 46.1211 297.562 48.178 297.562 50.7112C297.562 53.2443 295.508 55.3012 292.978 55.3012ZM292.978 47.5573C291.241 47.5573 289.828 48.9718 289.828 50.7112C289.828 52.4505 291.241 53.865 292.978 53.865C294.715 53.865 296.128 52.4505 296.128 50.7112C296.128 48.9718 294.715 47.5573 292.978 47.5573Z"
          fill="#039D55"
        />
        <path
          d="M298.644 70.2166C298.247 70.2166 297.923 69.8918 297.923 69.4949V66.3194C297.923 65.9224 298.247 65.5977 298.644 65.5977C299.04 65.5977 299.364 65.9224 299.364 66.3194V69.4949C299.364 69.8918 299.04 70.2166 298.644 70.2166Z"
          fill="#039D55"
        />
        <path
          d="M298.644 75.7752C298.247 75.7752 297.923 75.4504 297.923 75.0535V71.878C297.923 71.481 298.247 71.1562 298.644 71.1562C299.04 71.1562 299.364 71.481 299.364 71.878V75.0535C299.364 75.4504 299.04 75.7752 298.644 75.7752Z"
          fill="#039D55"
        />
        <path
          d="M303.098 71.4083H300.251C299.855 71.4083 299.53 71.0835 299.53 70.6866C299.53 70.2896 299.855 69.9648 300.251 69.9648H303.098C303.495 69.9648 303.819 70.2896 303.819 70.6866C303.819 71.0835 303.495 71.4083 303.098 71.4083Z"
          fill="#039D55"
        />
        <path
          d="M297.037 71.4083H294.19C293.793 71.4083 293.469 71.0835 293.469 70.6866C293.469 70.2896 293.793 69.9648 294.19 69.9648H297.037C297.433 69.9648 297.757 70.2896 297.757 70.6866C297.757 71.0835 297.433 71.4083 297.037 71.4083Z"
          fill="#039D55"
        />
        <path
          d="M273.322 52.4197C272.926 52.4197 272.602 52.0949 272.602 51.698V48.5225C272.602 48.1255 272.926 47.8008 273.322 47.8008C273.719 47.8008 274.043 48.1255 274.043 48.5225V51.698C274.043 52.0949 273.719 52.4197 273.322 52.4197Z"
          fill="#039D55"
        />
        <path
          d="M273.322 57.9783C272.926 57.9783 272.602 57.6535 272.602 57.2566V54.0811C272.602 53.6841 272.926 53.3594 273.322 53.3594C273.719 53.3594 274.043 53.6841 274.043 54.0811V57.2566C274.043 57.6535 273.719 57.9783 273.322 57.9783Z"
          fill="#039D55"
        />
        <path
          d="M277.777 53.6114H274.93C274.533 53.6114 274.209 53.2866 274.209 52.8897C274.209 52.4927 274.533 52.168 274.93 52.168H277.777C278.173 52.168 278.498 52.4927 278.498 52.8897C278.498 53.2866 278.173 53.6114 277.777 53.6114Z"
          fill="#039D55"
        />
        <path
          d="M271.722 53.6114H268.875C268.479 53.6114 268.154 53.2866 268.154 52.8897C268.154 52.4927 268.479 52.168 268.875 52.168H271.722C272.119 52.168 272.443 52.4927 272.443 52.8897C272.443 53.2866 272.119 53.6114 271.722 53.6114Z"
          fill="#039D55"
        />
        <path
          d="M57.3027 28.6291C57.3027 26.0959 59.357 24.0391 61.8869 24.0391C64.4169 24.0391 66.4712 26.0959 66.4712 28.6291C66.4712 31.1623 64.4169 33.2192 61.8869 33.2192C59.357 33.2192 57.3027 31.1623 57.3027 28.6291ZM58.7443 28.6291C58.7443 30.3684 60.1571 31.783 61.8942 31.783C63.6312 31.783 65.044 30.3684 65.044 28.6291C65.044 26.8898 63.6312 25.4753 61.8942 25.4753C60.1571 25.4753 58.7443 26.8898 58.7443 28.6291Z"
          fill="#039D55"
        />
        <path
          d="M38.8936 46.133C38.8936 43.5998 40.9478 41.543 43.4778 41.543C46.0077 41.543 48.062 43.5998 48.062 46.133C48.062 48.6662 46.0077 50.7231 43.4778 50.7231C40.9478 50.7231 38.8936 48.6662 38.8936 46.133ZM40.3351 46.133C40.3351 47.8723 41.7479 49.2869 43.485 49.2869C45.2221 49.2869 46.6348 47.8723 46.6348 46.133C46.6348 44.3937 45.2221 42.9792 43.485 42.9792C41.7479 42.9792 40.3351 44.3937 40.3351 46.133Z"
          fill="#039D55"
        />
        <path
          d="M29.3575 52.576C29.7539 52.576 30.0783 52.2512 30.0783 51.8542V48.6787C30.0783 48.2818 29.7539 47.957 29.3575 47.957C28.9611 47.957 28.6367 48.2818 28.6367 48.6787V51.8542C28.6367 52.2512 28.9611 52.576 29.3575 52.576Z"
          fill="#039D55"
        />
        <path
          d="M29.3575 58.1345C29.7539 58.1345 30.0783 57.8098 30.0783 57.4128V54.2373C30.0783 53.8404 29.7539 53.5156 29.3575 53.5156C28.9611 53.5156 28.6367 53.8404 28.6367 54.2373V57.4128C28.6367 57.8098 28.9611 58.1345 29.3575 58.1345Z"
          fill="#039D55"
        />
        <path
          d="M24.9034 53.7676H27.7505C28.1469 53.7676 28.4713 53.4429 28.4713 53.0459C28.4713 52.649 28.1469 52.3242 27.7505 52.3242H24.9034C24.507 52.3242 24.1826 52.649 24.1826 53.0459C24.1826 53.4429 24.507 53.7676 24.9034 53.7676Z"
          fill="#039D55"
        />
        <path
          d="M30.9581 53.7676H33.8052C34.2016 53.7676 34.526 53.4429 34.526 53.0459C34.526 52.649 34.2016 52.3242 33.8052 52.3242H30.9581C30.5617 52.3242 30.2373 52.649 30.2373 53.0459C30.2373 53.4429 30.5617 53.7676 30.9581 53.7676Z"
          fill="#039D55"
        />
        <path
          d="M45.9288 28.1619C46.3252 28.1619 46.6496 27.8371 46.6496 27.4402V24.2647C46.6496 23.8677 46.3252 23.543 45.9288 23.543C45.5324 23.543 45.208 23.8677 45.208 24.2647V27.4402C45.208 27.8371 45.5324 28.1619 45.9288 28.1619Z"
          fill="#039D55"
        />
        <path
          d="M45.9288 33.7205C46.3252 33.7205 46.6496 33.3957 46.6496 32.9988V29.8233C46.6496 29.4263 46.3252 29.1016 45.9288 29.1016C45.5324 29.1016 45.208 29.4263 45.208 29.8233V32.9988C45.208 33.3957 45.5324 33.7205 45.9288 33.7205Z"
          fill="#039D55"
        />
        <path
          d="M41.4815 29.3536H44.3286C44.7251 29.3536 45.0494 29.0288 45.0494 28.6319C45.0494 28.2349 44.7251 27.9102 44.3286 27.9102H41.4815C41.0851 27.9102 40.7607 28.2349 40.7607 28.6319C40.7607 29.0288 41.0851 29.3536 41.4815 29.3536Z"
          fill="#039D55"
        />
        <path
          d="M47.5362 29.3536H50.3833C50.7798 29.3536 51.1041 29.0288 51.1041 28.6319C51.1041 28.2349 50.7798 27.9102 50.3833 27.9102H47.5362C47.1398 27.9102 46.8154 28.2349 46.8154 28.6319C46.8154 29.0288 47.1398 29.3536 47.5362 29.3536Z"
          fill="#039D55"
        />
        <path
          d="M226.176 45.3819V58.6686C226.176 60.4223 224.756 61.8513 222.998 61.8513H198.902L191.629 64.4639C190.879 64.7309 190.166 63.9948 190.454 63.2586L193.208 56.1426V45.3819C193.208 43.6282 194.627 42.1992 196.386 42.1992H222.998C224.749 42.1992 226.176 43.621 226.176 45.3819Z"
          fill="#039D55"
        />
        <g opacity="0.5">
          <path
            d="M221.102 49.1438H198.996C198.513 49.1438 198.116 48.7541 198.116 48.2633C198.116 47.7798 198.505 47.3828 198.996 47.3828H221.102C221.585 47.3828 221.981 47.7725 221.981 48.2633C221.981 48.7468 221.592 49.1438 221.102 49.1438Z"
            fill="#005F33"
          />
          <path
            d="M221.102 52.6789H198.996C198.513 52.6789 198.116 52.2892 198.116 51.7984C198.116 51.3149 198.505 50.918 198.996 50.918H221.102C221.585 50.918 221.981 51.3077 221.981 51.7984C221.981 52.282 221.592 52.6789 221.102 52.6789Z"
            fill="#005F33"
          />
          <path
            d="M221.102 56.218H198.996C198.513 56.218 198.116 55.8283 198.116 55.3375C198.116 54.854 198.505 54.457 198.996 54.457H221.102C221.585 54.457 221.981 54.8468 221.981 55.3375C221.981 55.8211 221.592 56.218 221.102 56.218Z"
            fill="#005F33"
          />
        </g>
        <path
          d="M134.233 12.3141C134.312 12.3358 134.391 12.3358 134.478 12.3141C135.357 12.0832 135.869 11.9893 135.869 11.9893C136.135 11.9388 136.308 11.6862 136.265 11.4192C136.215 11.1522 135.962 10.9789 135.696 11.0222C135.674 11.0222 135.148 11.1233 134.233 11.3615C133.973 11.4336 133.814 11.7007 133.887 11.9605C133.937 12.1409 134.074 12.2708 134.24 12.3141H134.233Z"
          fill="#0DCB72"
        />
        <path
          d="M105.79 34.7796C105.336 35.6096 104.896 36.4756 104.486 37.3489C104.385 37.5654 104.147 37.6736 103.923 37.6159C103.894 37.6087 103.866 37.5942 103.837 37.587C103.592 37.4716 103.491 37.1757 103.606 36.9375C104.024 36.0498 104.471 35.1693 104.94 34.3177C105.069 34.0795 105.365 33.9929 105.603 34.1228C105.841 34.2527 105.927 34.5487 105.797 34.7868L105.79 34.7796Z"
          fill="#0DCB72"
        />
        <path
          d="M103.332 39.9863C102.979 40.8668 102.64 41.7761 102.338 42.6927C102.258 42.9381 101.999 43.0752 101.754 43.0103C101.739 43.0103 101.732 43.0103 101.718 42.9958C101.458 42.9092 101.321 42.6277 101.408 42.3751C101.725 41.4441 102.064 40.5131 102.424 39.6182C102.525 39.3656 102.813 39.2429 103.058 39.344C103.311 39.445 103.433 39.7337 103.332 39.9791V39.9863Z"
          fill="#0DCB72"
        />
        <path
          d="M99.1806 54.3486C98.9427 54.2908 98.7841 54.0599 98.8129 53.8145C98.9355 52.8402 99.0868 51.8659 99.2526 50.9132C99.2959 50.6462 99.5554 50.4658 99.8221 50.5163C100.089 50.5668 100.269 50.8194 100.218 51.0864C100.053 52.0175 99.9085 52.9845 99.786 53.9444C99.75 54.2114 99.5049 54.3991 99.2382 54.3702C99.2166 54.3702 99.2022 54.3702 99.1806 54.3558V54.3486Z"
          fill="#0DCB72"
        />
        <path
          d="M101.149 44.8419C101.408 44.9141 101.559 45.1884 101.487 45.4482C101.365 45.8812 101.25 46.3142 101.141 46.74C101.019 47.238 100.896 47.7432 100.781 48.2412C100.723 48.5082 100.457 48.6742 100.197 48.6092C100.197 48.6092 100.19 48.6092 100.183 48.6092C99.9233 48.5443 99.7647 48.2845 99.8224 48.0247C99.9377 47.5123 100.06 46.9998 100.19 46.4946C100.298 46.0616 100.421 45.6142 100.543 45.1739C100.615 44.9141 100.875 44.7625 101.134 44.8275C101.134 44.8275 101.141 44.8275 101.149 44.8275V44.8419Z"
          fill="#0DCB72"
        />
        <path
          d="M107.253 32.2974C107.138 32.4778 106.921 32.5645 106.72 32.5139C106.669 32.4995 106.626 32.4851 106.575 32.4562C106.345 32.3119 106.28 32.0087 106.424 31.7778C106.943 30.9478 107.498 30.1323 108.075 29.3456C108.233 29.1291 108.536 29.0786 108.759 29.2374C108.976 29.3962 109.026 29.6993 108.868 29.923C108.305 30.6952 107.765 31.4963 107.253 32.3046V32.2974Z"
          fill="#0DCB72"
        />
        <path
          d="M131.724 13.1445C130.83 13.4476 129.922 13.794 129.028 14.1621C128.928 14.2054 128.819 14.2126 128.719 14.1837C128.574 14.1477 128.445 14.0466 128.387 13.8951C128.286 13.6425 128.401 13.361 128.654 13.2527C129.569 12.8775 130.492 12.5238 131.407 12.2135C131.659 12.1269 131.94 12.264 132.027 12.5166C132.113 12.7692 131.977 13.0507 131.724 13.1373V13.1445Z"
          fill="#0DCB72"
        />
        <path
          d="M123.846 16.674C123.73 16.739 123.601 16.7534 123.485 16.7246C123.363 16.6957 123.247 16.6091 123.175 16.4864C123.046 16.2482 123.125 15.9523 123.363 15.8224C124.213 15.3461 125.093 14.8914 125.972 14.4656C126.217 14.3502 126.505 14.4512 126.628 14.6966C126.743 14.942 126.642 15.2306 126.397 15.3533C125.539 15.7719 124.675 16.2194 123.846 16.6813V16.674Z"
          fill="#0DCB72"
        />
        <path
          d="M114.562 23.4448C114.432 23.5602 114.267 23.6036 114.108 23.5602C114.021 23.5386 113.935 23.4881 113.87 23.4231C113.683 23.2283 113.697 22.9179 113.892 22.7303C114.605 22.0663 115.348 21.4096 116.097 20.7889C116.306 20.6157 116.616 20.6446 116.789 20.8538C116.962 21.0631 116.933 21.3735 116.724 21.5467C115.989 22.1601 115.261 22.7952 114.562 23.452V23.4448Z"
          fill="#0DCB72"
        />
        <path
          d="M118.995 19.7764C118.873 19.863 118.721 19.8919 118.584 19.8558C118.476 19.827 118.375 19.762 118.311 19.6682C118.152 19.4517 118.202 19.1413 118.419 18.9826C119.204 18.4124 120.019 17.8495 120.848 17.3226C121.078 17.1783 121.381 17.2432 121.525 17.4742C121.669 17.7051 121.605 18.0083 121.374 18.1526C120.567 18.6722 119.766 19.2135 118.995 19.7764Z"
          fill="#0DCB72"
        />
        <path
          d="M110.62 27.6354C110.497 27.787 110.303 27.8447 110.122 27.8014C110.058 27.787 109.986 27.7509 109.928 27.7004C109.719 27.5272 109.69 27.2168 109.863 27.0075C110.483 26.257 111.139 25.5136 111.809 24.7991C111.997 24.6043 112.306 24.5898 112.501 24.7775C112.696 24.9651 112.71 25.2754 112.523 25.4703C111.867 26.1631 111.225 26.8921 110.62 27.6282V27.6354Z"
          fill="#0DCB72"
        />
        <path
          d="M134.715 8.99394L133.728 0.824219L159.683 4.7936L134.715 8.99394Z"
          fill="#039D55"
        />
        <path
          d="M159.683 4.79297L135.702 11.0718L135.637 11.0935L134.434 12.5657L134.715 8.9933L159.683 4.79297Z"
          fill="#005F33"
        />
        <path
          d="M134.434 12.566L136.589 12.5372L135.637 11.0938L134.434 12.566Z"
          fill="#04F485"
        />
        <path
          d="M138.658 10.2996L135.638 11.0935L140.546 18.5415L159.683 4.79297L138.658 10.2996Z"
          fill="#039D55"
        />
        <path
          d="M258.893 158.535C265.206 151.125 278.92 133.835 286.947 114.778C298.462 87.4243 312.171 88.7628 315.527 97.8711C324.202 121.43 285.72 150.644 269.679 161.571L258.898 158.535H258.893Z"
          fill="#42C789"
        />
        <path
          d="M262.689 159.609C273.799 149.881 282.971 138.669 289.14 130.268C297.392 119.033 302.212 110.255 302.264 110.168C302.438 109.855 302.831 109.739 303.15 109.913C303.468 110.087 303.584 110.481 303.41 110.794C303.364 110.881 298.509 119.722 290.211 131.027C284.111 139.33 275.107 150.356 264.188 160.038L262.695 159.615L262.689 159.609Z"
          fill="#039D55"
        />
        <path
          d="M266 135.134C268.169 129.725 272.204 118.441 273.179 107.181C274.639 90.3554 282.131 88.6943 285.457 93.0475C294.591 105 276.617 129.663 270.847 137L266 135.138V135.134Z"
          fill="#039D55"
        />
        <path
          d="M262.986 147.154C269.61 136.192 274.223 124.493 277.092 115.926C280.905 104.552 282.549 96.0865 282.563 96.0071C282.621 95.704 282.916 95.5019 283.219 95.5669C283.522 95.6246 283.723 95.9205 283.666 96.2236C283.651 96.3102 281.994 104.826 278.159 116.273C275.283 124.854 270.67 136.56 264.053 147.566L262.986 147.169V147.154Z"
          fill="#01562E"
        />
        <path
          d="M307.358 184.594C309.823 171.538 314.551 159.623 319.936 164.537C325.32 169.459 316.786 189.797 304.057 201.07L300.64 205.942C309.773 197.563 324.469 192.568 328.463 197.303C332.427 202.001 322.343 204.44 312.757 205.126C305.462 205.646 300.806 207.667 298.55 208.922L282.419 231.93C296.921 218.709 320.13 210.842 326.444 218.333C332.737 225.796 316.735 229.657 301.527 230.747C290.037 231.569 282.671 234.73 279.06 236.73L275.845 241.32C274.966 240.887 274.086 240.446 273.207 240.006L292.394 212.632C292.51 209.817 292.243 205.841 290.852 200.882C288.243 191.623 287.104 181.303 292.863 183.439C297.865 185.294 298.781 197.101 295.883 207.659L302.521 198.19C304.078 194.914 306.306 190.237 307.365 184.601L307.358 184.594Z"
          fill="#42C789"
        />
        <path
          d="M53.23 80.1681C51.9254 69.3569 48.7035 59.3541 44.04 63.0853C39.3693 66.8165 45.2365 83.9137 55.032 93.8228L57.562 97.9942C50.5487 90.6473 38.7999 85.7541 35.2824 89.4059C31.7866 93.0361 39.8955 95.5765 47.6944 96.6591C53.6337 97.4818 57.3241 99.3871 59.1045 100.542L71.0407 120.237C59.9045 108.632 41.3515 100.939 35.787 106.712C30.2369 112.472 43.1102 116.506 55.4861 118.224C64.8347 119.523 70.6875 122.511 73.5346 124.344L75.9132 128.27C76.6556 127.967 77.398 127.656 78.1405 127.339L63.9409 103.905C64.0058 101.596 64.4311 98.3623 65.8438 94.3857C68.4819 86.9593 69.9811 78.5803 65.1519 80.0093C60.9641 81.2507 59.573 90.8566 61.3677 99.6542L56.4592 91.5494C55.3708 88.7853 53.7995 84.8375 53.2373 80.1681H53.23Z"
          fill="#42C789"
        />
        <path
          d="M306.457 243.109V243.361H25.5947V243.109C25.5947 240.229 27.9301 237.891 30.806 237.891H301.245C304.129 237.891 306.457 240.229 306.457 243.109Z"
          fill="#039D55"
        />
        <g clipPath="url(#clip1_1404_8548)">
          <path
            d="M132.604 95.4236L97.3459 107.346C96.9164 107.492 96.4412 107.358 96.1517 107.01C95.8607 106.663 95.815 106.172 96.0353 105.777L104.797 90.0682C105.052 89.6116 105.593 89.3982 106.092 89.5582L111.55 91.3109L114.815 86.6083C115.112 86.1783 115.674 86.0199 116.154 86.227L132.689 93.3822C133.105 93.5626 133.367 93.9785 133.348 94.4304C133.33 94.8838 133.034 95.2777 132.604 95.4236ZM99.3362 104.363L129.207 94.2625L116.108 88.5932L112.894 93.2253C112.618 93.6223 112.115 93.7917 111.655 93.6442L106.279 91.9182L99.3362 104.363Z"
            fill="#89C6A9"
          />
          <path
            d="M97.3458 107.345C97.2042 107.394 97.05 107.412 96.8942 107.398C96.4616 107.359 96.0934 107.07 95.9549 106.659L88.886 85.8668C88.7522 85.4745 88.8529 85.043 89.1424 84.748C89.4335 84.453 89.8661 84.3478 90.2611 84.4749L106.092 89.5589C106.405 89.6593 106.655 89.8947 106.776 90.1991C106.897 90.5035 106.874 90.8456 106.715 91.1327L97.9531 106.841C97.8178 107.083 97.5991 107.259 97.3458 107.345ZM91.6645 87.224L97.2388 103.62L104.147 91.2316L91.6645 87.224Z"
            fill="#89C6A9"
          />
          <path
            d="M132.604 95.4227C132.351 95.509 132.069 95.5011 131.814 95.3897L115.279 88.2345C114.976 88.1043 114.75 87.8454 114.66 87.5316C114.571 87.2162 114.626 86.8772 114.813 86.6089L124.28 72.9717C124.516 72.6312 124.923 72.4539 125.334 72.5104C125.744 72.5684 126.087 72.8509 126.221 73.2431L133.29 94.0356C133.43 94.4451 133.314 94.8986 132.994 95.192C132.881 95.2972 132.747 95.374 132.604 95.4227ZM117.379 86.758L130.417 92.4006L124.843 76.0048L117.379 86.758Z"
            fill="#89C6A9"
          />
          <path
            d="M112.341 93.638C112.124 93.7117 111.883 93.7164 111.652 93.6427L89.5877 86.5581C89.1377 86.4137 88.8309 85.9964 88.8262 85.5256C88.823 85.0533 89.1236 84.6328 89.5704 84.4806L124.829 72.5584C125.277 72.4062 125.773 72.5584 126.058 72.935C126.342 73.3116 126.353 73.8294 126.084 74.217L112.89 93.2237C112.753 93.423 112.56 93.5642 112.341 93.638ZM93.4219 85.4895L111.551 91.311L122.392 75.6935L93.4219 85.4895Z"
            fill="#89C6A9"
          />
          <path
            d="M129.533 216.855L92.2955 235.279C91.8424 235.504 91.2964 235.427 90.9235 235.085C90.5507 234.743 90.4264 234.208 90.6104 233.738L97.9626 215.055C98.1766 214.512 98.7446 214.195 99.3188 214.299L105.62 215.428L108.531 209.74C108.797 209.221 109.393 208.962 109.955 209.12L129.319 214.586C129.807 214.724 130.159 215.146 130.205 215.648C130.255 216.15 129.988 216.63 129.533 216.855ZM94.0529 231.683L125.6 216.073L110.258 211.744L107.392 217.346C107.146 217.826 106.614 218.088 106.084 217.992L99.8774 216.88L94.0529 231.683Z"
            fill="#89C6A9"
          />
          <path
            d="M92.297 235.282C92.146 235.356 91.9808 235.401 91.8061 235.407C91.3216 235.428 90.8716 235.163 90.656 234.729L79.7324 212.77C79.5263 212.355 79.5719 211.863 79.8504 211.492C80.1289 211.124 80.5914 210.942 81.0461 211.023L99.322 214.299C99.6823 214.364 99.9953 214.587 100.175 214.907C100.354 215.225 100.379 215.608 100.246 215.949L92.8933 234.632C92.7785 234.921 92.5645 235.15 92.297 235.282ZM83.0081 213.859L91.6221 231.175L97.4198 216.443L83.0081 213.859Z"
            fill="#89C6A9"
          />
          <path
            d="M129.535 216.856C129.267 216.987 128.956 217.02 128.657 216.937L109.292 211.472C108.94 211.373 108.651 211.12 108.503 210.785C108.356 210.449 108.367 210.066 108.534 209.741L116.975 193.245C117.186 192.834 117.611 192.577 118.073 192.578C118.536 192.581 118.957 192.843 119.164 193.258L130.087 215.217C130.303 215.651 130.241 216.168 129.933 216.54C129.821 216.675 129.684 216.782 129.535 216.856ZM111.394 209.526L126.665 213.835L118.05 196.52L111.394 209.526Z"
            fill="#89C6A9"
          />
          <path
            d="M106.846 217.885C106.616 217.998 106.35 218.04 106.084 217.993L80.6121 213.427C80.0913 213.335 79.6901 212.919 79.6161 212.396C79.5422 211.875 79.8112 211.364 80.2848 211.13L117.521 192.705C117.994 192.472 118.566 192.566 118.937 192.941C119.308 193.316 119.396 193.885 119.157 194.355L107.393 217.345C107.269 217.585 107.076 217.771 106.846 217.885ZM84.6933 211.676L105.623 215.428L115.29 196.537L84.6933 211.676Z"
            fill="#89C6A9"
          />
          <path
            d="M249.029 189.733L211.044 173.4C210.582 173.2 210.289 172.737 210.31 172.235C210.33 171.733 210.657 171.295 211.134 171.132L230.085 164.675C230.635 164.487 231.241 164.715 231.534 165.217L234.729 170.713L240.931 169.257C241.498 169.124 242.078 169.409 242.321 169.937L250.623 188.113C250.832 188.571 250.736 189.11 250.384 189.467C250.03 189.827 249.492 189.932 249.029 189.733ZM214.912 172.414L247.093 186.252L240.514 171.852L234.407 173.287C233.884 173.409 233.342 173.177 233.073 172.712L229.926 167.297L214.912 172.414Z"
            fill="#89C6A9"
          />
          <path
            d="M211.045 173.401C210.892 173.335 210.75 173.238 210.632 173.111C210.305 172.758 210.217 172.246 210.407 171.804L220.091 149.403C220.274 148.981 220.678 148.699 221.139 148.67C221.598 148.644 222.034 148.877 222.266 149.274L231.532 165.218C231.715 165.534 231.748 165.913 231.619 166.254C231.492 166.594 231.216 166.861 230.872 166.979L211.921 173.436C211.63 173.535 211.318 173.517 211.045 173.401ZM221.372 152.584L213.735 170.249L228.678 165.157L221.372 152.584Z"
            fill="#89C6A9"
          />
          <path
            d="M249.03 189.734C248.758 189.616 248.531 189.401 248.404 189.122L240.101 170.945C239.95 170.614 239.955 170.233 240.115 169.906C240.276 169.58 240.575 169.341 240.93 169.258L258.917 165.033C259.365 164.927 259.834 165.083 260.13 165.434C260.425 165.786 260.498 166.275 260.315 166.696L250.631 189.097C250.441 189.538 250.007 189.826 249.524 189.831C249.352 189.834 249.184 189.8 249.03 189.734ZM242.935 171.286L249.481 185.618L257.118 167.953L242.935 171.286Z"
            fill="#89C6A9"
          />
          <path
            d="M233.646 173.222C233.411 173.122 233.208 172.948 233.073 172.716L220.157 150.494C219.893 150.04 219.951 149.469 220.301 149.077C220.65 148.684 221.212 148.561 221.695 148.768L259.68 165.101C260.163 165.308 260.457 165.8 260.411 166.323C260.365 166.846 259.988 167.28 259.477 167.399L234.409 173.288C234.146 173.35 233.88 173.323 233.646 173.222ZM224.116 152.457L234.73 170.717L255.328 165.879L224.116 152.457Z"
            fill="#89C6A9"
          />
          <path
            d="M103.204 188.064H103.153C102.939 188.063 102.768 187.89 102.768 187.677C102.769 187.465 102.942 187.292 103.155 187.292H103.156H103.204C104.221 187.292 105.25 187.231 106.262 187.112C106.474 187.087 106.666 187.237 106.692 187.449C106.717 187.661 106.566 187.853 106.353 187.878C105.312 188.002 104.253 188.064 103.204 188.064ZM98.7526 187.688C98.7305 187.688 98.7085 187.686 98.6865 187.682C97.6402 187.503 96.5892 187.259 95.565 186.957C95.3605 186.895 95.2425 186.682 95.3038 186.476C95.3652 186.272 95.5791 186.155 95.7853 186.216C96.7796 186.509 97.8007 186.746 98.8171 186.921C99.0279 186.957 99.1695 187.156 99.1333 187.366C99.1018 187.554 98.9382 187.688 98.7526 187.688ZM110.638 187.001C110.471 187.001 110.315 186.891 110.266 186.723C110.206 186.519 110.324 186.304 110.529 186.244C111.52 185.954 112.507 185.602 113.459 185.198C113.655 185.114 113.882 185.205 113.967 185.402C114.05 185.598 113.959 185.824 113.762 185.908C112.782 186.326 111.767 186.688 110.746 186.986C110.71 186.994 110.674 187.001 110.638 187.001ZM91.5561 185.381C91.4995 185.381 91.4413 185.369 91.3878 185.342C90.4296 184.878 89.4888 184.35 88.5951 183.776C88.4158 183.66 88.3638 183.421 88.4787 183.242C88.5951 183.064 88.8343 183.012 89.0136 183.126C89.8821 183.683 90.7946 184.197 91.7261 184.647C91.918 184.739 91.9982 184.972 91.9054 185.163C91.8378 185.301 91.6993 185.381 91.5561 185.381ZM117.518 183.878C117.39 183.878 117.266 183.815 117.192 183.701C117.077 183.522 117.129 183.282 117.31 183.167C118.182 182.612 119.03 181.997 119.829 181.342C119.994 181.207 120.238 181.231 120.373 181.396C120.509 181.56 120.485 181.804 120.32 181.939C119.497 182.612 118.625 183.244 117.727 183.817C117.661 183.859 117.589 183.878 117.518 183.878ZM85.3021 181.149C85.2093 181.149 85.1149 181.116 85.041 181.049C84.2543 180.333 83.5038 179.563 82.8068 178.756C82.6668 178.595 82.6857 178.352 82.8477 178.212C83.0098 178.072 83.2537 178.091 83.3937 178.253C84.0702 179.034 84.8002 179.784 85.5633 180.479C85.7206 180.624 85.7317 180.867 85.5885 181.024C85.5114 181.107 85.406 181.149 85.3021 181.149ZM123.243 178.956C123.153 178.956 123.062 178.924 122.99 178.861C122.829 178.722 122.812 178.477 122.952 178.317C123.632 177.539 124.27 176.71 124.853 175.857C124.972 175.681 125.213 175.634 125.391 175.755C125.567 175.874 125.614 176.114 125.493 176.291C124.895 177.17 124.236 178.022 123.537 178.824C123.459 178.912 123.35 178.956 123.243 178.956ZM80.5019 175.325C80.3713 175.325 80.2439 175.259 80.1715 175.14C79.6193 174.231 79.1142 173.282 78.6737 172.315C78.5856 172.121 78.6705 171.893 78.8656 171.804C79.0607 171.716 79.2889 171.8 79.3785 171.995C79.8065 172.933 80.2974 173.858 80.8339 174.739C80.944 174.921 80.8858 175.158 80.7033 175.27C80.6388 175.307 80.5695 175.325 80.5019 175.325ZM127.338 172.618C127.285 172.618 127.23 172.607 127.178 172.583C126.984 172.496 126.898 172.266 126.988 172.072C127.417 171.137 127.795 170.162 128.113 169.178L128.124 169.144C128.188 168.941 128.407 168.829 128.61 168.894C128.813 168.959 128.926 169.177 128.86 169.379L128.849 169.414C128.522 170.429 128.131 171.432 127.691 172.394C127.625 172.535 127.485 172.618 127.338 172.618ZM77.533 168.392C77.3615 168.392 77.2058 168.278 77.1601 168.107C76.8848 167.081 76.6693 166.028 76.5182 164.978C76.4883 164.768 76.6346 164.571 76.847 164.542C77.0594 164.512 77.2545 164.658 77.2844 164.87C77.4307 165.89 77.64 166.913 77.9075 167.909C77.9625 168.115 77.8398 168.326 77.6337 168.381C77.5991 168.389 77.5661 168.392 77.533 168.392ZM129.488 165.353C129.469 165.353 129.45 165.351 129.431 165.348C129.22 165.317 129.072 165.122 129.104 164.91C129.253 163.889 129.341 162.849 129.366 161.818C129.371 161.604 129.547 161.436 129.763 161.441C129.977 161.446 130.145 161.623 130.141 161.837C130.114 162.897 130.023 163.969 129.87 165.022C129.843 165.215 129.678 165.353 129.488 165.353ZM76.6425 160.909C76.6394 160.909 76.6362 160.909 76.6331 160.909C76.4191 160.904 76.2507 160.727 76.2555 160.514C76.2822 159.453 76.375 158.381 76.5292 157.328C76.5607 157.118 76.7558 156.972 76.9682 157.002C77.179 157.033 77.3253 157.228 77.2954 157.44C77.146 158.461 77.0563 159.502 77.0295 160.533C77.0233 160.743 76.8502 160.909 76.6425 160.909ZM129.492 157.815C129.304 157.815 129.138 157.677 129.11 157.484C128.962 156.464 128.753 155.442 128.484 154.444C128.429 154.239 128.551 154.027 128.758 153.972C128.964 153.917 129.176 154.04 129.231 154.245C129.507 155.271 129.724 156.324 129.876 157.374C129.906 157.584 129.76 157.78 129.549 157.81C129.53 157.815 129.511 157.815 129.492 157.815ZM77.9106 153.476C77.8713 153.476 77.8319 153.47 77.7926 153.457C77.5897 153.393 77.4764 153.175 77.5425 152.973L77.5487 152.954C77.8729 151.948 78.2599 150.95 78.6989 149.993C78.787 149.798 79.0167 149.713 79.2118 149.801C79.4069 149.889 79.4918 150.118 79.4037 150.313C78.9773 151.243 78.6013 152.212 78.2866 153.191L78.2803 153.208C78.2269 153.373 78.0742 153.476 77.9106 153.476ZM127.364 150.584C127.217 150.584 127.076 150.501 127.011 150.358C126.582 149.42 126.092 148.497 125.554 147.616C125.443 147.434 125.501 147.197 125.683 147.085C125.866 146.974 126.103 147.032 126.215 147.214C126.769 148.121 127.272 149.072 127.714 150.038C127.803 150.233 127.718 150.46 127.523 150.55C127.472 150.573 127.417 150.584 127.364 150.584ZM81.2146 146.698C81.1407 146.698 81.0651 146.676 80.9975 146.632C80.8213 146.512 80.7741 146.272 80.8937 146.095C81.4915 145.216 82.1492 144.363 82.8477 143.561C82.9878 143.401 83.2316 143.384 83.3937 143.523C83.5542 143.663 83.5715 143.906 83.4314 144.068C82.7518 144.848 82.113 145.675 81.534 146.53C81.4601 146.638 81.3389 146.698 81.2146 146.698ZM123.284 144.237C123.175 144.237 123.067 144.192 122.991 144.104C122.315 143.322 121.583 142.574 120.82 141.879C120.663 141.736 120.65 141.491 120.795 141.334C120.938 141.177 121.184 141.165 121.341 141.309C122.128 142.025 122.88 142.795 123.577 143.6C123.717 143.762 123.698 144.005 123.537 144.145C123.465 144.207 123.374 144.237 123.284 144.237ZM86.3091 141.126C86.1974 141.126 86.0872 141.077 86.0101 140.984C85.8748 140.82 85.8984 140.576 86.0636 140.442C86.8849 139.767 87.7581 139.134 88.6549 138.562C88.8343 138.447 89.0734 138.499 89.1898 138.678C89.3047 138.857 89.2528 139.095 89.0734 139.211C88.2018 139.768 87.3538 140.382 86.5561 141.038C86.4821 141.097 86.3956 141.126 86.3091 141.126ZM117.576 139.294C117.504 139.294 117.431 139.274 117.367 139.233C116.498 138.676 115.584 138.165 114.653 137.714C114.461 137.622 114.38 137.391 114.473 137.198C114.566 137.007 114.797 136.927 114.991 137.019C115.951 137.484 116.89 138.009 117.785 138.584C117.965 138.698 118.016 138.938 117.902 139.117C117.829 139.232 117.703 139.294 117.576 139.294ZM92.7692 137.211C92.6197 137.211 92.4765 137.123 92.4136 136.977C92.3302 136.781 92.4215 136.555 92.6166 136.47C93.5952 136.053 94.61 135.689 95.6311 135.391C95.8356 135.331 96.0511 135.447 96.1109 135.653C96.1707 135.857 96.0543 136.072 95.8482 136.131C94.857 136.421 93.8705 136.774 92.9202 137.179C92.8714 137.201 92.8195 137.211 92.7692 137.211ZM110.702 136.164C110.666 136.164 110.63 136.159 110.592 136.148C109.596 135.855 108.576 135.62 107.56 135.447C107.349 135.411 107.208 135.212 107.244 135.001C107.28 134.791 107.48 134.65 107.691 134.686C108.737 134.863 109.788 135.107 110.812 135.408C111.017 135.467 111.135 135.682 111.073 135.886C111.023 136.054 110.869 136.164 110.702 136.164ZM100.068 135.262C99.8743 135.262 99.7076 135.117 99.684 134.921C99.6588 134.71 99.8098 134.518 100.022 134.493C101.07 134.369 102.135 134.305 103.189 134.305H103.191H103.221C103.435 134.305 103.608 134.477 103.608 134.691C103.608 134.904 103.435 135.077 103.221 135.077H103.191H103.189C102.167 135.077 101.131 135.138 100.113 135.259C100.099 135.262 100.084 135.262 100.068 135.262Z"
            fill="#039D55"
          />
          <path
            d="M223.173 222.491C222.891 222.491 222.66 222.265 222.657 221.982C222.654 221.698 222.882 221.464 223.167 221.461C224.238 221.449 225.321 221.406 226.386 221.334C226.671 221.314 226.916 221.529 226.935 221.813C226.954 222.097 226.74 222.342 226.455 222.36C225.371 222.434 224.27 222.478 223.179 222.491C223.178 222.491 223.176 222.491 223.173 222.491ZM218.628 222.365C218.617 222.365 218.604 222.365 218.593 222.364C217.506 222.291 216.408 222.186 215.33 222.053C215.047 222.018 214.847 221.761 214.882 221.479C214.916 221.196 215.174 220.997 215.457 221.031C216.516 221.163 217.596 221.265 218.662 221.336C218.947 221.355 219.161 221.599 219.142 221.883C219.123 222.156 218.897 222.365 218.628 222.365ZM230.942 221.876C230.69 221.876 230.47 221.692 230.432 221.436C230.39 221.155 230.585 220.893 230.867 220.853C231.926 220.696 232.992 220.507 234.037 220.291C234.317 220.233 234.589 220.412 234.647 220.691C234.706 220.969 234.526 221.242 234.246 221.3C233.181 221.519 232.095 221.712 231.018 221.871C230.994 221.874 230.967 221.876 230.942 221.876ZM210.906 221.32C210.871 221.32 210.837 221.317 210.8 221.309C209.734 221.089 208.661 220.837 207.61 220.558C207.334 220.484 207.171 220.203 207.245 219.928C207.319 219.654 207.6 219.49 207.876 219.564C208.908 219.839 209.962 220.087 211.01 220.302C211.288 220.36 211.469 220.631 211.411 220.909C211.36 221.154 211.145 221.32 210.906 221.32ZM238.556 220.211C238.332 220.211 238.126 220.065 238.06 219.84C237.98 219.567 238.137 219.282 238.411 219.202C239.437 218.902 240.467 218.569 241.474 218.212C241.743 218.116 242.037 218.256 242.133 218.524C242.229 218.792 242.089 219.086 241.82 219.181C240.794 219.545 239.745 219.884 238.7 220.189C238.653 220.204 238.604 220.211 238.556 220.211ZM203.398 219.232C203.341 219.232 203.283 219.222 203.225 219.202C202.196 218.838 201.165 218.439 200.161 218.019C199.899 217.909 199.776 217.606 199.886 217.345C199.996 217.083 200.298 216.961 200.561 217.071C201.548 217.485 202.559 217.876 203.569 218.234C203.838 218.329 203.978 218.623 203.882 218.891C203.808 219.1 203.61 219.232 203.398 219.232ZM245.865 217.523C245.669 217.523 245.48 217.41 245.395 217.218C245.278 216.96 245.395 216.655 245.654 216.539C246.628 216.103 247.602 215.634 248.549 215.142C248.803 215.012 249.114 215.109 249.245 215.362C249.375 215.615 249.278 215.925 249.024 216.056C248.06 216.555 247.069 217.033 246.078 217.477C246.008 217.509 245.936 217.523 245.865 217.523ZM196.241 216.133C196.161 216.133 196.08 216.114 196.003 216.075C195.036 215.574 194.071 215.039 193.133 214.485C192.888 214.341 192.808 214.024 192.952 213.78C193.097 213.536 193.413 213.456 193.659 213.6C194.579 214.144 195.528 214.67 196.477 215.161C196.73 215.292 196.828 215.602 196.697 215.855C196.607 216.031 196.426 216.133 196.241 216.133ZM252.734 213.865C252.563 213.865 252.395 213.779 252.297 213.624C252.146 213.382 252.22 213.065 252.461 212.914C253.365 212.349 254.267 211.752 255.14 211.136C255.373 210.972 255.694 211.028 255.859 211.259C256.024 211.491 255.968 211.811 255.736 211.976C254.847 212.602 253.93 213.212 253.008 213.787C252.923 213.84 252.829 213.865 252.734 213.865ZM189.578 212.087C189.475 212.087 189.372 212.056 189.28 211.993C188.391 211.367 187.509 210.707 186.656 210.03C186.433 209.853 186.396 209.53 186.573 209.307C186.75 209.084 187.075 209.048 187.298 209.224C188.135 209.887 189.003 210.537 189.877 211.152C190.109 211.317 190.165 211.637 190.001 211.869C189.899 212.012 189.74 212.087 189.578 212.087ZM259.045 209.307C258.897 209.307 258.751 209.244 258.649 209.122C258.466 208.904 258.496 208.579 258.715 208.397C259.536 207.714 260.348 206.999 261.128 206.272C261.336 206.078 261.663 206.089 261.857 206.297C262.052 206.504 262.041 206.831 261.831 207.024C261.037 207.764 260.209 208.493 259.374 209.188C259.278 209.268 259.161 209.307 259.045 209.307ZM183.53 207.179C183.404 207.179 183.278 207.134 183.177 207.041C182.383 206.3 181.598 205.527 180.844 204.742C180.647 204.537 180.654 204.212 180.86 204.014C181.066 203.818 181.392 203.824 181.59 204.03C182.329 204.8 183.1 205.56 183.881 206.288C184.088 206.482 184.101 206.807 183.906 207.014C183.805 207.124 183.668 207.179 183.53 207.179ZM264.679 203.936C264.555 203.936 264.431 203.892 264.331 203.801C264.121 203.609 264.106 203.283 264.298 203.074C265.019 202.287 265.727 201.469 266.404 200.642C266.583 200.423 266.909 200.388 267.129 200.568C267.349 200.747 267.384 201.072 267.203 201.292C266.515 202.134 265.795 202.968 265.06 203.768C264.958 203.879 264.819 203.936 264.679 203.936ZM178.206 201.502C178.056 201.502 177.907 201.438 177.806 201.312C177.118 200.471 176.447 199.6 175.808 198.722C175.641 198.491 175.691 198.169 175.923 198.003C176.154 197.837 176.477 197.887 176.643 198.117C177.271 198.98 177.93 199.836 178.605 200.663C178.785 200.882 178.752 201.207 178.531 201.386C178.437 201.464 178.32 201.502 178.206 201.502ZM269.533 197.852C269.432 197.852 269.33 197.822 269.24 197.761C269.006 197.6 268.948 197.28 269.108 197.046C269.715 196.167 270.307 195.26 270.862 194.35C271.01 194.107 271.328 194.03 271.572 194.179C271.816 194.326 271.893 194.643 271.743 194.887C271.177 195.814 270.576 196.738 269.956 197.633C269.859 197.774 269.697 197.852 269.533 197.852ZM173.704 195.16C173.53 195.16 173.361 195.072 173.264 194.913C172.697 193.988 172.15 193.034 171.639 192.078C171.505 191.827 171.599 191.516 171.851 191.381C172.103 191.248 172.414 191.342 172.549 191.593C173.053 192.531 173.589 193.468 174.146 194.378C174.294 194.621 174.217 194.937 173.975 195.086C173.888 195.135 173.796 195.16 173.704 195.16ZM273.515 191.163C273.436 191.163 273.358 191.146 273.284 191.108C273.029 190.98 272.927 190.67 273.056 190.418C273.539 189.464 274 188.485 274.426 187.506C274.539 187.245 274.844 187.126 275.104 187.239C275.365 187.352 275.485 187.655 275.372 187.915C274.937 188.911 274.468 189.909 273.976 190.879C273.886 191.06 273.704 191.163 273.515 191.163ZM170.112 188.268C169.914 188.268 169.724 188.152 169.639 187.959C169.205 186.966 168.794 185.946 168.418 184.931C168.319 184.664 168.456 184.369 168.723 184.27C168.991 184.171 169.286 184.308 169.386 184.574C169.755 185.572 170.158 186.572 170.584 187.548C170.698 187.808 170.578 188.111 170.317 188.226C170.251 188.254 170.18 188.268 170.112 188.268ZM276.545 183.992C276.49 183.992 276.434 183.983 276.378 183.964C276.109 183.871 275.965 183.58 276.058 183.311C276.404 182.302 276.725 181.27 277.013 180.245C277.09 179.972 277.374 179.812 277.648 179.887C277.922 179.964 278.082 180.248 278.007 180.521C277.714 181.566 277.387 182.618 277.035 183.644C276.961 183.857 276.759 183.992 276.545 183.992ZM167.498 180.953C167.273 180.953 167.065 180.804 167 180.578C166.706 179.533 166.439 178.466 166.206 177.405C166.144 177.127 166.321 176.853 166.599 176.792C166.878 176.73 167.153 176.906 167.214 177.184C167.444 178.226 167.707 179.274 167.995 180.3C168.072 180.573 167.911 180.857 167.638 180.934C167.59 180.947 167.543 180.953 167.498 180.953ZM278.558 176.482C278.525 176.482 278.491 176.479 278.458 176.473C278.178 176.418 277.996 176.148 278.051 175.869C278.255 174.824 278.432 173.757 278.576 172.701C278.614 172.42 278.875 172.222 279.157 172.26C279.439 172.298 279.637 172.558 279.599 172.839C279.453 173.915 279.272 175.001 279.064 176.065C279.015 176.313 278.8 176.482 278.558 176.482ZM165.912 173.343C165.658 173.343 165.436 173.156 165.402 172.899C165.254 171.825 165.136 170.732 165.049 169.647C165.027 169.363 165.238 169.115 165.523 169.093C165.808 169.07 166.056 169.282 166.078 169.566C166.163 170.63 166.28 171.703 166.425 172.759C166.464 173.04 166.266 173.3 165.984 173.338C165.959 173.341 165.935 173.343 165.912 173.343ZM279.522 168.77C279.513 168.77 279.503 168.77 279.492 168.769C279.207 168.753 278.99 168.51 279.006 168.226C279.066 167.163 279.096 166.084 279.096 165.015V164.904C279.096 164.62 279.325 164.389 279.61 164.389C279.61 164.389 279.61 164.389 279.612 164.389C279.896 164.389 280.128 164.618 280.128 164.902V165.015C280.128 166.103 280.096 167.201 280.036 168.284C280.021 168.558 279.793 168.77 279.522 168.77ZM165.38 165.588C165.095 165.588 164.864 165.359 164.864 165.075V165.018C164.864 163.95 164.894 162.869 164.952 161.806C164.968 161.522 165.211 161.304 165.495 161.322C165.779 161.337 165.997 161.58 165.981 161.863C165.923 162.906 165.894 163.967 165.894 165.017V165.072C165.896 165.356 165.666 165.586 165.38 165.588ZM279.424 160.885C279.159 160.885 278.932 160.681 278.912 160.411C278.825 159.348 278.707 158.273 278.562 157.22C278.523 156.939 278.721 156.679 279.003 156.639C279.284 156.6 279.546 156.798 279.585 157.079C279.733 158.152 279.854 159.246 279.94 160.328C279.964 160.611 279.752 160.86 279.468 160.882C279.451 160.885 279.439 160.885 279.424 160.885ZM165.897 157.832C165.874 157.832 165.852 157.83 165.828 157.827C165.547 157.789 165.348 157.531 165.386 157.248C165.532 156.172 165.71 155.086 165.918 154.022C165.971 153.743 166.242 153.561 166.522 153.614C166.802 153.667 166.985 153.937 166.931 154.217C166.728 155.262 166.552 156.329 166.409 157.386C166.373 157.645 166.152 157.832 165.897 157.832ZM278.27 153.2C278.032 153.2 277.82 153.037 277.766 152.797C277.536 151.755 277.272 150.708 276.983 149.682C276.906 149.409 277.064 149.125 277.34 149.046C277.615 148.969 277.898 149.128 277.977 149.403C278.271 150.448 278.54 151.515 278.775 152.574C278.836 152.851 278.66 153.126 278.383 153.187C278.344 153.195 278.306 153.2 278.27 153.2ZM167.468 150.218C167.422 150.218 167.375 150.212 167.329 150.2C167.055 150.123 166.893 149.84 166.97 149.566C167.263 148.521 167.589 147.469 167.94 146.442C168.031 146.173 168.325 146.029 168.594 146.121C168.863 146.214 169.008 146.506 168.915 146.774C168.571 147.783 168.25 148.816 167.963 149.842C167.9 150.069 167.693 150.218 167.468 150.218ZM276.072 145.742C275.862 145.742 275.666 145.613 275.587 145.406C275.217 144.408 274.811 143.408 274.385 142.434C274.27 142.174 274.39 141.871 274.651 141.756C274.912 141.643 275.216 141.761 275.331 142.021C275.765 143.015 276.177 144.033 276.555 145.048C276.654 145.315 276.517 145.61 276.249 145.709C276.191 145.732 276.13 145.742 276.072 145.742ZM170.07 142.889C170.001 142.889 169.931 142.875 169.865 142.847C169.604 142.734 169.485 142.431 169.598 142.17C170.031 141.174 170.499 140.176 170.99 139.205C171.118 138.951 171.429 138.849 171.683 138.977C171.937 139.104 172.04 139.415 171.911 139.668C171.429 140.622 170.97 141.601 170.543 142.58C170.459 142.773 170.27 142.889 170.07 142.889ZM272.873 138.663C272.689 138.663 272.511 138.565 272.418 138.392C271.915 137.454 271.375 136.517 270.818 135.608C270.67 135.367 270.746 135.05 270.99 134.901C271.232 134.752 271.55 134.829 271.699 135.072C272.267 135.998 272.815 136.95 273.328 137.906C273.463 138.157 273.367 138.467 273.117 138.602C273.038 138.645 272.955 138.663 272.873 138.663ZM173.657 135.98C173.566 135.98 173.473 135.957 173.39 135.905C173.146 135.757 173.069 135.44 173.217 135.197C173.783 134.27 174.382 133.346 175.001 132.45C175.163 132.216 175.484 132.156 175.718 132.318C175.953 132.48 176.012 132.8 175.85 133.033C175.243 133.912 174.655 134.821 174.098 135.731C174.002 135.891 173.832 135.98 173.657 135.98ZM268.734 132.083C268.575 132.083 268.417 132.009 268.315 131.871C267.687 131.009 267.027 130.154 266.35 129.329C266.169 129.109 266.202 128.784 266.422 128.605C266.643 128.425 266.968 128.458 267.148 128.678C267.837 129.519 268.509 130.389 269.149 131.267C269.316 131.497 269.265 131.819 269.034 131.985C268.944 132.051 268.839 132.083 268.734 132.083ZM178.154 129.625C178.039 129.625 177.924 129.588 177.828 129.511C177.606 129.332 177.573 129.007 177.753 128.787C178.438 127.945 179.159 127.112 179.892 126.308C180.084 126.098 180.41 126.084 180.621 126.275C180.832 126.467 180.846 126.791 180.654 127.002C179.933 127.789 179.225 128.609 178.552 129.437C178.453 129.559 178.303 129.625 178.154 129.625ZM263.735 126.12C263.6 126.12 263.465 126.067 263.362 125.961C262.623 125.191 261.85 124.433 261.068 123.707C260.859 123.514 260.848 123.187 261.043 122.98C261.237 122.773 261.564 122.76 261.772 122.955C262.568 123.694 263.353 124.468 264.106 125.251C264.303 125.456 264.297 125.781 264.091 125.979C263.992 126.073 263.863 126.12 263.735 126.12ZM183.47 123.939C183.332 123.939 183.195 123.884 183.094 123.776C182.899 123.568 182.91 123.242 183.118 123.049C183.912 122.307 184.738 121.579 185.574 120.884C185.792 120.702 186.118 120.73 186.3 120.948C186.483 121.166 186.455 121.491 186.236 121.673C185.416 122.356 184.604 123.073 183.824 123.801C183.723 123.892 183.597 123.939 183.47 123.939ZM257.97 120.885C257.859 120.885 257.745 120.849 257.65 120.774C256.811 120.11 255.944 119.464 255.069 118.849C254.836 118.685 254.781 118.364 254.945 118.131C255.109 117.899 255.431 117.844 255.664 118.008C256.554 118.634 257.437 119.293 258.291 119.967C258.515 120.145 258.553 120.468 258.375 120.691C258.273 120.818 258.123 120.885 257.97 120.885ZM189.508 119.024C189.346 119.024 189.187 118.949 189.087 118.808C188.922 118.576 188.977 118.255 189.21 118.091C190.097 117.463 191.014 116.853 191.936 116.278C192.177 116.128 192.496 116.2 192.647 116.442C192.798 116.682 192.726 117 192.484 117.151C191.579 117.716 190.679 118.315 189.806 118.932C189.716 118.993 189.611 119.024 189.508 119.024ZM251.547 116.476C251.457 116.476 251.367 116.453 251.284 116.404C250.363 115.859 249.415 115.335 248.464 114.846C248.211 114.715 248.112 114.405 248.243 114.152C248.373 113.9 248.685 113.801 248.938 113.931C249.906 114.43 250.872 114.963 251.809 115.517C252.055 115.662 252.135 115.977 251.99 116.222C251.894 116.387 251.723 116.476 251.547 116.476ZM196.156 114.974C195.97 114.974 195.789 114.874 195.698 114.697C195.566 114.444 195.665 114.133 195.917 114.003C196.881 113.503 197.872 113.022 198.863 112.578C199.123 112.462 199.428 112.577 199.546 112.836C199.663 113.095 199.548 113.399 199.288 113.517C198.316 113.953 197.342 114.424 196.395 114.916C196.318 114.956 196.236 114.974 196.156 114.974ZM244.577 112.982C244.511 112.982 244.443 112.969 244.377 112.941C243.389 112.528 242.377 112.137 241.367 111.781C241.098 111.687 240.958 111.392 241.052 111.125C241.147 110.857 241.443 110.717 241.71 110.812C242.737 111.174 243.77 111.571 244.775 111.992C245.038 112.101 245.162 112.403 245.05 112.665C244.97 112.862 244.78 112.982 244.577 112.982ZM203.291 111.869C203.078 111.869 202.88 111.737 202.805 111.527C202.709 111.259 202.849 110.965 203.118 110.87C204.142 110.504 205.191 110.165 206.236 109.859C206.51 109.779 206.796 109.934 206.876 110.207C206.957 110.48 206.799 110.766 206.527 110.846C205.501 111.146 204.471 111.48 203.465 111.838C203.407 111.858 203.349 111.869 203.291 111.869ZM237.195 110.473C237.151 110.473 237.107 110.466 237.062 110.455C236.03 110.182 234.975 109.934 233.928 109.721C233.65 109.664 233.469 109.391 233.527 109.114C233.584 108.836 233.858 108.656 234.136 108.714C235.203 108.932 236.276 109.184 237.328 109.462C237.604 109.534 237.767 109.817 237.695 110.091C237.632 110.32 237.423 110.473 237.195 110.473ZM210.794 109.765C210.555 109.765 210.341 109.599 210.289 109.355C210.231 109.078 210.41 108.805 210.689 108.747C211.754 108.525 212.839 108.332 213.917 108.172C214.199 108.13 214.462 108.324 214.504 108.605C214.546 108.886 214.351 109.148 214.07 109.191C213.012 109.348 211.946 109.537 210.899 109.756C210.863 109.762 210.829 109.765 210.794 109.765ZM229.543 108.998C229.523 108.998 229.501 108.996 229.481 108.994C228.422 108.864 227.342 108.762 226.274 108.693C225.989 108.674 225.774 108.43 225.793 108.146C225.812 107.862 226.055 107.648 226.342 107.665C227.429 107.738 228.527 107.84 229.606 107.973C229.89 108.007 230.091 108.265 230.055 108.546C230.023 108.806 229.8 108.998 229.543 108.998ZM218.514 108.704C218.245 108.704 218.019 108.497 218 108.226C217.981 107.942 218.195 107.697 218.48 107.676C219.564 107.603 220.667 107.557 221.755 107.543C222.042 107.538 222.275 107.767 222.278 108.051C222.281 108.335 222.053 108.569 221.768 108.572C220.697 108.587 219.614 108.63 218.551 108.703C218.538 108.704 218.525 108.704 218.514 108.704Z"
            fill="#039D55"
          />
          <path
            d="M59.9209 86.793H62.0402C62.3407 86.793 62.5862 87.0362 62.5862 87.3375C62.5862 87.6372 62.3423 87.8819 62.0402 87.8819H59.9209C59.6204 87.8819 59.375 87.6387 59.375 87.3375C59.375 87.1868 59.4364 87.0519 59.5355 86.953C59.6346 86.8542 59.7699 86.793 59.9209 86.793Z"
            fill="#039D55"
          />
          <path
            d="M67.8346 87.3255C67.8377 87.4792 67.7764 87.6189 67.6757 87.7193C67.5766 87.8182 67.4413 87.8778 67.2902 87.8778H65.1709C64.8704 87.8778 64.625 87.6346 64.625 87.3333C64.625 87.0336 64.8689 86.7888 65.1709 86.7888H67.2776C67.575 86.792 67.8283 87.0273 67.8346 87.3255Z"
            fill="#039D55"
          />
          <path
            d="M64.15 83.6617V85.7753C64.15 86.075 63.9061 86.3198 63.6041 86.3198C63.3035 86.3198 63.0581 86.0766 63.0581 85.7753V83.6617C63.0581 83.362 63.302 83.1172 63.6041 83.1172C63.7551 83.1172 63.8904 83.1784 63.9895 83.2757C64.0886 83.3745 64.15 83.511 64.15 83.6617Z"
            fill="#039D55"
          />
          <path
            d="M63.6041 88.3516C63.9046 88.3516 64.15 88.5948 64.15 88.896V91.0097C64.15 91.3094 63.9061 91.5541 63.6041 91.5541C63.453 91.5541 63.3177 91.4929 63.2186 91.3941C63.1195 91.2952 63.0581 91.1603 63.0581 91.0097V88.8945C63.0597 88.5948 63.3035 88.3516 63.6041 88.3516Z"
            fill="#039D55"
          />
          <path
            d="M80.4688 186.66C79.2007 186.66 78.1733 187.685 78.1733 188.95C78.1733 190.214 79.2007 191.239 80.4688 191.239C81.7369 191.239 82.7643 190.214 82.7643 188.95C82.7643 187.685 81.7369 186.66 80.4688 186.66ZM80.4688 190.22C79.764 190.22 79.1929 189.651 79.1929 188.948C79.1929 188.245 79.764 187.675 80.4688 187.675C81.1737 187.675 81.7448 188.245 81.7448 188.948C81.7432 189.651 81.1721 190.22 80.4688 190.22Z"
            fill="#039D55"
          />
          <path
            d="M91.1625 166.348H92.4542C92.6383 166.348 92.7862 166.497 92.7862 166.679C92.7862 166.862 92.6367 167.01 92.4542 167.01H91.1625C90.9785 167.01 90.8306 166.861 90.8306 166.679C90.8306 166.588 90.8683 166.505 90.9281 166.445C90.9879 166.385 91.0697 166.348 91.1625 166.348Z"
            fill="#039D55"
          />
          <path
            d="M95.9849 166.676C95.9865 166.771 95.9488 166.855 95.8874 166.916C95.8276 166.976 95.7442 167.014 95.653 167.014H94.3613C94.1772 167.014 94.0293 166.865 94.0293 166.683C94.0293 166.499 94.1788 166.352 94.3613 166.352H95.6451C95.8276 166.35 95.9818 166.494 95.9849 166.676Z"
            fill="#039D55"
          />
          <path
            d="M93.7396 164.44V165.729C93.7396 165.912 93.5902 166.06 93.4077 166.06C93.2236 166.06 93.0757 165.911 93.0757 165.729V164.44C93.0757 164.257 93.2251 164.109 93.4077 164.109C93.4989 164.109 93.5823 164.147 93.6421 164.207C93.7019 164.266 93.7396 164.349 93.7396 164.44Z"
            fill="#039D55"
          />
          <path
            d="M93.4077 167.301C93.5917 167.301 93.7396 167.45 93.7396 167.632V168.92C93.7396 169.104 93.5902 169.251 93.4077 169.251C93.3164 169.251 93.233 169.214 93.1732 169.154C93.1134 169.095 93.0757 169.011 93.0757 168.92V167.632C93.0757 167.449 93.2236 167.301 93.4077 167.301Z"
            fill="#039D55"
          />
          <path
            d="M241.746 126.727C240.478 126.727 239.451 127.751 239.451 129.016C239.451 130.281 240.478 131.305 241.746 131.305C243.014 131.305 244.042 130.281 244.042 129.016C244.042 127.751 243.014 126.727 241.746 126.727ZM241.746 130.288C241.041 130.288 240.47 129.719 240.47 129.016C240.47 128.313 241.041 127.743 241.746 127.743C242.451 127.743 243.022 128.313 243.022 129.016C243.021 129.719 242.449 130.288 241.746 130.288Z"
            fill="#039D55"
          />
          <path
            d="M251.15 144.672H252.744C252.97 144.672 253.154 144.855 253.154 145.081C253.154 145.307 252.97 145.491 252.744 145.491H251.15C250.923 145.491 250.739 145.307 250.739 145.081C250.739 144.968 250.785 144.866 250.859 144.793C250.933 144.719 251.037 144.672 251.15 144.672Z"
            fill="#039D55"
          />
          <path
            d="M257.103 145.071C257.105 145.187 257.059 145.292 256.984 145.368C256.91 145.442 256.808 145.487 256.694 145.487H255.101C254.874 145.487 254.69 145.303 254.69 145.078C254.69 144.852 254.874 144.668 255.101 144.668H256.685C256.908 144.67 257.099 144.847 257.103 145.071Z"
            fill="#039D55"
          />
          <path
            d="M254.331 142.316V143.905C254.331 144.131 254.147 144.315 253.92 144.315C253.694 144.315 253.51 144.131 253.51 143.905V142.316C253.51 142.09 253.694 141.906 253.92 141.906C254.034 141.906 254.136 141.952 254.21 142.026C254.285 142.101 254.331 142.203 254.331 142.316Z"
            fill="#039D55"
          />
          <path
            d="M253.922 145.844C254.149 145.844 254.333 146.027 254.333 146.253V147.843C254.333 148.069 254.149 148.252 253.922 148.252C253.809 148.252 253.707 148.207 253.633 148.133C253.559 148.059 253.513 147.957 253.513 147.844V146.255C253.512 146.027 253.696 145.844 253.922 145.844Z"
            fill="#039D55"
          />
          <path
            d="M235.127 236.418H236.721C236.948 236.418 237.132 236.602 237.132 236.828C237.132 237.053 236.948 237.237 236.721 237.237H235.127C234.901 237.237 234.717 237.053 234.717 236.828C234.717 236.715 234.762 236.613 234.836 236.539C234.912 236.463 235.014 236.418 235.127 236.418Z"
            fill="#039D55"
          />
          <path
            d="M241.08 236.817C241.081 236.933 241.035 237.039 240.96 237.114C240.886 237.188 240.784 237.233 240.67 237.233H239.077C238.85 237.233 238.666 237.05 238.666 236.824C238.666 236.598 238.85 236.414 239.077 236.414H240.661C240.884 236.416 241.075 236.593 241.08 236.817Z"
            fill="#039D55"
          />
          <path
            d="M238.309 234.062V235.651C238.309 235.877 238.125 236.061 237.898 236.061C237.671 236.061 237.487 235.877 237.487 235.651V234.062C237.487 233.836 237.671 233.652 237.898 233.652C238.011 233.652 238.113 233.698 238.187 233.772C238.261 233.847 238.309 233.949 238.309 234.062Z"
            fill="#039D55"
          />
          <path
            d="M237.898 237.59C238.124 237.59 238.308 237.773 238.308 237.999V239.589C238.308 239.815 238.124 239.998 237.898 239.998C237.785 239.998 237.682 239.953 237.608 239.879C237.534 239.805 237.489 239.703 237.489 239.59V238.001C237.487 237.773 237.671 237.59 237.898 237.59Z"
            fill="#039D55"
          />
          <path
            d="M211.068 36C209.8 36 208.772 37.0246 208.772 38.2893C208.772 39.5541 209.8 40.5787 211.068 40.5787C212.336 40.5787 213.363 39.5541 213.363 38.2893C213.363 37.0246 212.336 36 211.068 36ZM211.068 39.5619C210.363 39.5619 209.792 38.9923 209.792 38.2893C209.792 37.5864 210.363 37.0168 211.068 37.0168C211.773 37.0168 212.344 37.5864 212.344 38.2893C212.344 38.9923 211.773 39.5619 211.068 39.5619Z"
            fill="#039D55"
          />
          <path
            d="M235.886 61.0781H237.48C237.706 61.0781 237.89 61.2617 237.89 61.4877C237.89 61.7136 237.706 61.8972 237.48 61.8972H235.886C235.659 61.8972 235.475 61.7136 235.475 61.4877C235.475 61.3747 235.521 61.2727 235.595 61.1989C235.669 61.1236 235.772 61.0781 235.886 61.0781Z"
            fill="#039D55"
          />
          <path
            d="M241.838 61.4775C241.839 61.5936 241.794 61.6987 241.718 61.774C241.644 61.8478 241.542 61.8933 241.429 61.8933H239.835C239.608 61.8933 239.424 61.7097 239.424 61.4838C239.424 61.2578 239.608 61.0742 239.835 61.0742H241.419C241.644 61.0758 241.835 61.2531 241.838 61.4775Z"
            fill="#039D55"
          />
          <path
            d="M239.067 58.722V60.3116C239.067 60.5375 238.883 60.7211 238.656 60.7211C238.43 60.7211 238.246 60.5375 238.246 60.3116V58.722C238.246 58.4961 238.43 58.3125 238.656 58.3125C238.77 58.3125 238.872 58.358 238.946 58.4318C239.021 58.5071 239.067 58.6091 239.067 58.722Z"
            fill="#039D55"
          />
          <path
            d="M238.656 62.25C238.883 62.25 239.067 62.4336 239.067 62.6595V64.2491C239.067 64.475 238.883 64.6586 238.656 64.6586C238.543 64.6586 238.441 64.6131 238.367 64.5394C238.293 64.4656 238.247 64.3636 238.247 64.2506V62.6595C238.246 62.4336 238.43 62.25 238.656 62.25Z"
            fill="#039D55"
          />
          <path
            d="M265.137 134.299C264.061 134.299 262.977 134.205 261.915 134.021C261.704 133.985 261.564 133.784 261.6 133.574C261.636 133.364 261.836 133.224 262.047 133.26C263.065 133.437 264.103 133.527 265.134 133.527H265.187H265.189C265.401 133.527 265.574 133.699 265.576 133.911C265.576 134.125 265.404 134.297 265.19 134.299H265.137ZM269.657 133.736C269.484 133.736 269.327 133.619 269.283 133.445C269.231 133.238 269.355 133.029 269.563 132.976C270.579 132.719 271.581 132.37 272.539 131.941C272.734 131.853 272.963 131.94 273.051 132.135C273.139 132.33 273.051 132.557 272.856 132.645C271.857 133.092 270.812 133.456 269.751 133.725C269.722 133.731 269.689 133.736 269.657 133.736ZM257.671 132.727C257.619 132.727 257.566 132.716 257.516 132.694C256.512 132.253 255.541 131.722 254.632 131.115C254.454 130.996 254.407 130.757 254.525 130.58C254.644 130.403 254.883 130.356 255.061 130.473C255.933 131.054 256.863 131.564 257.826 131.986C258.021 132.072 258.11 132.3 258.024 132.494C257.961 132.64 257.819 132.727 257.671 132.727ZM276.553 130.354C276.438 130.354 276.325 130.304 276.248 130.207C276.116 130.039 276.145 129.797 276.314 129.665C277.141 129.017 277.915 128.294 278.616 127.516C278.759 127.357 279.003 127.343 279.162 127.486C279.32 127.629 279.335 127.872 279.191 128.03C278.461 128.843 277.654 129.596 276.792 130.273C276.72 130.327 276.636 130.354 276.553 130.354ZM251.439 128.245C251.334 128.245 251.229 128.203 251.153 128.118C250.418 127.308 249.751 126.43 249.168 125.504C249.054 125.324 249.108 125.085 249.289 124.972C249.47 124.859 249.709 124.912 249.822 125.093C250.382 125.981 251.022 126.824 251.726 127.6C251.869 127.759 251.856 128.002 251.699 128.145C251.625 128.212 251.532 128.245 251.439 128.245ZM281.473 124.471C281.411 124.471 281.35 124.457 281.293 124.428C281.105 124.329 281.032 124.095 281.131 123.907C281.619 122.984 282.03 122.008 282.352 121.007L282.36 120.983C282.425 120.781 282.643 120.668 282.846 120.734C283.049 120.798 283.163 121.016 283.096 121.219L283.089 121.244C282.752 122.287 282.324 123.306 281.816 124.267C281.747 124.396 281.613 124.471 281.473 124.471ZM247.577 121.622C247.415 121.622 247.264 121.518 247.21 121.357C246.867 120.318 246.614 119.245 246.457 118.165C246.427 117.955 246.573 117.759 246.784 117.727C246.995 117.696 247.191 117.844 247.223 118.054C247.374 119.089 247.616 120.119 247.945 121.114C248.013 121.316 247.901 121.534 247.698 121.602C247.659 121.616 247.618 121.622 247.577 121.622ZM283.573 117.073C283.565 117.073 283.556 117.073 283.546 117.071C283.332 117.057 283.172 116.874 283.186 116.66C283.213 116.268 283.225 115.87 283.225 115.476C283.225 114.825 283.189 114.165 283.118 113.517C283.095 113.306 283.249 113.116 283.461 113.092C283.674 113.069 283.864 113.222 283.888 113.434C283.962 114.111 284 114.798 284 115.477C284 115.888 283.985 116.304 283.959 116.714C283.944 116.918 283.775 117.073 283.573 117.073ZM246.746 114.005C246.734 114.005 246.719 114.005 246.707 114.004C246.494 113.982 246.34 113.792 246.361 113.58C246.472 112.498 246.68 111.413 246.981 110.36C247.039 110.155 247.253 110.036 247.459 110.094C247.665 110.152 247.785 110.365 247.726 110.571C247.438 111.581 247.239 112.621 247.132 113.659C247.11 113.858 246.941 114.005 246.746 114.005ZM282.467 109.493C282.31 109.493 282.162 109.397 282.104 109.24C281.74 108.258 281.287 107.301 280.758 106.395C280.652 106.212 280.713 105.975 280.899 105.868C281.083 105.761 281.32 105.822 281.427 106.008C281.978 106.951 282.45 107.949 282.829 108.973C282.903 109.173 282.801 109.395 282.601 109.469C282.558 109.485 282.513 109.493 282.467 109.493ZM249.092 106.711C249.028 106.711 248.961 106.695 248.9 106.66C248.714 106.555 248.65 106.318 248.755 106.135C249.298 105.185 249.929 104.28 250.631 103.441C250.768 103.277 251.011 103.255 251.175 103.392C251.339 103.528 251.361 103.772 251.225 103.935C250.554 104.74 249.948 105.609 249.427 106.518C249.358 106.64 249.227 106.711 249.092 106.711ZM278.372 103.009C278.271 103.009 278.17 102.97 278.095 102.891C277.362 102.14 276.559 101.448 275.708 100.837C275.535 100.713 275.496 100.472 275.62 100.299C275.744 100.127 275.987 100.087 276.16 100.211C277.047 100.848 277.886 101.57 278.65 102.355C278.8 102.507 278.795 102.752 278.642 102.901C278.567 102.973 278.469 103.009 278.372 103.009ZM254.215 100.999C254.095 100.999 253.977 100.944 253.902 100.841C253.776 100.668 253.814 100.426 253.985 100.301C254.868 99.6574 255.815 99.0847 256.797 98.6029C256.989 98.5088 257.22 98.5872 257.314 98.7787C257.409 98.9701 257.33 99.2008 257.138 99.2949C256.196 99.7578 255.288 100.305 254.44 100.924C254.374 100.974 254.293 100.999 254.215 100.999ZM271.984 98.7536C271.937 98.7536 271.888 98.7442 271.841 98.7253C271.459 98.5731 271.064 98.4319 270.67 98.3064C270.063 98.1118 269.442 97.947 268.822 97.8168C268.612 97.7729 268.479 97.5689 268.523 97.3602C268.567 97.1515 268.771 97.0181 268.981 97.0621C269.627 97.197 270.275 97.368 270.908 97.572C271.318 97.7038 271.729 97.8513 272.127 98.0098C272.325 98.0883 272.423 98.3126 272.343 98.5104C272.283 98.661 272.138 98.7536 271.984 98.7536ZM261.219 97.8545C261.041 97.8545 260.881 97.7305 260.842 97.5501C260.796 97.3414 260.928 97.1358 261.137 97.0903C262.209 96.8581 263.306 96.7184 264.399 96.6761C264.611 96.6682 264.792 96.833 264.8 97.0464C264.808 97.2598 264.643 97.4386 264.429 97.4465C263.381 97.4873 262.328 97.6207 261.303 97.8435C261.274 97.8513 261.248 97.8545 261.219 97.8545Z"
            fill="#039D55"
          />
          <path
            d="M73.7125 155.799C73.1855 155.799 72.6505 155.782 72.1235 155.751C71.9095 155.738 71.7474 155.555 71.7616 155.341C71.7742 155.128 71.9583 154.968 72.1723 154.98C72.6836 155.012 73.2012 155.029 73.7125 155.029C74.2317 155.029 74.7588 155.012 75.2764 154.979C75.4888 154.966 75.6729 155.126 75.6871 155.34C75.7012 155.553 75.5392 155.735 75.3252 155.749C74.7903 155.782 74.2475 155.799 73.7125 155.799ZM67.7842 155.093C67.7543 155.093 67.7229 155.09 67.693 155.082C67.0715 154.932 66.4453 154.757 65.8349 154.561C65.4321 154.433 65.0277 154.291 64.6328 154.144C64.433 154.069 64.3323 153.846 64.4063 153.647C64.4818 153.447 64.7052 153.347 64.905 153.422C65.2873 153.566 65.6807 153.703 66.0709 153.827C66.664 154.017 67.2697 154.188 67.8739 154.332C68.0816 154.382 68.209 154.591 68.1587 154.798C68.1162 154.974 67.9589 155.093 67.7842 155.093ZM79.6613 155.089C79.4867 155.089 79.3293 154.971 79.2853 154.794C79.2349 154.586 79.3624 154.378 79.5701 154.327C80.5723 154.084 81.5698 153.777 82.5358 153.411C82.7356 153.336 82.959 153.436 83.0345 153.636C83.1101 153.835 83.0094 154.058 82.8096 154.133C81.8136 154.51 80.7847 154.828 79.7526 155.078C79.7211 155.084 79.6912 155.089 79.6613 155.089ZM60.7908 152.266C60.7231 152.266 60.6554 152.248 60.5941 152.212C59.6768 151.671 58.7863 151.067 57.9446 150.416C57.7762 150.285 57.7448 150.042 57.8769 149.874C58.0075 149.706 58.2514 149.675 58.4197 149.805C59.2347 150.436 60.1001 151.023 60.989 151.547C61.1731 151.655 61.2344 151.892 61.1243 152.076C61.0519 152.198 60.9229 152.266 60.7908 152.266ZM86.6469 152.245C86.5148 152.245 86.3857 152.178 86.3134 152.057C86.2048 151.873 86.2646 151.636 86.4487 151.528C87.336 151.003 88.1998 150.416 89.0148 149.783C89.1831 149.653 89.427 149.683 89.5576 149.851C89.6882 150.019 89.6583 150.262 89.4899 150.392C88.6498 151.043 87.7593 151.647 86.8436 152.19C86.7822 152.228 86.7146 152.245 86.6469 152.245ZM54.9458 147.503C54.8404 147.503 54.735 147.461 54.6595 147.376C53.9468 146.59 53.2749 145.749 52.6629 144.88C52.5402 144.706 52.5827 144.464 52.7573 144.342C52.932 144.219 53.1742 144.262 53.297 144.436C53.8901 145.28 54.5415 146.094 55.2337 146.858C55.3769 147.017 55.3643 147.26 55.207 147.403C55.1315 147.47 55.0386 147.503 54.9458 147.503ZM92.4887 147.481C92.3959 147.481 92.3031 147.448 92.2291 147.381C92.0702 147.238 92.0592 146.993 92.2024 146.837C92.8962 146.072 93.5476 145.258 94.1391 144.414C94.2619 144.24 94.5026 144.197 94.6772 144.318C94.8518 144.44 94.8943 144.681 94.7732 144.855C94.1627 145.726 93.4909 146.565 92.7766 147.353C92.6995 147.439 92.5941 147.481 92.4887 147.481ZM50.7718 141.235C50.6254 141.235 50.487 141.153 50.4209 141.012C49.9694 140.05 49.5745 139.051 49.2472 138.042C49.1811 137.839 49.2928 137.621 49.4958 137.555C49.6988 137.489 49.9174 137.601 49.9835 137.803C50.3013 138.782 50.6852 139.752 51.1226 140.684C51.2139 140.877 51.1289 141.106 50.9354 141.197C50.8819 141.222 50.8268 141.235 50.7718 141.235ZM96.6565 141.207C96.6014 141.207 96.5463 141.196 96.4944 141.17C96.3009 141.081 96.2159 140.852 96.3056 140.657C96.7383 139.727 97.119 138.756 97.4368 137.773L97.4463 137.742C97.5108 137.539 97.7295 137.426 97.9324 137.492C98.1354 137.557 98.2487 137.775 98.1826 137.977L98.1716 138.009C97.8443 139.022 97.4526 140.022 97.0057 140.982C96.9412 141.123 96.8012 141.207 96.6565 141.207ZM48.6257 134.021C48.4354 134.021 48.2702 133.882 48.2434 133.689C48.0955 132.638 48.0137 131.566 47.9996 130.505C47.9964 130.292 48.1679 130.118 48.3819 130.114C48.5958 130.11 48.7705 130.282 48.7736 130.496C48.7878 131.523 48.8665 132.562 49.0096 133.582C49.0395 133.794 48.8916 133.989 48.6792 134.018C48.6619 134.02 48.643 134.021 48.6257 134.021ZM98.7931 133.954C98.7757 133.954 98.7584 133.952 98.7396 133.951C98.5272 133.923 98.3793 133.726 98.4092 133.516C98.5492 132.496 98.6263 131.456 98.6389 130.428C98.6404 130.216 98.8135 130.047 99.0259 130.047C99.0275 130.047 99.0291 130.047 99.0306 130.047C99.2446 130.048 99.4161 130.224 99.4129 130.438C99.4004 131.498 99.3217 132.57 99.1769 133.623C99.1502 133.814 98.9834 133.954 98.7931 133.954ZM48.7154 126.498C48.695 126.498 48.6729 126.496 48.6525 126.493C48.4417 126.458 48.2985 126.261 48.3331 126.05C48.5046 125.005 48.7437 123.959 49.0458 122.937C49.1056 122.733 49.3212 122.616 49.5257 122.675C49.7302 122.735 49.8482 122.95 49.7869 123.154C49.4942 124.144 49.2614 125.161 49.0962 126.174C49.0663 126.363 48.9011 126.498 48.7154 126.498ZM98.6876 126.43C98.502 126.43 98.3384 126.297 98.3069 126.107C98.1385 125.093 97.9025 124.078 97.6083 123.091C97.547 122.887 97.6634 122.672 97.8695 122.611C98.074 122.55 98.2896 122.666 98.3509 122.871C98.6546 123.89 98.8969 124.936 99.0715 125.981C99.1061 126.192 98.9645 126.391 98.7537 126.425C98.7301 126.429 98.7081 126.43 98.6876 126.43ZM51.0204 119.333C50.9621 119.333 50.9039 119.32 50.8489 119.294C50.6569 119.2 50.5782 118.967 50.6726 118.777C51.1446 117.823 51.6827 116.891 52.2696 116.006C52.3876 115.829 52.6283 115.78 52.8061 115.898C52.9839 116.016 53.0326 116.254 52.9146 116.433C52.3451 117.292 51.8243 118.195 51.3665 119.12C51.3004 119.253 51.1635 119.333 51.0204 119.333ZM96.3591 119.275C96.2175 119.275 96.0806 119.196 96.013 119.061C95.552 118.14 95.0281 117.238 94.4569 116.381C94.3389 116.204 94.3877 115.964 94.5655 115.846C94.7433 115.729 94.984 115.777 95.102 115.955C95.6904 116.838 96.2301 117.769 96.7068 118.718C96.8028 118.909 96.7241 119.14 96.5337 119.236C96.4755 119.261 96.4173 119.275 96.3591 119.275ZM55.3407 113.16C55.2448 113.16 55.1488 113.125 55.0748 113.053C54.9206 112.906 54.9144 112.663 55.0607 112.507C55.7938 111.738 56.5837 111.007 57.4081 110.334C57.5733 110.199 57.8172 110.223 57.9525 110.389C58.0878 110.554 58.0642 110.797 57.8974 110.932C57.0981 111.585 56.3319 112.294 55.6208 113.039C55.5453 113.119 55.443 113.16 55.3407 113.16ZM92.0246 113.113C91.9223 113.113 91.82 113.072 91.7445 112.994C91.0318 112.247 90.2656 111.539 89.4663 110.888C89.3011 110.753 89.276 110.51 89.4113 110.345C89.5466 110.18 89.7904 110.155 89.9556 110.29C90.7801 110.962 91.5699 111.691 92.3062 112.46C92.4541 112.614 92.4478 112.859 92.2936 113.006C92.2165 113.078 92.1205 113.113 92.0246 113.113ZM61.2989 108.539C61.1636 108.539 61.033 108.468 60.9607 108.343C60.8553 108.158 60.9213 107.922 61.1086 107.817C62.0368 107.298 63.006 106.83 63.9909 106.428C64.1892 106.348 64.4141 106.443 64.496 106.64C64.5762 106.838 64.4818 107.062 64.2836 107.144C63.3285 107.533 62.3877 107.987 61.4877 108.492C61.428 108.523 61.3619 108.539 61.2989 108.539ZM86.0585 108.503C85.994 108.503 85.9295 108.487 85.8697 108.454C84.9697 107.954 84.0273 107.505 83.0692 107.117C82.8709 107.037 82.7749 106.813 82.8552 106.615C82.9354 106.418 83.1604 106.322 83.3587 106.402C84.3483 106.8 85.319 107.263 86.2473 107.779C86.4345 107.883 86.5006 108.118 86.3968 108.305C86.3275 108.432 86.1954 108.503 86.0585 108.503ZM68.3506 105.865C68.1728 105.865 68.0124 105.741 67.973 105.561C67.9274 105.352 68.0596 105.147 68.2688 105.101C69.3088 104.875 70.3739 104.713 71.4328 104.619C71.6452 104.6 71.834 104.757 71.8529 104.969C71.8717 105.181 71.7144 105.369 71.502 105.388C70.4746 105.479 69.4425 105.636 68.434 105.856C68.4057 105.862 68.3774 105.865 68.3506 105.865ZM78.9974 105.854C78.9706 105.854 78.9423 105.851 78.9156 105.845C77.9039 105.628 76.8718 105.473 75.8444 105.383C75.632 105.365 75.4747 105.178 75.492 104.966C75.5109 104.754 75.6981 104.597 75.9105 104.615C76.9693 104.707 78.0345 104.866 79.076 105.09C79.2853 105.136 79.4175 105.34 79.3734 105.548C79.3356 105.73 79.1752 105.854 78.9974 105.854Z"
            fill="#039D55"
          />
          <path
            d="M225.385 131.49L222.573 148.884L222.034 152.222C222.034 154.806 216.497 188.856 213.629 188.856L168.279 157.604L117.948 192.432C115.082 192.432 112.067 155.791 112.067 153.207L111.867 148.884L111.063 131.542L119.155 124.569L165.045 85.0191C166.937 83.6603 169.621 83.6603 171.514 85.0191L217.361 124.569L225.385 131.49Z"
            fill="#214333"
          />
          <path
            d="M203.62 131.382V184.575H132.573V116.023H188.064L203.62 131.382Z"
            fill="white"
          />
          <path
            d="M203.62 131.383V133.177H186.266V115.957L188.064 116.025L203.62 131.383Z"
            fill="#2B7D57"
          />
          <path
            d="M203.62 131.382H188.064V116.023L203.62 131.382Z"
            fill="white"
          />
          <path
            d="M169.384 167.752L195.393 141.291C202.224 134.341 211.973 130.371 222.206 130.371C224.608 130.371 226.557 131.95 226.557 133.897V169.949V204.624C226.557 206.571 223.308 209.529 220.906 209.529H206.128L169.384 172.146C168.155 170.895 168.155 169.001 169.384 167.752Z"
            fill="#235940"
          />
          <path
            d="M167.175 167.705L141.165 141.244C134.333 134.294 124.585 130.324 114.352 130.324C111.949 130.324 110 131.903 110 133.85V169.902V205C110 206.948 112.79 209.529 115.192 209.529L130.43 209.48L167.173 172.099C168.404 170.848 168.404 168.956 167.175 167.705Z"
            fill="#235940"
          />
          <path
            d="M226.559 190.146V205.399C226.559 207.679 224.233 209.528 221.367 209.528H115.192C112.325 209.528 110 207.679 110 205.399V190.146L165.045 155.291C165.94 154.724 167.013 154.425 168.097 154.393C169.301 154.359 170.517 154.66 171.516 155.291L226.559 190.146Z"
            fill="#2B7D57"
          />
          <path
            d="M110 183.787L157.902 158.27L158.838 159.224L110 190.148V183.787Z"
            fill="#05894B"
          />
          <path
            d="M226.559 183.787L178.657 158.27L177.721 159.224L226.559 190.148V183.787Z"
            fill="#05894B"
          />
          <path
            d="M168.097 138.512C162.523 138.512 158.004 143.018 158.004 148.578H178.191C178.19 143.018 173.671 138.512 168.097 138.512Z"
            fill="#C4DAD0"
          />
          <path
            d="M168.097 137.755C170.982 137.755 173.32 135.423 173.32 132.545C173.32 129.668 170.982 127.336 168.097 127.336C165.212 127.336 162.874 129.668 162.874 132.545C162.874 135.423 165.212 137.755 168.097 137.755Z"
            fill="#C4DAD0"
          />
          <path
            d="M215.043 54.353C215.043 55.2479 214.683 56.0634 214.084 56.6552C213.501 57.247 212.686 57.6151 211.792 57.6151H142.251C140.463 57.6151 139 56.15 139 54.3602C139 53.4653 139.36 52.6498 139.959 52.058C140.542 51.4662 141.357 51.0981 142.251 51.0981H145.538C146.835 48.0814 149.833 45.9668 153.322 45.9668C155.672 45.9668 157.791 46.9266 159.333 48.4711C161.38 44.9925 165.157 42.6541 169.489 42.6541C170.679 42.6541 171.825 42.8346 172.906 43.1593C175.169 38.9013 179.638 36 184.799 36C190.99 36 196.194 40.1859 197.766 45.8802C198.905 45.31 200.195 44.9852 201.557 44.9852C205.421 44.9852 208.671 47.569 209.702 51.0981H211.792C213.58 51.0981 215.043 52.5632 215.043 54.353Z"
            fill="#039D55"
            fillOpacity="0.3"
          />
        </g>
      </g>
      <defs>
        <clipPath id="clip0_1404_8548">
          <rect
            width="331"
            height="248"
            fill="white"
            transform="translate(0 0.824219)"
          />
        </clipPath>
        <clipPath id="clip1_1404_8548">
          <rect
            width="236"
            height="204"
            fill="white"
            transform="translate(48 36)"
          />
        </clipPath>
      </defs>
    </svg>
  );
};

export default SubscribeImage;
