import { useTheme } from "@mui/material";

const GuestModalSvg = () => {
	const theme = useTheme();
	return (
		<svg
			width="163"
			viewBox="0 0 163 170"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g clipPath="url(#clip0_1384_2841)">
				<path
					d="M115.168 41.8488L119.179 132.108C119.449 138.182 114.748 143.101 108.69 143.101H37.1384C31.0729 143.101 25.942 138.182 25.6723 132.108L21.6619 41.8488C21.3922 35.7827 26.0854 30.8564 32.1509 30.8564H103.701C109.759 30.8564 114.898 35.7827 115.168 41.8488H115.168Z"
					fill="white"
				/>
				<path
					d="M108.69 143.257H37.1385C31.0032 143.257 25.7884 138.258 25.5158 132.115L21.5055 41.855C21.3735 38.8734 22.4091 36.0712 24.4227 33.9622C26.4335 31.8571 29.1782 30.6982 32.151 30.6982H103.702C109.838 30.6982 115.052 35.6972 115.325 41.8408L119.335 132.1C119.468 135.082 118.431 137.884 116.418 139.992C114.407 142.097 111.662 143.257 108.689 143.257H108.69ZM32.152 31.0137C29.2659 31.0137 26.6014 32.1385 24.651 34.1804C22.6967 36.2261 21.6922 38.947 21.8205 41.8417L25.8299 132.101C26.0959 138.08 31.1692 142.944 37.1394 142.944H108.691C111.577 142.944 114.241 141.819 116.193 139.776C118.146 137.73 119.152 135.01 119.022 132.116L115.012 41.8559C114.746 35.8776 109.673 31.0137 103.703 31.0137H32.152Z"
					fill="#242B2B"
				/>
				<path
					d="M112.995 132.385C113.049 133.619 112.637 134.759 111.832 135.602C111.03 136.442 109.912 136.903 108.688 136.903H37.1405C34.3996 136.903 31.9813 134.582 31.8578 131.834L29.8564 76.7829C29.8017 75.5504 30.2138 74.4095 31.0193 73.5661C31.821 72.7293 32.9349 72.2646 34.1591 72.2646H105.711C108.451 72.2646 110.87 74.5861 110.993 77.3344L112.995 132.385Z"
					fill="#E5E8FF"
				/>
				<path
					d="M31.3356 39.0085C31.3932 40.2967 30.3934 41.3432 29.1079 41.3432C27.8223 41.3432 26.7292 40.2958 26.6717 39.0085C26.6141 37.7212 27.6139 36.6738 28.8994 36.6738C30.185 36.6738 31.2781 37.7212 31.3356 39.0085Z"
					fill="#FF4148"
				/>
				<path
					d="M37.2785 39.0085C37.336 40.2967 36.3363 41.3432 35.0507 41.3432C33.7652 41.3432 32.6721 40.2958 32.6145 39.0085C32.557 37.7212 33.5568 36.6738 34.8423 36.6738C36.1278 36.6738 37.221 37.7212 37.2785 39.0085Z"
					fill="#FFD24F"
				/>
				<path
					d="M43.222 39.0085C43.2795 40.2967 42.2798 41.3432 40.9942 41.3432C39.7087 41.3432 38.6156 40.2958 38.558 39.0085C38.5005 37.7212 39.5003 36.6738 40.7858 36.6738C42.0713 36.6738 43.1645 37.7212 43.222 39.0085Z"
					fill="#04B5A4"
				/>
				<path
					d="M113.988 53.3675C113.988 53.3675 109.715 73.0809 102.304 73.7845C96.263 74.3578 82.9964 61.1167 82.9964 61.1167L88.7846 50.7911L100.486 61.0525L107.361 49.2422L113.988 53.3685V53.3675Z"
					fill="#FFCFC5"
				/>
				<path
					d="M96.6361 55.3237C96.4947 56.9869 93.9255 61.2954 91.7722 64.4716C91.1394 65.4019 90.5442 66.2349 90.0557 66.8752C89.3888 67.7536 88.921 68.2702 88.8418 68.1738C88.8418 68.1738 87.4591 67.5987 85.6331 66.4172C81.155 63.5243 74.0114 56.9907 77.9944 46.3553C77.9944 46.3553 81.6681 46.1588 85.9915 47.7606C90.9517 49.6032 96.6371 55.3237 96.6371 55.3237H96.6361Z"
					fill="#009F55"
				/>
				<path
					d="M90.0561 66.8775C89.3892 67.7559 88.9214 68.2725 88.8422 68.1761C88.8422 68.1761 87.4595 67.601 85.6335 66.4195L87.0502 54.5752L90.0561 66.8775Z"
					fill="black"
				/>
				<path
					d="M113.58 166.847L104.364 161.858L102.606 159.935L92.4034 161.381L91.8431 169.055C91.7592 169.467 92.0695 169.845 92.4807 169.845H113.975C114.337 169.845 114.63 169.552 114.63 169.189V168.408C114.63 167.72 114.219 167.107 113.582 166.846L113.58 166.847Z"
					fill="#161C1C"
				/>
				<path
					d="M102.605 159.935L102.124 153.244L92.6671 152.166L92.403 161.381C96.4775 163.101 100.321 162.577 102.605 159.935Z"
					fill="#FFCFC5"
				/>
				<path
					d="M104.79 165.288L104.513 165.14C105.252 163.759 106.6 163.621 106.656 163.616L106.686 163.93C106.636 163.934 105.447 164.062 104.791 165.289L104.79 165.288Z"
					fill="white"
				/>
				<path
					d="M106.809 166.415L106.532 166.267C107.271 164.886 108.619 164.748 108.676 164.743L108.705 165.057C108.655 165.061 107.467 165.189 106.81 166.416L106.809 166.415Z"
					fill="white"
				/>
				<path
					d="M89.0397 113.402L89.5867 156.413L105.333 157.653L105.536 154.288L105.728 151.089L107.403 114.522C107.562 111.87 106.801 109.242 105.25 107.082L84.7096 78.5166L70.6564 92.5114L89.0406 113.402H89.0397Z"
					fill="#000548"
				/>
				<path
					d="M87.9643 155.176C88.0256 156.208 88.8376 157.065 89.8949 157.15L104.771 158.358C105.931 158.452 106.946 157.586 107.04 156.426C107.048 156.325 107.047 156.224 107.042 156.128C106.98 155.097 106.168 154.239 105.111 154.154L90.2345 152.946C89.0753 152.853 88.0605 153.718 87.9662 154.879C87.9577 154.98 87.9586 155.081 87.9643 155.176Z"
					fill="#444BA1"
				/>
				<path
					d="M96.8757 153.413L105.536 154.288L105.728 151.088L96.8757 153.413Z"
					fill="#161C1C"
				/>
				<path
					d="M81.885 78.5166C80.9182 89.934 76.2373 116.137 73.7124 136.905H56.0714C57.6088 115.513 59.6583 88.5362 60.8005 79.767L81.884 78.5166H81.885Z"
					fill="#000548"
				/>
				<path
					d="M78.5977 103.837L78.2874 103.79C78.8561 100.045 79.4551 96.0885 79.9757 92.4893L80.2869 92.5336C79.7663 96.1348 79.1664 100.092 78.5977 103.837Z"
					fill="white"
				/>
				<path
					d="M57.1435 89.1161C61.9621 91.6661 85.2385 92.6577 91.6568 86.9797C93.1621 84.9567 92.4339 83.5023 91.222 81.1931C88.301 75.6218 88.2859 52.126 86.1562 49.1122C82.7476 44.2842 61.2481 44.7895 58.0197 49.6213C57.151 50.9161 56.7869 53.8061 56.7058 57.3431C56.6672 58.942 56.6879 60.6751 56.7445 62.4506C56.8049 64.3433 56.9067 66.2888 57.0274 68.174C57.1651 70.3245 57.3245 72.4013 57.4764 74.2477C57.6952 77.0385 56.918 80.7917 56.9529 81.9874C56.9709 82.7052 56.9388 83.1585 56.8152 83.2643C54.1725 85.5848 55.1477 88.0536 57.1435 89.1151V89.1161Z"
					fill="#009F55"
				/>
				<path
					d="M56.7446 62.4523C56.805 64.3449 56.9069 66.2905 57.0276 68.1756C57.1653 70.3261 57.3247 72.4029 57.4765 74.2493L81.2085 75.7623L59.6241 71.7021C59.6241 71.7021 63.2025 66.1025 63.8212 64.1891C65.1567 60.0505 64.5842 56.626 64.5842 56.626L59.0488 59.6048L56.7456 62.4523H56.7446Z"
					fill="black"
				/>
				<path
					d="M57.7847 81.774C57.7847 81.774 60.1832 83.7516 66.7137 83.4466C66.7137 83.4466 60.8114 82.4549 57.9205 80.4971C57.9404 81.2148 57.9064 81.6701 57.7857 81.774H57.7847Z"
					fill="black"
				/>
				<path
					d="M85.9324 25.0783C85.9324 25.0783 85.6174 29.7505 82.587 30.4484C79.5566 31.1463 78.7465 28.2299 78.7465 28.2299L80.1622 24.6523H82.8898L85.9315 25.0773L85.9324 25.0783Z"
					fill="black"
				/>
				<path
					d="M68.9575 43.464L70.7466 47.205L75.9067 47.749L78.7475 48.4016L77.9307 43.9088L78.0024 42.7935L78.1977 39.843L69.4903 34.2217C69.5224 34.6089 69.546 34.9933 69.5611 35.3701C69.7639 39.8619 68.9556 43.465 68.9556 43.465L68.9575 43.464Z"
					fill="#FFCFC5"
				/>
				<path
					d="M69.4908 34.2197C69.5228 34.6069 69.5464 34.9913 69.5615 35.3681C69.6171 35.3776 69.6699 35.3832 69.7228 35.387C69.819 35.6194 69.8869 35.8866 69.9293 36.1832C71.0932 40.1631 74.9621 42.7376 78.0019 42.7905L78.1971 39.8401L69.4898 34.2188L69.4908 34.2197Z"
					fill="#FC9B88"
				/>
				<path
					d="M68.9557 43.4629C69.8432 45.569 73.1905 46.7675 75.9049 47.7459C75.9049 47.7459 75.0891 52.5588 74.2704 52.5418C73.5169 52.5267 66.6638 50.0362 66.7572 46.2896C67.839 45.5161 68.121 44.5594 68.9557 43.4629Z"
					fill="#00D572"
				/>
				<path
					d="M75.9058 47.7473C75.9058 47.7473 77.4536 51.4061 78.5241 51.7093C79.7426 52.054 80.6999 48.6323 80.5236 46.8218L77.9299 43.9072C78.1562 45.1558 78.5929 46.2646 75.9058 47.7473Z"
					fill="#00D572"
				/>
				<path
					d="M77.6869 41.6688C74.6046 41.8067 70.4905 39.1896 69.2814 35.0624C69.2408 34.7668 69.1739 34.4986 69.0767 34.2662C68.3524 34.2086 67.5724 33.7581 67.0102 33.0064C66.1199 31.8145 66.1114 30.3015 67.0036 29.6413C67.512 29.2607 68.1873 29.2324 68.8513 29.5119C69.3464 25.1911 71.7496 21.8884 74.8498 21.6759C76.9191 21.5342 78.863 22.7931 80.2523 24.8926C80.4202 25.1448 80.5815 25.4111 80.7305 25.6879C81.5925 27.267 82.165 29.2154 82.3037 31.3422C82.6913 36.9286 80.9276 41.5205 77.6878 41.6679L77.6869 41.6688Z"
					fill="#FFCFC5"
				/>
				<path
					d="M61.9552 30.8976C62.192 32.7544 63.0786 34.5271 64.4244 35.8286C65.6892 37.0526 67.3568 37.8554 69.1016 38.0924C69.4091 38.2237 69.66 38.269 69.8326 38.2095C69.8326 38.2095 69.4053 35.907 69.278 35.0617C69.2431 34.768 69.1752 34.4988 69.0762 34.2655C68.5678 34.2268 68.0302 33.9897 67.5643 33.5931C67.3634 33.4269 67.1757 33.2285 67.0097 33.0056C66.4617 32.2699 66.2504 31.4142 66.374 30.7135C66.4513 30.2752 66.6598 29.8927 67.0031 29.6377C67.5114 29.259 68.1867 29.2307 68.847 29.5102C68.847 29.5102 70.3409 30.3026 70.2419 31.6645L71.2624 32.0602C71.3897 31.5257 71.4991 30.9921 71.6406 30.4651C71.8811 29.5735 72.0226 29.5527 72.9158 29.6906C74.6503 29.956 76.4621 29.6661 78.0061 28.817C78.5078 28.5412 78.9954 28.1871 79.2605 27.6884C82.1117 28.2088 85.2269 26.9735 86.919 24.6114C87.3604 23.9928 87.7141 23.1504 87.3179 22.4996C86.9331 21.8631 86.0673 21.7677 85.326 21.746C84.8384 21.728 84.3366 21.7139 83.8848 21.8942C83.4755 22.0567 83.1152 22.425 83.0652 22.8529C83.1359 21.6185 83.0586 20.3416 82.5172 19.2309C81.9589 18.0844 80.8073 17.1512 79.5321 17.1654C78.3277 17.1796 77.1657 18.2619 77.2393 19.4396C77.045 17.9786 75.9141 16.6488 74.4946 16.2493C73.0073 15.8319 71.2907 16.4372 70.39 17.6924C69.493 18.9514 69.4751 20.777 70.3513 22.0501C69.3025 21.6751 68.2386 21.2926 67.1257 21.2114C66.0127 21.1302 64.83 21.3852 64.0066 22.1379C63.0984 22.969 62.7701 24.2431 62.4985 25.4454C62.0958 27.2351 61.7213 29.0749 61.9543 30.8967L61.9552 30.8976Z"
					fill="black"
				/>
				<path
					d="M79.8677 32.1055L80.7448 35.5801L79.0255 35.7841L79.8677 32.1055Z"
					fill="#FC9B88"
				/>
				<path
					d="M86.7355 77.4627C87.341 77.5713 91.8616 78.3741 91.6947 79.0532C91.5315 79.7464 86.6733 79.0928 86.1913 79.0314C86.6157 79.1221 90.7119 80.0193 90.3893 80.8174C90.0526 81.6598 84.9661 81.8959 84.9661 81.8959C84.9661 81.8959 83.806 82.8904 82.7723 83.0907C82.0942 83.221 80.2635 83.2361 79.0893 83.1889C79.0893 83.1889 71.5996 84.1768 63.6883 84.1768C55.777 84.1768 47.3885 83.1823 45.753 79.1958C43.1141 72.7518 51.1517 59.3379 51.1517 59.3379L61.9595 65.3719L56.6193 73.2212L78.6186 75.69L81.2076 75.7627C82.197 74.7966 84.8332 72.4156 86.3196 72.9351C86.943 73.1532 86.8638 73.6613 86.4865 74.2422C88.7709 73.9296 92.0625 73.6283 92.2181 74.2167C92.552 75.4369 88.5021 75.9922 87.092 75.8723C87.092 75.8723 92.5086 76.8819 92.552 77.4552C92.5879 77.9963 87.3854 77.5241 86.7365 77.4665L86.7355 77.4627Z"
					fill="#FFCFC5"
				/>
				<path
					d="M60.4084 47.8203C60.4084 47.8203 54.6004 49.3531 52.1727 54.796C51.0041 57.4159 49.279 61.8104 49.279 61.8104C48.6896 62.9692 60.6395 69.0363 61.229 67.8775C61.229 67.8775 64.7074 60.5401 64.5725 56.6074C64.3924 51.3648 60.4084 47.8213 60.4084 47.8213V47.8203Z"
					fill="#009F55"
				/>
				<path
					d="M110.278 36.4489L115.769 53.4584C116.027 54.2574 116.804 54.7249 117.499 54.5001L118.906 54.0449C119.601 53.8201 119.958 52.9861 119.699 52.1862L114.208 35.1768L110.278 36.4489Z"
					fill="#242B2B"
				/>
				<path
					d="M102.156 37.1017C103.137 38.7214 104.678 39.7887 106.386 40.2004C108.091 40.6264 109.949 40.3931 111.566 39.4109L116.47 36.4331C111.712 33.7886 109.343 29.8777 109.366 24.7012L104.462 27.679C101.228 29.6425 100.196 33.8632 102.156 37.1017Z"
					fill="#007AFD"
				/>
				<path
					d="M108.041 40.5624C107.476 40.5624 106.909 40.4925 106.347 40.3527C104.531 39.9145 102.994 38.7887 102.021 37.1832C100.018 33.8748 101.076 29.5502 104.38 27.5442L109.523 24.4209V24.7014C109.5 29.7929 111.864 33.6935 116.545 36.2954L116.782 36.4267L111.646 39.5452C110.539 40.2177 109.299 40.5624 108.04 40.5624H108.041ZM102.29 37.0198C103.219 38.5536 104.687 39.6283 106.422 40.0467C108.155 40.4793 109.952 40.2054 111.484 39.2761L116.158 36.438C111.609 33.8247 109.272 29.9723 109.209 24.98L104.542 27.8133C101.386 29.7296 100.375 33.8597 102.289 37.0198H102.29Z"
					fill="#242B2B"
				/>
				<path
					d="M118.215 12.4492C118.215 12.4492 114.364 15.5886 109.366 24.7024C109.28 29.9299 111.729 33.7974 116.47 36.4362C116.47 36.4362 127.703 35.811 131.631 34.604L118.215 12.4492Z"
					fill="white"
				/>
				<path
					d="M116.435 36.5956L116.395 36.5739C111.542 33.8737 109.125 29.8787 109.209 24.7003V24.6616L109.228 24.6276C114.184 15.5902 118.077 12.3593 118.116 12.3272L118.256 12.2129L131.869 34.6944L131.676 34.753C127.775 35.9524 116.591 36.5862 116.478 36.5918L116.433 36.5947L116.435 36.5956ZM109.523 24.7438C109.453 29.7644 111.803 33.6442 116.508 36.2764C117.28 36.232 127.495 35.6238 131.392 34.5103L118.179 12.6898C117.452 13.3424 113.916 16.7434 109.524 24.7438H109.523Z"
					fill="#242B2B"
				/>
				<path
					d="M119.659 26.7227C120.238 27.6784 120.856 28.5643 121.492 29.3803C124.971 33.806 129.18 36.0925 131.632 34.604C134.54 32.8389 133.892 26.4459 130.189 20.3297C126.485 14.2135 121.124 10.6832 118.216 12.4493C115.765 13.9377 115.844 18.7317 118.154 23.8676C118.583 24.8092 119.081 25.7669 119.659 26.7236V26.7227Z"
					fill="#242B2B"
				/>
				<path
					d="M129.918 35.2102C127.46 35.2102 124.217 33.0994 121.369 29.4765C120.696 28.6123 120.076 27.7132 119.525 26.8027C118.974 25.8932 118.465 24.9271 118.011 23.9307C115.61 18.5917 115.66 13.8147 118.134 12.3131C121.11 10.5064 126.579 14.065 130.322 20.2474C132.125 23.2252 133.269 26.3626 133.545 29.0817C133.824 31.8423 133.173 33.8502 131.712 34.738C131.187 35.0572 130.58 35.2102 129.917 35.2102H129.918ZM119.952 12.1469C119.342 12.1469 118.783 12.2876 118.298 12.5832C115.963 14.0008 115.963 18.6135 118.298 23.8022C118.746 24.7864 119.249 25.7412 119.794 26.6403C120.34 27.5404 120.953 28.4291 121.617 29.2829C125.132 33.7529 129.216 35.8855 131.551 34.4688C132.903 33.6481 133.5 31.7469 133.234 29.1138C132.963 26.4401 131.834 23.3499 130.055 20.4107C127.029 15.4146 122.893 12.1469 119.953 12.1469H119.952Z"
					fill="#242B2B"
				/>
				<path
					d="M119.66 26.7216C120.239 27.6774 120.857 28.5632 121.492 29.3792C122.008 29.3367 122.509 29.1743 122.983 28.8862C124.669 27.8625 125.207 25.6629 124.184 23.9742C123.162 22.2855 120.965 21.7472 119.279 22.77C118.805 23.0571 118.429 23.4274 118.154 23.8656C118.583 24.8072 119.081 25.7649 119.659 26.7216H119.66Z"
					fill="#007AFD"
				/>
				<path
					d="M121.42 29.5424L121.368 29.4754C120.697 28.6121 120.077 27.713 119.525 26.8026C118.975 25.8931 118.465 24.9269 118.012 23.9305L117.977 23.8531L118.022 23.7813C118.313 23.3176 118.709 22.9323 119.198 22.6348C120.955 21.5675 123.253 22.1314 124.32 23.8918C124.835 24.7437 124.989 25.7467 124.752 26.7157C124.516 27.6847 123.916 28.5026 123.065 29.0201C122.577 29.3167 122.052 29.4895 121.506 29.5349L121.421 29.5415L121.42 29.5424ZM118.333 23.8786C118.773 24.8363 119.264 25.7637 119.794 26.6392C120.324 27.5156 120.919 28.3808 121.564 29.2138C122.03 29.1628 122.479 29.0069 122.901 28.751C124.511 27.7735 125.026 25.6664 124.05 24.0552C123.074 22.443 120.97 21.9264 119.36 22.9039C118.939 23.1599 118.594 23.4876 118.333 23.8776V23.8786Z"
					fill="#242B2B"
				/>
				<path
					d="M116.878 43.336C116.878 43.336 119.906 42.6021 120.331 43.4928C120.756 44.3834 119.748 45.0738 119.748 45.0738C119.748 45.0738 120.653 45.4912 120.53 46.209C120.407 46.9277 119.89 46.9485 119.89 46.9485C119.89 46.9485 120.761 47.3017 120.616 47.892C120.471 48.4823 119.513 48.8449 119.513 48.8449C119.513 48.8449 120.264 49.7875 119.569 50.2049C118.874 50.6224 116.19 52.0032 116.214 50.3891C115.892 50.5327 114.552 49.8017 115.653 49.149C115.653 49.149 114.45 49.2369 114.839 48.0091C114.839 48.0091 113.151 48.0998 113.442 47.3093C113.734 46.5188 115.643 46.1589 117.127 45.1474C117.355 44.9916 116.878 43.335 116.878 43.335V43.336Z"
					fill="#FFCFC5"
				/>
				<path
					d="M114.728 47.94C116.06 47.4168 117.616 46.9503 118.394 45.6602C117.809 47.0778 116.113 47.6378 114.728 47.94Z"
					fill="#F58DA3"
				/>
				<path
					d="M115.606 49.1871C116.938 48.6639 118.494 48.1983 119.271 46.9072C118.685 48.3248 116.989 48.8849 115.606 49.1871Z"
					fill="#F58DA3"
				/>
				<path
					d="M116.157 50.4152C117.079 50.0553 117.985 49.7078 118.856 49.2412C118.105 49.891 117.131 50.265 116.157 50.4152Z"
					fill="#F58DA3"
				/>
				<path
					d="M140.21 9.23146L132.194 15.3662L132.385 15.6161L140.401 9.48134L140.21 9.23146Z"
					fill="#242B2B"
				/>
				<path
					d="M153.815 10.5534L134.375 19.2041L134.502 19.4915L153.942 10.8408L153.815 10.5534Z"
					fill="#242B2B"
				/>
				<path
					d="M136.71 22.3062L136.634 22.6113L147.126 25.2309L147.202 24.9257L136.71 22.3062Z"
					fill="#242B2B"
				/>
				<path
					d="M121.421 29.5424L121.369 29.4754C120.698 28.6121 120.078 27.713 119.526 26.8026C118.975 25.8931 118.466 24.9269 118.012 23.9305L117.977 23.8531L118.023 23.7813C118.314 23.3176 118.709 22.9323 119.199 22.6348C120.956 21.5675 123.254 22.1314 124.32 23.8918C124.836 24.7437 124.99 25.7467 124.753 26.7157C124.516 27.6847 123.917 28.5026 123.066 29.0201C122.577 29.3167 122.053 29.4895 121.507 29.5349L121.422 29.5415L121.421 29.5424ZM118.334 23.8786C118.774 24.8363 119.265 25.7637 119.795 26.6392C120.325 27.5156 120.92 28.3808 121.564 29.2138C122.031 29.1628 122.48 29.0069 122.902 28.751C124.512 27.7735 125.027 25.6664 124.051 24.0552C123.074 22.443 120.971 21.9264 119.361 22.9039C118.94 23.1599 118.594 23.4876 118.334 23.8776V23.8786Z"
					fill="#242B2B"
				/>
				<path
					d="M113.061 55.2182C111.284 55.5402 106.539 50.2079 107.444 49.0453C108.254 48.0055 113.301 40.6926 114.155 41.3962C116.708 43.5023 113.206 45.515 113.206 45.515L115.316 52.1997L113.061 55.2182Z"
					fill="#FFCFC5"
				/>
				<path
					d="M28.3863 104.248L42.1707 92.7101C43.2846 92.0207 43.4798 90.4813 42.5735 89.5359L33.785 78.3045L35.6827 69.0877L28.3873 71.6141L20.5316 63.0706C19.9026 62.3831 18.8877 62.2036 18.0624 62.6371L1.25426 76.1361C0.108312 76.7405 -0.200104 78.2479 0.620451 79.2528L25.7172 103.798C26.368 104.598 27.5092 104.79 28.3863 104.247V104.248Z"
					fill="white"
				/>
				<path
					d="M27.3111 104.709C26.665 104.709 26.0265 104.428 25.5955 103.897L0.510065 79.365C0.0780947 78.8371 -0.0869596 78.1675 0.0450838 77.5149C0.17807 76.8613 0.591178 76.3079 1.18066 75.9972L17.9643 62.5152C18.8764 62.0307 19.9704 62.2234 20.6476 62.9648L28.4335 71.4327L35.892 68.8496L33.9538 78.2657L42.6979 89.4394C43.1525 89.9117 43.3714 90.5718 43.2865 91.2386C43.2025 91.9054 42.8262 92.4909 42.2537 92.8451L28.4684 104.383C28.11 104.604 27.7082 104.711 27.3102 104.711L27.3111 104.709ZM19.015 62.5587C18.7151 62.5587 18.4142 62.6295 18.136 62.7759L1.35231 76.2578C0.822254 76.5412 0.467623 77.0153 0.353499 77.5763C0.240319 78.1363 0.381794 78.7105 0.742084 79.1516L25.8266 103.684C26.4349 104.43 27.4884 104.61 28.2939 104.118L42.0698 92.5873C42.5782 92.2709 42.9017 91.7684 42.9743 91.1961C43.0469 90.6247 42.8592 90.059 42.4603 89.6434L33.6162 78.3422L35.4723 69.3256L28.341 71.7944L20.4156 63.1754C20.0459 62.7712 19.5337 62.5577 19.0141 62.5577L19.015 62.5587Z"
					fill="black"
				/>
				<path
					d="M123.955 88.9991L114.447 71.9764C113.585 70.8469 113.981 69.212 115.264 68.6057L128.502 60.6317L127.061 52.2517L136.551 55.9445L147.806 50.3316C148.709 49.8783 149.807 50.0889 150.474 50.8492L162.289 71.0272C163.216 72.0831 162.946 73.7293 161.727 74.4291L126.833 89.5761C125.865 90.1343 124.635 89.8869 123.955 88.9981V88.9991Z"
					fill="white"
				/>
				<path
					d="M125.731 90.0308C125.011 90.0308 124.297 89.7031 123.831 89.0939L123.818 89.075L114.31 72.0523C113.882 71.4942 113.728 70.7594 113.899 70.0549C114.07 69.3522 114.543 68.7714 115.197 68.4625L128.328 60.5519L126.859 52.0037L136.543 55.772L147.735 50.1903C148.702 49.704 149.877 49.9316 150.591 50.7447L162.423 70.9474C162.88 71.463 163.084 72.1799 162.966 72.8891C162.849 73.5975 162.426 74.2085 161.805 74.5655L126.895 89.721C126.532 89.9307 126.13 90.0308 125.73 90.0308H125.731ZM124.087 88.9116C124.717 89.7276 125.862 89.9543 126.754 89.4396L161.665 74.2841C162.188 73.9818 162.555 73.452 162.657 72.8372C162.759 72.2205 162.582 71.5981 162.17 71.1296L150.338 50.927C149.737 50.247 148.716 50.0487 147.876 50.4709L136.559 56.1148L127.263 52.4976L128.674 60.7096L128.581 60.7653L115.345 68.7392C114.763 69.015 114.352 69.5184 114.204 70.1295C114.056 70.7405 114.189 71.379 114.572 71.8795L124.086 88.9107L124.087 88.9116Z"
					fill="black"
				/>
				<path
					d="M15.5639 79.6209C15.9632 78.737 15.5713 77.6963 14.6886 77.2964C13.8058 76.8965 12.7665 77.289 12.3672 78.1729C11.9679 79.0569 12.3598 80.0976 13.2425 80.4974C14.1253 80.8973 15.1646 80.5049 15.5639 79.6209Z"
					fill="white"
				/>
				<path
					d="M20.6187 78.1339C20.7847 76.7598 20.3962 75.3242 19.4237 74.1928C18.4513 73.0613 17.0913 72.4635 15.7096 72.4238C14.5532 73.8329 14.5391 75.9145 15.768 77.3444C16.997 78.7743 19.055 79.0699 20.6187 78.1339Z"
					fill="white"
				/>
				<path
					d="M14.1837 79.9355L10.186 83.4834L18.1448 92.4755L22.1425 88.9276L14.1837 79.9355Z"
					fill="#C5CDE3"
				/>
				<path
					d="M34.585 94.4826L18.1676 75.9336L16.1995 77.6802L32.617 96.2293L34.585 94.4826Z"
					fill="#C5CDE3"
				/>
				<path
					d="M11.5407 79.5069L10.1862 80.709L11.9365 82.6866L13.291 81.4845L11.5407 79.5069Z"
					fill="#C5CDE3"
				/>
				<path
					d="M14.2951 82.6192L12.9406 83.8213L14.2805 85.3353L15.6351 84.1331L14.2951 82.6192Z"
					fill="#C5CDE3"
				/>
				<path
					d="M17.4119 86.1387L16.0574 87.3408L18.6373 90.2557L19.9918 89.0536L17.4119 86.1387Z"
					fill="#C5CDE3"
				/>
				<path
					d="M141.217 70.8226L139.05 74.3095C138.382 75.3861 136.79 75.2898 136.256 74.1432L134.362 70.0831C133.827 68.9356 134.776 67.6521 136.027 67.8278L140.087 68.401C141.227 68.5635 141.825 69.8441 141.216 70.8226H141.217Z"
					fill="white"
				/>
				<path
					d="M16.8702 15.7309L18.9046 24.5719C19.1196 25.7694 20.3797 26.4626 21.503 26.0017L34.1792 22.2315L43.0459 26.4475L41.7858 19.8449L51.8268 15.9651C52.6341 15.6554 53.1349 14.8394 53.0416 13.978L50.3479 1.85608C50.2168 0.659469 49.0227 -0.120642 47.8768 0.246747L18.168 13.5766C17.2569 13.8666 16.7023 14.7874 16.8711 15.7309H16.8702Z"
					fill="white"
				/>
				<path
					d="M43.2573 26.7232L34.1661 22.3996L21.5475 26.1528C20.9825 26.3851 20.3355 26.3483 19.7875 26.0479C19.2386 25.7457 18.8594 25.2187 18.7491 24.6001L16.7147 15.7592C16.5326 14.742 17.1363 13.7399 18.119 13.4273L47.8118 0.103111C48.4183 -0.0923886 49.0549 -0.00644418 49.5765 0.331667C50.0981 0.670722 50.4357 1.22039 50.5036 1.839L53.1945 13.9449C53.2982 14.8931 52.7578 15.7771 51.8825 16.1124L41.9642 19.9449L43.2573 26.7232ZM34.1916 22.0643L34.2463 22.0898L42.8329 26.1726L41.6067 19.7457L51.7703 15.8187C52.5126 15.5344 52.971 14.7845 52.8851 13.9959L50.1943 1.89094C50.1339 1.34978 49.8481 0.884167 49.4058 0.597056C48.9644 0.309945 48.4239 0.237222 47.9241 0.397778L18.2313 13.7211C17.3834 13.9921 16.8722 14.8402 17.024 15.7006L19.0575 24.5368C19.1528 25.0686 19.4744 25.5162 19.9394 25.7722C20.4043 26.0272 20.9523 26.0583 21.4437 25.8562L34.1925 22.0633L34.1916 22.0643Z"
					fill="black"
				/>
				<path
					d="M44.5276 12.8131C45.4705 11.8689 45.4705 10.3381 44.5276 9.39389C43.5847 8.44969 42.0559 8.44969 41.113 9.39389C40.17 10.3381 40.17 11.8689 41.113 12.8131C42.0559 13.7573 43.5847 13.7573 44.5276 12.8131Z"
					fill="#C5CDE3"
				/>
				<path
					d="M37.1779 14.9195C37.6882 13.6858 37.1032 12.2715 35.8712 11.7605C34.6392 11.2495 33.2268 11.8353 32.7165 13.069C32.2062 14.3027 32.7912 15.717 34.0232 16.228C35.2552 16.739 36.6676 16.1531 37.1779 14.9195Z"
					fill="#C5CDE3"
				/>
				<path
					d="M27.6266 19.2388C28.9244 18.932 29.7282 17.6298 29.4219 16.3302C29.1156 15.0306 27.8151 14.2258 26.5173 14.5325C25.2195 14.8392 24.4157 16.1414 24.722 17.441C25.0283 18.7406 26.3287 19.5455 27.6266 19.2388Z"
					fill="#C5CDE3"
				/>
				<path
					d="M143.04 152.118C143.04 152.118 145.071 149.029 147.833 147.973C151.008 146.759 155.832 147.728 158.518 141.399C158.518 141.399 158.055 148.583 153.909 151.091C150.977 152.865 146.978 151.244 143.04 152.118Z"
					fill="#04B5A4"
				/>
				<path
					d="M142.338 143.51C142.338 143.51 140.511 137.971 143.417 132.014C146.877 124.922 157.543 122.557 157.543 122.557C157.543 122.557 155.059 126.96 156.2 129.772C156.2 129.772 153.472 130.791 152.699 133.319C152.699 133.319 153.717 132.136 156.119 132.3L156.037 134.174C156.037 134.174 154.246 134.052 153.595 134.827L155.915 134.908C155.915 134.908 151.925 143.509 142.338 143.509V143.51Z"
					fill="#04B5A4"
				/>
				<path
					d="M137.88 142.613C137.88 142.613 138.694 138.048 136.577 135.846C134.461 133.645 127.865 130.179 126.685 127.326C126.685 127.326 126.917 134.679 130.064 138.21C133.442 142.001 137.88 142.613 137.88 142.613Z"
					fill="#04B5A4"
				/>
				<path
					d="M137.758 153.455C137.758 153.455 137.627 144.69 132.359 142.937L132.14 144.446C132.14 144.446 129.371 140.369 124.73 141.144C124.73 141.144 126.244 147.751 129.412 150.357C132.832 153.169 137.757 153.455 137.757 153.455H137.758Z"
					fill="#04B5A4"
				/>
				<path
					d="M139.94 156.363L139.645 156.254C139.706 156.089 141.174 152.217 144.422 151.065C145.36 150.732 146.511 150.454 147.729 150.159C150.699 149.441 154.066 148.627 155.671 146.71L155.911 146.912C154.24 148.909 150.82 149.735 147.803 150.465C146.592 150.758 145.449 151.035 144.526 151.362C141.419 152.465 139.954 156.325 139.94 156.364V156.363Z"
					fill="black"
				/>
				<path
					d="M139.948 156.336L139.638 156.285C139.655 156.18 141.37 145.738 142.895 142.184C143.664 140.392 147.832 131.177 154.389 125.778L154.588 126.021C148.087 131.373 143.947 140.528 143.183 142.308C141.674 145.826 139.964 156.23 139.947 156.335L139.948 156.336Z"
					fill="black"
				/>
				<path
					d="M139.636 156.314C139.633 156.218 139.294 146.674 137.734 142.67C136.176 138.672 129.653 132.272 129.587 132.208L129.806 131.982C130.077 132.246 136.444 138.493 138.026 142.555C139.605 146.61 139.946 156.207 139.95 156.304L139.636 156.314Z"
					fill="black"
				/>
				<path
					d="M139.646 156.252C139.603 156.162 135.187 147.165 127.549 143.281L127.692 143.001C135.425 146.934 139.885 156.025 139.929 156.116L139.646 156.253V156.252Z"
					fill="black"
				/>
				<path
					d="M146.631 156.187H132.869C132.588 156.187 132.36 156.415 132.36 156.697V158.448C132.36 158.73 132.588 158.958 132.869 158.958H146.631C146.912 158.958 147.14 158.73 147.14 158.448V156.697C147.14 156.415 146.912 156.187 146.631 156.187Z"
					fill="white"
				/>
				<path
					d="M146.102 158.96L144.972 169.028C144.919 169.492 144.527 169.843 144.06 169.843H135.565C135.246 169.843 134.961 169.679 134.793 169.428C134.719 169.309 134.669 169.175 134.653 169.027L133.647 160.07L133.523 158.959H146.102V158.96Z"
					fill="white"
				/>
				<path
					d="M146.102 158.96L144.972 169.028C144.919 169.492 144.527 169.843 144.06 169.843H135.565C135.246 169.843 134.961 169.679 134.793 169.428C140.542 167.898 143.038 164.85 144.447 160.039L133.647 160.071L133.523 158.96H146.102Z"
					fill="#E5E8FF"
				/>
				<path
					d="M146.632 159.116H132.869C132.502 159.116 132.203 158.816 132.203 158.449V156.696C132.203 156.329 132.502 156.029 132.869 156.029H146.632C146.999 156.029 147.298 156.329 147.298 156.696V158.449C147.298 158.816 146.999 159.116 146.632 159.116ZM132.869 156.344C132.675 156.344 132.517 156.502 132.517 156.696V158.449C132.517 158.644 132.675 158.801 132.869 158.801H146.632C146.826 158.801 146.984 158.644 146.984 158.449V156.696C146.984 156.502 146.825 156.344 146.632 156.344H132.869Z"
					fill="#242B2B"
				/>
				<path
					d="M144.061 170H135.567C135.206 170 134.868 169.82 134.664 169.516C134.571 169.366 134.516 169.209 134.499 169.044L133.349 158.802H146.279L145.13 169.045C145.067 169.59 144.609 170 144.062 170H144.061ZM133.699 159.116L134.81 169.009C134.823 169.127 134.862 169.24 134.927 169.345C135.069 169.556 135.309 169.685 135.566 169.685H144.06C144.447 169.685 144.772 169.395 144.815 169.009L145.926 159.116H133.698H133.699Z"
					fill="#242B2B"
				/>
			</g>
			<defs>
				<clipPath id="clip0_1384_2841">
					<rect width="163" height="170" fill="white" />
				</clipPath>
			</defs>
		</svg>
	);
};

export default GuestModalSvg;
