import React from "react";
import { Box } from "@mui/system";
import { useTheme } from "@mui/material";

const SupportImgSvg = () => {
  const theme = useTheme();
  return (
    <Box maxWidth="520px" marginX="auto">
      <svg
        style={{ width: "100%" }}
        viewBox="0 0 2484 1358"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <g clipPath="url(#clip0_2427_10652)">
          <path
            d="M1241.78 1357.27C1927.6 1357.27 2483.56 1321.07 2483.56 1276.41C2483.56 1231.75 1927.6 1195.55 1241.78 1195.55C555.964 1195.55 0 1231.75 0 1276.41C0 1321.07 555.964 1357.27 1241.78 1357.27Z"
            fill="#003A1F"
            fillOpacity="0.11"
          />
          <path
            d="M690.8 186.679L673.78 193.929C668.99 187.959 663.04 181.769 656.82 177.089L663.65 159.739C665.93 154.079 663.12 147.499 657.46 145.219L633.76 135.639C628.1 133.359 621.6 136.099 619.32 141.759L612.1 159.039C604.37 158.109 595.86 158.409 588.27 159.389L581.02 142.379C578.63 136.769 573.31 135.299 567.7 137.689L544.22 147.689C538.61 150.079 534.21 155.689 536.6 161.299L543.85 178.309C537.88 183.099 532.65 188.639 527.96 194.859L511.09 187.829C505.43 185.549 499.09 188.259 496.81 193.909L487.35 217.559C485.07 223.219 487.87 229.689 493.53 231.969L510.87 239.249C509.94 246.979 510.3 255.549 511.28 263.139L494.26 270.389C488.65 272.779 484.46 279.099 486.85 284.709L496.85 308.189C499.24 313.799 507.57 317.209 513.18 314.819L530.2 307.569C534.99 313.539 540.5 318.699 546.72 323.379L539.67 340.209C537.39 345.869 540.09 352.199 545.75 354.469L569.39 363.919C575.05 366.199 581.52 363.389 583.8 357.729L590.12 340.799C597.85 341.729 605.46 341.769 613.05 340.799L620.3 357.809C622.69 363.419 630.98 366.939 636.59 364.549L660.07 354.549C665.68 352.159 667.12 344.499 664.73 338.889L657.48 321.879C663.45 317.089 669.57 311.169 674.25 304.949L691.56 311.789C697.22 314.069 703.79 311.269 706.06 305.609L715.63 281.919C717.91 276.259 715.16 269.759 709.5 267.489L692.63 261.229C693.56 253.499 693.66 245.949 692.68 238.359L709.69 231.109C715.3 228.719 716.09 221.429 713.7 215.809L703.7 192.329C701.31 186.719 696.38 184.289 690.77 186.679H690.8ZM621.96 297.619C595.51 308.889 564.93 296.579 553.66 270.119C542.39 243.669 554.7 213.089 581.16 201.819C607.61 190.549 638.19 202.859 649.46 229.319C660.73 255.769 648.42 286.349 621.96 297.619Z"
            fill={theme.palette.primary.main}
          />
          <path
            d="M456.3 493.891L458.81 480.651C464.36 480.171 470.52 479.081 475.88 477.211L483.61 488.371C486.11 492.041 491.24 493.011 494.91 490.511L510.31 480.051C513.98 477.551 514.96 472.501 512.46 468.831L504.93 457.461C508.63 453.161 511.89 447.881 514.37 442.891L527.61 445.401C531.97 446.231 535.02 443.601 535.85 439.231L539.31 420.961C540.14 416.601 538.53 411.661 534.16 410.831L520.92 408.321C520.44 402.771 519.21 397.351 517.34 392.001L528.43 384.641C532.1 382.141 533.04 377.201 530.54 373.531L520.06 358.221C517.56 354.551 512.5 353.621 508.83 356.121L497.4 363.671C493.1 359.971 487.76 356.721 482.77 354.241L485.28 341.001C486.11 336.641 483.98 331.541 479.62 330.711L461.35 327.251C456.98 326.421 451.54 330.091 450.72 334.451L448.21 347.691C442.66 348.171 437.3 349.421 431.94 351.281L424.61 340.191C422.11 336.521 417.18 335.591 413.51 338.091L398.21 348.571C394.54 351.071 393.61 356.131 396.11 359.801L403.8 370.491C400.1 374.791 396.99 379.381 394.51 384.371L381.27 381.861C376.91 381.031 371.42 384.631 370.59 388.991L367.13 407.261C366.3 411.621 370.36 415.601 374.72 416.421L387.96 418.931C388.44 424.481 389.54 430.591 391.41 435.941L380.25 443.651C376.58 446.151 375.61 451.261 378.11 454.931L388.57 470.331C391.07 474.001 396.12 474.971 399.79 472.471L410.42 464.801C414.72 468.501 419.25 471.621 424.24 474.101L421.73 487.341C420.9 491.701 425 495.141 429.36 495.971L447.63 499.431C451.99 500.261 455.47 498.261 456.29 493.891H456.3ZM417.04 407.261C420.94 386.681 440.78 373.161 461.36 377.061C481.94 380.961 495.46 400.801 491.56 421.381C487.66 441.961 467.82 455.481 447.24 451.581C426.66 447.681 413.14 427.841 417.04 407.261Z"
            fill="white"
          />
          <path
            d="M1697.63 1289.16H889.32C875.6 1289.16 864.48 1278.04 864.48 1264.32C864.48 1250.6 875.6 1239.48 889.32 1239.48H1697.63C1711.35 1239.48 1722.47 1250.6 1722.47 1264.32C1722.47 1278.04 1711.35 1289.16 1697.63 1289.16Z"
            fill="#363654"
          />
          <path
            d="M1439.09 1116.78H1150.09V1249.7H1439.09V1116.78Z"
            fill="#1B1B43"
          />
          <path
            d="M1779.46 408.971H707.75C681.544 408.971 660.3 430.215 660.3 456.421V1109.26C660.3 1135.47 681.544 1156.71 707.75 1156.71H1779.46C1805.67 1156.71 1826.91 1135.47 1826.91 1109.26V456.421C1826.91 430.215 1805.67 408.971 1779.46 408.971Z"
            fill="#4A4A65"
          />
          <path
            d="M1413.71 1116.78H1025.4V1249.7H1413.71V1116.78Z"
            fill="#000035"
          />
          <path
            d="M1413.71 1116.78H1025.4V1182.83H1413.71V1116.78Z"
            fill="#1B1B2D"
          />
          <path
            d="M684.19 409.5H1755.9C1782.09 409.5 1803.35 430.76 1803.35 456.95V1109.79C1803.35 1135.98 1782.09 1157.24 1755.9 1157.24H684.19C658 1157.24 636.74 1135.98 636.74 1109.79V456.96C636.74 430.77 658 409.51 684.19 409.51V409.5Z"
            fill="#00001D"
          />
          <path
            d="M1785.3 923.12C1711.29 1032.53 1596.7 1086.85 1590.46 1089.72C1547.99 1109.28 1510.98 1118.14 1483.16 1123.6C1397.28 1140.45 1267.95 1150.59 1141.53 1156.7H1778.15C1792.22 1156.7 1803.62 1145.29 1803.62 1131.23V893.33C1798.03 903.36 1791.94 913.3 1785.3 923.12Z"
            fill="#222233"
          />
          <path
            d="M1768.32 1013.04V473.83C1768.32 457.504 1755.09 444.27 1738.76 444.27L701.86 444.27C685.534 444.27 672.3 457.504 672.3 473.83V1013.04C672.3 1029.37 685.534 1042.6 701.86 1042.6H1738.76C1755.09 1042.6 1768.32 1029.37 1768.32 1013.04Z"
            fill="#B9D9CA"
          />
          <path
            d="M1648.82 1084.86H1588.32C1584.91 1084.86 1582.12 1082.07 1582.12 1078.66C1582.12 1075.25 1584.91 1072.46 1588.32 1072.46H1648.82C1652.23 1072.46 1655.02 1075.25 1655.02 1078.66C1655.02 1082.07 1652.23 1084.86 1648.82 1084.86Z"
            fill="#2E3841"
          />
          <path
            d="M1718.07 1084.86H1680.89C1677.48 1084.86 1674.69 1082.07 1674.69 1078.66C1674.69 1075.25 1677.48 1072.46 1680.89 1072.46H1718.07C1721.48 1072.46 1724.27 1075.25 1724.27 1078.66C1724.27 1082.07 1721.48 1084.86 1718.07 1084.86Z"
            fill="#2E3841"
          />
          <path
            d="M1552.39 1084.86H1515.21C1511.8 1084.86 1509.01 1082.07 1509.01 1078.66C1509.01 1075.25 1511.8 1072.46 1515.21 1072.46H1552.39C1555.8 1072.46 1558.59 1075.25 1558.59 1078.66C1558.59 1082.07 1555.8 1084.86 1552.39 1084.86Z"
            fill="#2E3841"
          />
          <path
            d="M1649.19 1072.47H1646.68C1647.13 1073.3 1647.39 1074.24 1647.39 1075.24V1075.97C1647.39 1079.18 1644.77 1081.8 1641.56 1081.8H1582.84C1583.83 1083.62 1585.76 1084.86 1587.96 1084.86H1649.19C1652.4 1084.86 1655.02 1082.24 1655.02 1079.03V1078.3C1655.02 1075.09 1652.4 1072.47 1649.19 1072.47Z"
            fill="#42464B"
          />
          <path
            d="M1718.07 1072.47H1715.76C1716.31 1073.39 1716.63 1074.46 1716.63 1075.61C1716.63 1079.02 1713.84 1081.81 1710.43 1081.81H1675.56C1676.64 1083.63 1678.63 1084.87 1680.89 1084.87H1718.07C1721.48 1084.87 1724.27 1082.08 1724.27 1078.67C1724.27 1075.26 1721.48 1072.47 1718.07 1072.47Z"
            fill="#42464B"
          />
          <path
            d="M1552.39 1072.47H1550.08C1550.63 1073.39 1550.95 1074.46 1550.95 1075.61C1550.95 1079.02 1548.16 1081.81 1544.75 1081.81H1509.88C1510.96 1083.63 1512.95 1084.87 1515.21 1084.87H1552.39C1555.8 1084.87 1558.59 1082.08 1558.59 1078.67C1558.59 1075.26 1555.8 1072.47 1552.39 1072.47Z"
            fill="#42464B"
          />
          <path
            d="M1663.04 1289.16H854.73C841.01 1289.16 829.89 1278.04 829.89 1264.32C829.89 1250.6 841.01 1239.48 854.73 1239.48H1663.04C1676.76 1239.48 1687.88 1250.6 1687.88 1264.32C1687.88 1278.04 1676.76 1289.16 1663.04 1289.16Z"
            fill="#00003C"
          />
          <path
            d="M1663.04 1239.48H1533.8C1547.52 1239.48 1558.64 1250.6 1558.64 1264.32C1558.64 1278.04 1547.52 1289.16 1533.8 1289.16H1663.04C1676.76 1289.16 1687.88 1278.04 1687.88 1264.32C1687.88 1250.6 1676.76 1239.48 1663.04 1239.48Z"
            fill="#282840"
          />
          <path
            d="M1152.28 1262H858.78C855.4 1262 852.63 1259.23 852.63 1255.85C852.63 1252.47 855.4 1249.7 858.78 1249.7H1152.28C1155.66 1249.7 1158.43 1252.47 1158.43 1255.85C1158.43 1259.23 1155.66 1262 1152.28 1262Z"
            fill="#363654"
          />
          <path
            opacity="0.13"
            d="M929.77 444.26L672.3 733.37V883.08L1063.1 444.26H929.77Z"
            fill="white"
          />
          <path
            opacity="0.1"
            d="M1752.45 444.26H1738.81C1724.97 553.12 1702.38 641.41 1682.16 706.25C1646.32 821.21 1612.7 879.35 1561.43 924.41C1561.43 924.41 1519.08 961.63 1459.77 985.83C1394.82 1012.33 1275.41 1031.96 1114.91 1042.59H1752.45C1761.21 1042.59 1768.32 1035.48 1768.32 1026.72V460.13C1768.32 451.37 1761.21 444.26 1752.45 444.26Z"
            fill="#127C4A"
          />
          <path
            opacity="0.35"
            d="M1752.45 444.26H688.17C679.41 444.26 672.3 451.37 672.3 460.13V461.38H1728.77C1737.53 461.38 1744.64 468.49 1744.64 477.25V1042.59H1752.44C1761.2 1042.59 1768.31 1035.48 1768.31 1026.72V460.13C1768.31 451.37 1761.2 444.26 1752.44 444.26H1752.45Z"
            fill="#0B5E37"
          />
          <path
            d="M460.39 196.25L452.02 199.82C449.66 196.89 446.74 193.84 443.68 191.54L447.04 183.01C448.16 180.23 446.78 176.99 444 175.87L432.34 171.16C429.56 170.04 426.36 171.39 425.24 174.17L421.69 182.67C417.89 182.21 413.7 182.36 409.97 182.84L406.4 174.47C405.22 171.71 402.61 170.99 399.85 172.16L388.3 177.08C385.54 178.26 383.37 181.01 384.55 183.77L388.12 192.14C385.19 194.5 382.61 197.22 380.31 200.28L372.01 196.82C369.23 195.7 366.1 197.03 364.98 199.81L360.33 211.44C359.21 214.22 360.59 217.41 363.37 218.53L371.9 222.11C371.44 225.91 371.62 230.13 372.1 233.86L363.73 237.43C360.97 238.61 358.91 241.71 360.08 244.47L365 256.02C366.18 258.78 370.28 260.46 373.04 259.28L381.41 255.71C383.77 258.64 386.48 261.19 389.54 263.49L386.07 271.77C384.95 274.55 386.28 277.67 389.06 278.79L400.69 283.44C403.47 284.56 406.66 283.18 407.78 280.4L410.89 272.07C414.69 272.53 418.44 272.55 422.17 272.07L425.74 280.44C426.92 283.2 430.99 284.93 433.75 283.75L445.3 278.83C448.06 277.65 448.77 273.89 447.59 271.13L444.02 262.76C446.95 260.4 449.97 257.49 452.27 254.43L460.79 257.8C463.57 258.92 466.8 257.54 467.92 254.76L472.63 243.1C473.75 240.32 472.4 237.12 469.62 236L461.32 232.92C461.78 229.12 461.83 225.4 461.35 221.67L469.72 218.1C472.48 216.92 472.87 213.34 471.69 210.58L466.77 199.03C465.59 196.27 463.17 195.07 460.41 196.25H460.39ZM426.53 250.82C413.52 256.36 398.47 250.31 392.93 237.29C387.39 224.28 393.44 209.23 406.46 203.69C419.47 198.15 434.52 204.2 440.06 217.22C445.6 230.23 439.55 245.28 426.53 250.82Z"
            fill={theme.palette.primary.light}
          />
          <path
            d="M1805.2 19.279L1738.06 93.8652L1848.83 193.566L1915.96 118.98L1805.2 19.279Z"
            fill="#FFD817"
          />
          <path
            d="M1823.93 97.8001L1737.94 93.8301L1848.71 193.52L1835.73 108.4C1834.68 102.64 1829.78 98.2301 1823.92 97.7901L1823.93 97.8001Z"
            fill="#F4940B"
          />
          <path
            d="M1821.28 100.77L1737.94 93.8398L1848.71 193.53L1833.06 111.38C1831.97 105.66 1827.07 101.25 1821.27 100.77H1821.28Z"
            fill="#FFDE1A"
          />
          <path
            d="M1818.08 104.299C1819.14 110.079 1824.04 114.489 1829.87 114.929L1915.88 118.899L1805.11 19.209L1818.08 104.309V104.299Z"
            fill="#F4940B"
          />
          <path
            d="M1820.76 101.349C1821.85 107.069 1826.75 111.479 1832.55 111.959L1915.89 118.889L1805.12 19.1992L1820.77 101.349H1820.76Z"
            fill="#FFD147"
          />
          <path
            d="M2299.65 629.417C2331.19 597.882 2331.19 546.754 2299.65 515.219C2268.12 483.685 2216.99 483.685 2185.45 515.219C2153.92 546.754 2153.92 597.882 2185.45 629.417C2216.99 660.952 2268.12 660.952 2299.65 629.417Z"
            fill={theme.palette.primary.main}
          />
          <path
            d="M2244.94 590.891H2240.16C2235.24 590.891 2231.22 586.871 2231.22 581.951L2226.69 527.121C2225.92 517.841 2233.25 509.891 2242.56 509.891C2251.87 509.891 2259.19 517.841 2258.43 527.121L2253.9 581.951C2253.9 586.871 2249.88 590.891 2244.96 590.891H2244.94Z"
            fill="white"
          />
          <path
            d="M2250.7 624.149C2255.21 619.646 2255.21 612.346 2250.7 607.843C2246.2 603.34 2238.9 603.34 2234.4 607.843C2229.89 612.346 2229.89 619.646 2234.4 624.149C2238.9 628.652 2246.2 628.652 2250.7 624.149Z"
            fill="white"
          />
          <path
            d="M2150.16 368.141L2119.65 365.391L2096.27 413.911L2144.76 381.621L2150.16 368.141Z"
            fill="#A3D5BD"
          />
          <path
            d="M2113.8 371.06C2111.29 369.4 2106.75 366.43 2100.17 363.92C2093.45 361.36 2087.91 360.55 2083.94 360.02C2061.8 357.1 2050.18 356.77 2050.18 356.77L2250.13 308.73L2176.12 412.6C2176.12 412.6 2169.94 412.13 2147.56 395.07C2147.56 395.07 2131.07 382.5 2113.8 371.05V371.06Z"
            fill="white"
          />
          <path
            d="M2096.27 362.581V413.911L2125.6 379.111L2222.87 322.371L2096.27 362.581Z"
            fill={theme.palette.primary.light}
          />
          <path
            d="M874.82 57.3807L904.29 54.7207L926.87 101.581L880.04 70.4007L874.82 57.3807Z"
            fill="#8DD2B2"
          />
          <path
            d="M909.94 60.2C912.36 58.59 916.75 55.72 923.11 53.3C929.6 50.83 934.95 50.04 938.79 49.54C960.18 46.72 971.4 46.4 971.4 46.4L778.26 0L849.74 100.33C849.74 100.33 855.71 99.88 877.33 83.4C877.33 83.4 893.26 71.26 909.94 60.2Z"
            fill="white"
          />
          <path
            d="M926.87 52.0099V101.58L898.54 67.9699L804.59 13.1699L926.87 52.0099Z"
            fill={theme.palette.primary.light}
          />
          <path
            d="M1955.35 336.869H1537.78C1514.62 336.869 1495.84 353.899 1495.84 374.909V463.259C1495.84 484.269 1514.62 501.299 1537.78 501.299H1559.41V570.249L1626.82 501.299H1955.36C1978.52 501.299 1997.3 484.269 1997.3 463.259V374.909C1997.3 353.899 1978.52 336.869 1955.36 336.869H1955.35Z"
            fill="white"
          />
          <path
            d="M1962.36 337.399C1963.88 351.399 1963.45 369.959 1956.14 390.209C1954.65 394.339 1936.78 451.719 1878.21 468.889C1809.57 489.009 1687.69 488.109 1640.4 486.879C1628.12 486.559 1616.5 491.879 1609.48 501.019C1597.11 517.139 1576.8 543.779 1559.4 567.469V570.239L1626.81 501.289H1955.35C1978.51 501.289 1997.29 484.259 1997.29 463.249V374.899C1997.29 356.059 1982.19 340.419 1962.37 337.389L1962.36 337.399Z"
            fill="#EAF1EE"
          />
          <path
            d="M1603.34 406.59H1576.48C1575.71 406.59 1575.03 406.09 1574.79 405.36L1566.49 379.81C1565.96 378.17 1563.64 378.17 1563.11 379.81L1554.81 405.36C1554.57 406.09 1553.89 406.59 1553.12 406.59H1526.26C1524.54 406.59 1523.82 408.8 1525.21 409.81L1546.94 425.59C1547.56 426.04 1547.83 426.85 1547.59 427.58L1539.29 453.12C1538.76 454.76 1540.63 456.12 1542.03 455.11L1563.76 439.32C1564.38 438.87 1565.23 438.87 1565.85 439.32L1587.58 455.11C1588.97 456.12 1590.85 454.76 1590.32 453.12L1582.02 427.58C1581.78 426.85 1582.04 426.04 1582.67 425.59L1604.4 409.81C1605.79 408.8 1605.08 406.59 1603.35 406.59H1603.34Z"
            fill="#FDE222"
          />
          <path
            d="M1603.34 406.59H1576.48C1575.71 406.59 1575.03 406.09 1574.79 405.36L1566.49 379.81C1565.96 378.17 1563.64 378.17 1563.11 379.81L1554.81 405.36C1554.57 406.09 1553.89 406.59 1553.12 406.59H1526.26C1524.54 406.59 1523.82 408.8 1525.21 409.81L1546.94 425.59C1547.56 426.04 1547.83 426.85 1547.59 427.58L1539.29 453.12C1538.76 454.76 1540.63 456.12 1542.03 455.11L1563.76 439.32C1564.38 438.87 1565.23 438.87 1565.85 439.32L1587.58 455.11C1588.97 456.12 1590.85 454.76 1590.32 453.12L1582.02 427.58C1581.78 426.85 1582.04 426.04 1582.67 425.59L1604.4 409.81C1605.79 408.8 1605.08 406.59 1603.35 406.59H1603.34Z"
            fill="#FDE222"
          />
          <path
            d="M1563.1 379.82L1554.8 405.49C1554.56 406.22 1553.88 406.84 1553.11 406.84H1526.25C1525.31 406.84 1524.66 407.38 1524.51 408.15C1537.67 415.16 1556.1 419.89 1561.68 414.23C1571.29 404.49 1568.15 389.46 1564.03 378.76C1563.62 378.95 1563.28 379.3 1563.11 379.82H1563.1Z"
            fill="#FFDF5A"
          />
          <path
            d="M1581.01 423.47L1600.2 409.68H1576.47C1574.48 409.68 1572.73 408.3 1572.12 406.41L1564.79 383.73L1557.46 406.37C1556.85 408.26 1555.1 409.68 1553.11 409.68H1529.38L1548.57 423.47C1550.18 424.64 1550.85 426.55 1550.23 428.44L1542.9 451L1562.1 437.05C1562.89 436.48 1563.82 436.18 1564.79 436.18C1565.76 436.18 1566.69 436.48 1567.48 437.05L1586.68 451.03L1579.35 428.51C1578.73 426.62 1579.4 424.63 1581.01 423.46V423.47Z"
            fill="#F5B818"
          />
          <path
            d="M1581.01 423.5L1591.55 412.53H1576.47C1573.28 412.53 1570.46 410.39 1569.46 407.31L1564.79 392.82L1560.12 407.27C1559.12 410.36 1556.3 412.53 1553.11 412.53H1538.03L1549.26 424.1C1550.48 425.38 1550.53 427.56 1549.55 430.58L1542.91 451.01L1562.11 437.06C1563.38 436.14 1563.23 436.19 1564.8 436.19C1566.37 436.19 1566.22 436.14 1567.49 437.06L1586.69 451.05L1580.03 430.59C1579.04 427.56 1578.43 425.39 1581.03 423.5H1581.01Z"
            fill="#FDE222"
          />
          <path
            d="M1581.01 423.5L1591.55 412.53H1576.47C1573.28 412.53 1570.46 410.39 1569.46 407.31L1564.79 392.82L1560.12 407.27C1559.12 410.36 1556.3 412.53 1553.11 412.53H1538.03L1549.26 424.1C1550.48 425.38 1550.53 427.56 1549.55 430.58L1542.91 451.01L1562.11 437.06C1563.38 436.14 1563.23 436.19 1564.8 436.19C1566.37 436.19 1566.22 436.14 1567.49 437.06L1586.69 451.05L1580.03 430.59C1579.04 427.56 1578.43 425.39 1581.03 423.5H1581.01Z"
            fill="#FFC71F"
          />
          <path
            d="M1581.01 423.43C1575.73 428.2 1568.74 429.07 1563.42 429.32C1558.61 429.54 1553.35 428.48 1550.08 425.58C1550.83 427.92 1549.88 429.57 1549.55 430.57L1542.91 451L1562.11 437.05C1563.38 436.13 1563.23 436.18 1564.8 436.18C1566.37 436.18 1566.22 436.13 1567.49 437.05L1586.69 451.02L1580.03 430.54C1579.39 428.58 1578.54 427.49 1581.03 423.42L1581.01 423.43Z"
            fill="#F5B818"
          />
          <path
            d="M1560.12 407.26C1559.12 410.35 1556.3 412.52 1553.11 412.52H1538.03L1539.96 414.46C1549.29 417.24 1558.1 417.84 1561.67 414.22C1565.22 410.62 1567.03 406.3 1567.69 401.74L1564.79 392.77L1560.12 407.25V407.26Z"
            fill="#FFDF5A"
          />
          <path
            d="M1693.22 406.59H1666.36C1665.59 406.59 1664.91 406.09 1664.67 405.36L1656.37 379.81C1655.84 378.17 1653.52 378.17 1652.99 379.81L1644.69 405.36C1644.45 406.09 1643.77 406.59 1643 406.59H1616.14C1614.42 406.59 1613.7 408.8 1615.09 409.81L1636.82 425.59C1637.44 426.04 1637.71 426.85 1637.47 427.58L1629.17 453.12C1628.64 454.76 1630.51 456.12 1631.91 455.11L1653.64 439.32C1654.26 438.87 1655.11 438.87 1655.73 439.32L1677.46 455.11C1678.85 456.12 1680.73 454.76 1680.2 453.12L1671.9 427.58C1671.66 426.85 1671.92 426.04 1672.55 425.59L1694.28 409.81C1695.67 408.8 1694.96 406.59 1693.23 406.59H1693.22Z"
            fill="#FDE222"
          />
          <path
            d="M1693.22 406.59H1666.36C1665.59 406.59 1664.91 406.09 1664.67 405.36L1656.37 379.81C1655.84 378.17 1653.52 378.17 1652.99 379.81L1644.69 405.36C1644.45 406.09 1643.77 406.59 1643 406.59H1616.14C1614.42 406.59 1613.7 408.8 1615.09 409.81L1636.82 425.59C1637.44 426.04 1637.71 426.85 1637.47 427.58L1629.17 453.12C1628.64 454.76 1630.51 456.12 1631.91 455.11L1653.64 439.32C1654.26 438.87 1655.11 438.87 1655.73 439.32L1677.46 455.11C1678.85 456.12 1680.73 454.76 1680.2 453.12L1671.9 427.58C1671.66 426.85 1671.92 426.04 1672.55 425.59L1694.28 409.81C1695.67 408.8 1694.96 406.59 1693.23 406.59H1693.22Z"
            fill="#FDE222"
          />
          <path
            d="M1652.98 379.82L1644.68 405.49C1644.44 406.22 1643.76 406.84 1642.99 406.84H1616.13C1615.19 406.84 1614.54 407.38 1614.39 408.15C1627.55 415.16 1645.98 419.89 1651.56 414.23C1661.17 404.49 1658.03 389.46 1653.91 378.76C1653.5 378.95 1653.16 379.3 1652.99 379.82H1652.98Z"
            fill="#FFDF5A"
          />
          <path
            d="M1670.89 423.47L1690.08 409.68H1666.35C1664.36 409.68 1662.61 408.3 1662 406.41L1654.67 383.73L1647.34 406.37C1646.73 408.26 1644.98 409.68 1642.99 409.68H1619.26L1638.45 423.47C1640.06 424.64 1640.73 426.55 1640.11 428.44L1632.78 451L1651.98 437.05C1652.77 436.48 1653.7 436.18 1654.67 436.18C1655.64 436.18 1656.57 436.48 1657.36 437.05L1676.56 451.03L1669.23 428.51C1668.61 426.62 1669.28 424.63 1670.89 423.46V423.47Z"
            fill="#F5B818"
          />
          <path
            d="M1670.89 423.5L1681.43 412.53H1666.35C1663.16 412.53 1660.34 410.39 1659.34 407.31L1654.67 392.82L1650 407.27C1649 410.36 1646.18 412.53 1642.99 412.53H1627.91L1639.14 424.1C1640.36 425.38 1640.41 427.56 1639.43 430.58L1632.79 451.01L1651.99 437.06C1653.26 436.14 1653.11 436.19 1654.68 436.19C1656.25 436.19 1656.1 436.14 1657.37 437.06L1676.57 451.05L1669.91 430.59C1668.92 427.56 1668.31 425.39 1670.91 423.5H1670.89Z"
            fill="#FDE222"
          />
          <path
            d="M1670.89 423.5L1681.43 412.53H1666.35C1663.16 412.53 1660.34 410.39 1659.34 407.31L1654.67 392.82L1650 407.27C1649 410.36 1646.18 412.53 1642.99 412.53H1627.91L1639.14 424.1C1640.36 425.38 1640.41 427.56 1639.43 430.58L1632.79 451.01L1651.99 437.06C1653.26 436.14 1653.11 436.19 1654.68 436.19C1656.25 436.19 1656.1 436.14 1657.37 437.06L1676.57 451.05L1669.91 430.59C1668.92 427.56 1668.31 425.39 1670.91 423.5H1670.89Z"
            fill="#FFC71F"
          />
          <path
            d="M1670.89 423.43C1665.61 428.2 1658.62 429.07 1653.3 429.32C1648.49 429.54 1643.23 428.48 1639.96 425.58C1640.71 427.92 1639.76 429.57 1639.43 430.57L1632.79 451L1651.99 437.05C1653.26 436.13 1653.11 436.18 1654.68 436.18C1656.25 436.18 1656.1 436.13 1657.37 437.05L1676.57 451.02L1669.91 430.54C1669.27 428.58 1668.42 427.49 1670.91 423.42L1670.89 423.43Z"
            fill="#F5B818"
          />
          <path
            d="M1650 407.26C1649 410.35 1646.18 412.52 1642.99 412.52H1627.91L1629.84 414.46C1639.17 417.24 1647.98 417.84 1651.55 414.22C1655.1 410.62 1656.91 406.3 1657.57 401.74L1654.67 392.77L1650 407.25V407.26Z"
            fill="#FFDF5A"
          />
          <path
            d="M1872.84 406.59H1845.98C1845.21 406.59 1844.53 406.09 1844.29 405.36L1835.99 379.81C1835.46 378.17 1833.14 378.17 1832.61 379.81L1824.31 405.36C1824.07 406.09 1823.39 406.59 1822.62 406.59H1795.76C1794.04 406.59 1793.32 408.8 1794.71 409.81L1816.44 425.59C1817.06 426.04 1817.32 426.85 1817.09 427.58L1808.79 453.12C1808.26 454.76 1810.13 456.12 1811.53 455.11L1833.26 439.32C1833.88 438.87 1834.73 438.87 1835.35 439.32L1857.08 455.11C1858.47 456.12 1860.35 454.76 1859.82 453.12L1851.52 427.58C1851.28 426.85 1851.54 426.04 1852.17 425.59L1873.9 409.81C1875.29 408.8 1874.58 406.59 1872.85 406.59H1872.84Z"
            fill="#FDE222"
          />
          <path
            d="M1872.84 406.59H1845.98C1845.21 406.59 1844.53 406.09 1844.29 405.36L1835.99 379.81C1835.46 378.17 1833.14 378.17 1832.61 379.81L1824.31 405.36C1824.07 406.09 1823.39 406.59 1822.62 406.59H1795.76C1794.04 406.59 1793.32 408.8 1794.71 409.81L1816.44 425.59C1817.06 426.04 1817.32 426.85 1817.09 427.58L1808.79 453.12C1808.26 454.76 1810.13 456.12 1811.53 455.11L1833.26 439.32C1833.88 438.87 1834.73 438.87 1835.35 439.32L1857.08 455.11C1858.47 456.12 1860.35 454.76 1859.82 453.12L1851.52 427.58C1851.28 426.85 1851.54 426.04 1852.17 425.59L1873.9 409.81C1875.29 408.8 1874.58 406.59 1872.85 406.59H1872.84Z"
            fill="#FDE222"
          />
          <path
            d="M1832.6 379.82L1824.3 405.49C1824.06 406.22 1823.38 406.84 1822.61 406.84H1795.75C1794.81 406.84 1794.16 407.38 1794.01 408.15C1807.17 415.16 1825.6 419.89 1831.18 414.23C1840.79 404.49 1837.65 389.46 1833.53 378.76C1833.12 378.95 1832.78 379.3 1832.61 379.82H1832.6Z"
            fill="#FFDF5A"
          />
          <path
            d="M1850.51 423.47L1869.7 409.68H1845.97C1843.98 409.68 1842.23 408.3 1841.62 406.41L1834.29 383.73L1826.96 406.37C1826.35 408.26 1824.6 409.68 1822.61 409.68H1798.88L1818.07 423.47C1819.68 424.64 1820.35 426.55 1819.73 428.44L1812.4 451L1831.6 437.05C1832.39 436.48 1833.32 436.18 1834.29 436.18C1835.26 436.18 1836.19 436.48 1836.98 437.05L1856.18 451.03L1848.85 428.51C1848.23 426.62 1848.9 424.63 1850.51 423.46V423.47Z"
            fill="#F5B818"
          />
          <path
            d="M1850.51 423.5L1861.05 412.53H1845.97C1842.78 412.53 1839.96 410.39 1838.96 407.31L1834.29 392.82L1829.62 407.27C1828.62 410.36 1825.8 412.53 1822.61 412.53H1807.53L1818.76 424.1C1819.98 425.38 1820.03 427.56 1819.05 430.58L1812.41 451.01L1831.61 437.06C1832.88 436.14 1832.73 436.19 1834.3 436.19C1835.87 436.19 1835.72 436.14 1836.99 437.06L1856.19 451.05L1849.53 430.59C1848.54 427.56 1847.93 425.39 1850.53 423.5H1850.51Z"
            fill="#FDE222"
          />
          <path
            d="M1850.51 423.5L1861.05 412.53H1845.97C1842.78 412.53 1839.96 410.39 1838.96 407.31L1834.29 392.82L1829.62 407.27C1828.62 410.36 1825.8 412.53 1822.61 412.53H1807.53L1818.76 424.1C1819.98 425.38 1820.03 427.56 1819.05 430.58L1812.41 451.01L1831.61 437.06C1832.88 436.14 1832.73 436.19 1834.3 436.19C1835.87 436.19 1835.72 436.14 1836.99 437.06L1856.19 451.05L1849.53 430.59C1848.54 427.56 1847.93 425.39 1850.53 423.5H1850.51Z"
            fill="#FFC71F"
          />
          <path
            d="M1850.51 423.43C1845.23 428.2 1838.24 429.07 1832.92 429.32C1828.11 429.54 1822.85 428.48 1819.58 425.58C1820.33 427.92 1819.38 429.57 1819.05 430.57L1812.41 451L1831.61 437.05C1832.88 436.13 1832.73 436.18 1834.3 436.18C1835.87 436.18 1835.72 436.13 1836.99 437.05L1856.19 451.02L1849.53 430.54C1848.89 428.58 1848.04 427.49 1850.53 423.42L1850.51 423.43Z"
            fill="#F5B818"
          />
          <path
            d="M1829.62 407.26C1828.62 410.35 1825.8 412.52 1822.61 412.52H1807.53L1809.46 414.46C1818.79 417.24 1827.6 417.84 1831.17 414.22C1834.72 410.62 1836.53 406.3 1837.19 401.74L1834.29 392.77L1829.62 407.25V407.26Z"
            fill="#FFDF5A"
          />
          <path
            d="M1964.39 406.59H1937.53C1936.76 406.59 1936.08 406.09 1935.84 405.36L1927.54 379.81C1927.01 378.17 1924.69 378.17 1924.16 379.81L1915.86 405.36C1915.62 406.09 1914.94 406.59 1914.17 406.59H1887.31C1885.59 406.59 1884.87 408.8 1886.26 409.81L1907.99 425.59C1908.61 426.04 1908.87 426.85 1908.64 427.58L1900.34 453.12C1899.81 454.76 1901.68 456.12 1903.08 455.11L1924.81 439.32C1925.43 438.87 1926.28 438.87 1926.9 439.32L1948.63 455.11C1950.02 456.12 1951.9 454.76 1951.37 453.12L1943.07 427.58C1942.83 426.85 1943.09 426.04 1943.72 425.59L1965.45 409.81C1966.84 408.8 1966.13 406.59 1964.4 406.59H1964.39Z"
            fill="#FDE222"
          />
          <path
            d="M1964.39 406.59H1937.53C1936.76 406.59 1936.08 406.09 1935.84 405.36L1927.54 379.81C1927.01 378.17 1924.69 378.17 1924.16 379.81L1915.86 405.36C1915.62 406.09 1914.94 406.59 1914.17 406.59H1887.31C1885.59 406.59 1884.87 408.8 1886.26 409.81L1907.99 425.59C1908.61 426.04 1908.87 426.85 1908.64 427.58L1900.34 453.12C1899.81 454.76 1901.68 456.12 1903.08 455.11L1924.81 439.32C1925.43 438.87 1926.28 438.87 1926.9 439.32L1948.63 455.11C1950.02 456.12 1951.9 454.76 1951.37 453.12L1943.07 427.58C1942.83 426.85 1943.09 426.04 1943.72 425.59L1965.45 409.81C1966.84 408.8 1966.13 406.59 1964.4 406.59H1964.39Z"
            fill="#EBF2F7"
          />
          <path
            d="M1924.15 379.82L1915.85 405.49C1915.61 406.22 1914.93 406.84 1914.16 406.84H1887.3C1886.36 406.84 1885.71 407.38 1885.56 408.15C1898.72 415.16 1917.15 419.89 1922.73 414.23C1932.34 404.49 1929.2 389.46 1925.08 378.76C1924.67 378.95 1924.33 379.3 1924.16 379.82H1924.15Z"
            fill="#FFDF5A"
          />
          <path
            d="M1942.06 423.47L1961.25 409.68H1937.52C1935.53 409.68 1933.78 408.3 1933.17 406.41L1925.84 383.73L1918.51 406.37C1917.9 408.26 1916.15 409.68 1914.16 409.68H1890.43L1909.62 423.47C1911.23 424.64 1911.9 426.55 1911.28 428.44L1903.95 451L1923.15 437.05C1923.94 436.48 1924.87 436.18 1925.84 436.18C1926.81 436.18 1927.74 436.48 1928.53 437.05L1947.73 451.03L1940.4 428.51C1939.78 426.62 1940.45 424.63 1942.06 423.46V423.47Z"
            fill="#F5B818"
          />
          <path
            d="M1942.06 423.5L1952.6 412.53H1937.52C1934.33 412.53 1931.51 410.39 1930.51 407.31L1925.84 392.82L1921.17 407.27C1920.17 410.36 1917.35 412.53 1914.16 412.53H1899.08L1910.31 424.1C1911.53 425.38 1911.58 427.56 1910.6 430.58L1903.96 451.01L1923.16 437.06C1924.43 436.14 1924.28 436.19 1925.85 436.19C1927.42 436.19 1927.27 436.14 1928.54 437.06L1947.74 451.05L1941.08 430.59C1940.09 427.56 1939.48 425.39 1942.08 423.5H1942.06Z"
            fill="#FDE222"
          />
          <path
            d="M1942.06 423.5L1952.6 412.53H1937.52C1934.33 412.53 1931.51 410.39 1930.51 407.31L1925.84 392.82L1921.17 407.27C1920.17 410.36 1917.35 412.53 1914.16 412.53H1899.08L1910.31 424.1C1911.53 425.38 1911.58 427.56 1910.6 430.58L1903.96 451.01L1923.16 437.06C1924.43 436.14 1924.28 436.19 1925.85 436.19C1927.42 436.19 1927.27 436.14 1928.54 437.06L1947.74 451.05L1941.08 430.59C1940.09 427.56 1939.48 425.39 1942.08 423.5H1942.06Z"
            fill="#FFC71F"
          />
          <path
            d="M1942.06 423.43C1936.78 428.2 1929.79 429.07 1924.47 429.32C1919.66 429.54 1914.4 428.48 1911.13 425.58C1911.88 427.92 1910.93 429.57 1910.6 430.57L1903.96 451L1923.16 437.05C1924.43 436.13 1924.28 436.18 1925.85 436.18C1927.42 436.18 1927.27 436.13 1928.54 437.05L1947.74 451.02L1941.08 430.54C1940.44 428.58 1939.59 427.49 1942.08 423.42L1942.06 423.43Z"
            fill="#F5B818"
          />
          <path
            d="M1921.17 407.26C1920.17 410.35 1917.35 412.52 1914.16 412.52H1899.08L1901.01 414.46C1910.34 417.24 1919.15 417.84 1922.72 414.22C1926.27 410.62 1928.08 406.3 1928.74 401.74L1925.84 392.77L1921.17 407.25V407.26Z"
            fill="#FFDF5A"
          />
          <path
            d="M1783.09 406.59H1756.23C1755.46 406.59 1754.78 406.09 1754.54 405.36L1746.24 379.81C1745.71 378.17 1743.39 378.17 1742.86 379.81L1734.56 405.36C1734.32 406.09 1733.64 406.59 1732.87 406.59H1706.01C1704.29 406.59 1703.57 408.8 1704.96 409.81L1726.69 425.59C1727.31 426.04 1727.58 426.85 1727.34 427.58L1719.04 453.12C1718.51 454.76 1720.38 456.12 1721.78 455.11L1743.51 439.32C1744.13 438.87 1744.98 438.87 1745.6 439.32L1767.33 455.11C1768.72 456.12 1770.6 454.76 1770.07 453.12L1761.77 427.58C1761.53 426.85 1761.79 426.04 1762.42 425.59L1784.15 409.81C1785.54 408.8 1784.83 406.59 1783.1 406.59H1783.09Z"
            fill="#FDE222"
          />
          <path
            d="M1783.09 406.59H1756.23C1755.46 406.59 1754.78 406.09 1754.54 405.36L1746.24 379.81C1745.71 378.17 1743.39 378.17 1742.86 379.81L1734.56 405.36C1734.32 406.09 1733.64 406.59 1732.87 406.59H1706.01C1704.29 406.59 1703.57 408.8 1704.96 409.81L1726.69 425.59C1727.31 426.04 1727.58 426.85 1727.34 427.58L1719.04 453.12C1718.51 454.76 1720.38 456.12 1721.78 455.11L1743.51 439.32C1744.13 438.87 1744.98 438.87 1745.6 439.32L1767.33 455.11C1768.72 456.12 1770.6 454.76 1770.07 453.12L1761.77 427.58C1761.53 426.85 1761.79 426.04 1762.42 425.59L1784.15 409.81C1785.54 408.8 1784.83 406.59 1783.1 406.59H1783.09Z"
            fill="#FDE222"
          />
          <path
            d="M1742.85 379.82L1734.55 405.49C1734.31 406.22 1733.63 406.84 1732.86 406.84H1706C1705.06 406.84 1704.41 407.38 1704.26 408.15C1717.42 415.16 1735.85 419.89 1741.43 414.23C1751.04 404.49 1747.9 389.46 1743.78 378.76C1743.37 378.95 1743.03 379.3 1742.86 379.82H1742.85Z"
            fill="#FFDF5A"
          />
          <path
            d="M1760.76 423.47L1779.95 409.68H1756.22C1754.23 409.68 1752.48 408.3 1751.87 406.41L1744.54 383.73L1737.21 406.37C1736.6 408.26 1734.85 409.68 1732.86 409.68H1709.13L1728.32 423.47C1729.93 424.64 1730.6 426.55 1729.98 428.44L1722.65 451L1741.85 437.05C1742.64 436.48 1743.57 436.18 1744.54 436.18C1745.51 436.18 1746.44 436.48 1747.23 437.05L1766.43 451.03L1759.1 428.51C1758.48 426.62 1759.15 424.63 1760.76 423.46V423.47Z"
            fill="#F5B818"
          />
          <path
            d="M1760.76 423.5L1771.3 412.53H1756.22C1753.03 412.53 1750.21 410.39 1749.21 407.31L1744.54 392.82L1739.87 407.27C1738.87 410.36 1736.05 412.53 1732.86 412.53H1717.78L1729.01 424.1C1730.23 425.38 1730.28 427.56 1729.3 430.58L1722.66 451.01L1741.86 437.06C1743.13 436.14 1742.98 436.19 1744.55 436.19C1746.12 436.19 1745.97 436.14 1747.24 437.06L1766.44 451.05L1759.78 430.59C1758.79 427.56 1758.18 425.39 1760.78 423.5H1760.76Z"
            fill="#FDE222"
          />
          <path
            d="M1760.76 423.5L1771.3 412.53H1756.22C1753.03 412.53 1750.21 410.39 1749.21 407.31L1744.54 392.82L1739.87 407.27C1738.87 410.36 1736.05 412.53 1732.86 412.53H1717.78L1729.01 424.1C1730.23 425.38 1730.28 427.56 1729.3 430.58L1722.66 451.01L1741.86 437.06C1743.13 436.14 1742.98 436.19 1744.55 436.19C1746.12 436.19 1745.97 436.14 1747.24 437.06L1766.44 451.05L1759.78 430.59C1758.79 427.56 1758.18 425.39 1760.78 423.5H1760.76Z"
            fill="#FFC71F"
          />
          <path
            d="M1760.76 423.43C1755.48 428.2 1748.49 429.07 1743.17 429.32C1738.36 429.54 1733.1 428.48 1729.83 425.58C1730.58 427.92 1729.63 429.57 1729.3 430.57L1722.66 451L1741.86 437.05C1743.13 436.13 1742.98 436.18 1744.55 436.18C1746.12 436.18 1745.97 436.13 1747.24 437.05L1766.44 451.02L1759.78 430.54C1759.14 428.58 1758.29 427.49 1760.78 423.42L1760.76 423.43Z"
            fill="#F5B818"
          />
          <path
            d="M1739.87 407.26C1738.87 410.35 1736.05 412.52 1732.86 412.52H1717.78L1719.71 414.46C1729.04 417.24 1737.85 417.84 1741.42 414.22C1744.97 410.62 1746.78 406.3 1747.44 401.74L1744.54 392.77L1739.87 407.25V407.26Z"
            fill="#FFDF5A"
          />
          <path
            d="M1085.88 259.549C1093.07 215.201 1062.96 173.414 1018.61 166.216C974.264 159.017 932.477 189.132 925.278 233.48C918.08 277.828 948.195 319.615 992.543 326.814C1036.89 334.012 1078.68 303.897 1085.88 259.549Z"
            fill={theme.palette.primary.light}
          />
          <path
            d="M1050.81 273.901C1044.68 269.691 1029.83 259.711 1026.85 259.661C1022.63 259.591 1019.22 262.081 1016.91 264.501C1014.81 266.701 1011.34 266.791 1009.14 264.691L986.28 242.881C984.16 240.861 983.99 237.511 985.92 235.311C988.17 232.751 990.7 229.221 991.22 225.821C991.56 223.591 976.52 200.351 974.47 200.061C966.39 198.921 959.99 208.021 958.41 212.831C957.34 216.091 958.03 219.101 959.13 222.591C963.93 237.901 972.23 248.961 972.64 249.491C977.84 256.301 982.31 260.531 988.14 266.041C1001.53 278.711 1010.98 284.341 1013.74 285.941C1017.54 288.141 1024.93 292.131 1034.22 292.901C1037.73 293.191 1040.59 292.951 1043.43 291.651C1048.17 289.481 1050.46 285.471 1051.17 284.181C1051.51 283.561 1052.4 281.951 1052.98 279.921C1053.62 277.651 1052.76 275.221 1050.81 273.881V273.901Z"
            fill="white"
          />
          <path
            d="M823.58 693.18C815.43 689.86 798.17 689.22 788.54 695.91C770.42 708.5 788.08 754.72 807.62 763.81C816.35 767.87 828.41 765.01 836.35 757.64C845.18 749.44 846.27 738.12 846.57 735.01C848.13 718.72 842.93 701.06 823.58 693.18Z"
            fill="#1C2546"
          />
          <path
            d="M843.33 788.901C813.19 784.601 822.54 767.511 828.42 744.811C830.22 737.831 794.31 750.261 792.29 761.051C791.42 765.691 793.04 772.051 791.69 777.321C789.84 784.581 781.64 788.071 777.22 789.241C768.59 791.521 762.04 789.861 761.05 792.231C757.23 801.421 770.28 822.441 777.32 824.711C811.03 835.571 852.13 790.151 843.33 788.891V788.901Z"
            fill="#EB8E6C"
          />
          <path
            d="M862.21 1274.35C857.98 1266.73 841.82 1265.37 837.66 1270.74C835.66 1273.32 837.53 1276.03 834.77 1281.81C832.76 1286.01 831.05 1286.09 830.2 1288.79C828.38 1294.55 832.84 1304.68 841.75 1307.32C850.1 1309.79 858.66 1304.58 861.24 1298.66C861.53 1298.01 864.26 1296.85 862.2 1291.68C859.99 1286.15 863.34 1276.41 862.2 1274.35H862.21Z"
            fill="#EB8E6C"
          />
          <path
            d="M778.46 1275.55C778.94 1269.88 780.13 1269.06 779.18 1266.65C776.11 1258.82 758.96 1255.66 754.39 1261.12C751.32 1264.79 756 1269.91 751.98 1277.97C750.98 1279.97 749.64 1281.77 750.05 1284.23C750.45 1286.58 752.17 1287.82 754.62 1290.01C762.21 1296.78 761.03 1298.56 764.49 1299.88C769.23 1301.68 776.44 1300.26 779.17 1296.03C782.09 1291.5 777.45 1287.5 778.45 1275.57L778.46 1275.55Z"
            fill="#EB8E6C"
          />
          <path
            d="M811.11 987.03C795.67 968.62 774.46 942.299 762.88 953.219C755.62 960.059 742.43 1017.14 746.85 1073.64C747.96 1087.76 750.18 1101.64 751.51 1109.03C754.71 1126.89 757.07 1132.77 757.1 1146.28C757.12 1153.49 756.47 1162.59 756.17 1166.77C755.53 1175.79 754.86 1180.95 754.31 1186.33C751.79 1210.8 753.59 1211.36 752.45 1233.82C751.72 1248.25 752.45 1268.74 752.45 1268.74L781.78 1271.53C781.78 1271.53 781.84 1258.16 783.18 1249.65C785.65 1233.91 788.71 1233.86 791.56 1219.85C794.64 1204.69 793.84 1178.88 793.16 1165.83C792.89 1160.54 793.5 1155.25 794.98 1150.17C800.61 1130.9 805.63 1070.17 798.92 1040.68C796.96 1032.05 831.83 1011.74 811.12 987.039L811.11 987.03Z"
            fill="#F7BF41"
          />
          <path
            d="M787.05 1004.94C780.36 1008.45 792.09 1079.58 791.95 1093.94C791.86 1103.31 790.93 1111 789.78 1120.47C788.2 1133.52 787.51 1133.39 786.53 1143.21C786.31 1145.46 785.67 1152.2 785.45 1171.91C785.22 1192.36 785.84 1190.75 785.45 1197.36C784.42 1215 780.35 1220.71 777.33 1236.89C775.81 1245.03 774.43 1256.5 775.18 1270.91L781.78 1271.54C781.78 1271.54 781.84 1258.17 783.18 1249.66C785.65 1233.92 788.71 1233.87 791.56 1219.86C794.64 1204.7 793.84 1178.89 793.16 1165.84C792.89 1160.55 793.5 1155.26 794.98 1150.18C800.61 1130.91 805.63 1070.18 798.92 1040.69C798.42 1038.48 800.32 1035.51 803.09 1031.9C796.2 1022.61 789.73 1003.54 787.05 1004.95V1004.94Z"
            fill="#EAAD34"
          />
          <path
            d="M860.47 1136.03C858.64 1126.32 858.92 1115.15 859.54 1093.19C860.05 1075.13 860.31 1066.11 861.4 1053.15C863.52 1027.99 865.96 1020.96 863.26 1006.59C861.38 996.611 849.31 959.721 843.33 953.231C825.13 933.481 787.98 943.231 782.47 958.721C781.85 960.451 785.68 989.271 787.83 1002.87C788.39 1006.39 798.55 1090.7 816.47 1147.79C819.18 1156.43 824.74 1164.39 827.88 1172.36C829.36 1176.1 830.91 1181.05 832.54 1194.71C835.02 1215.47 833.02 1217.31 835.33 1238.48C836.55 1249.62 832.42 1274.84 834.86 1278.45C834.86 1278.45 864.11 1279.96 864.19 1277.6C865.12 1252.92 872.41 1225.43 872.57 1203.1C872.63 1195.34 872.65 1183.54 869.78 1168.64C866.45 1151.39 863.29 1151.06 860.47 1136.05V1136.03Z"
            fill="#FFD147"
          />
          <path
            d="M861.87 1287.83C860.66 1287.9 861.3 1294.04 858.14 1295.28C857.58 1295.5 856.15 1295.86 850.69 1292.49C845.53 1289.3 845.41 1288.11 842.31 1286.44C839.1 1284.7 832.58 1282.38 829.27 1285.04C827.13 1286.77 828.5 1288.85 826.48 1294.82C824.58 1300.42 821.49 1304.18 819.96 1306C816.84 1309.71 813.61 1312.06 812.98 1312.52C809.17 1315.26 807.54 1315.32 805.06 1318.11C803.81 1319.52 802.04 1321.58 801.8 1324.63C801.75 1325.23 801.5 1328.56 803.66 1330.68C805.05 1332.04 806.7 1332.18 809.71 1332.54C813.13 1332.95 816.52 1333.62 819.95 1333.94C831.57 1335.02 830.96 1335.7 834.38 1335.34C836.16 1335.15 840.49 1334.65 845.09 1332.08C849.24 1329.76 848.86 1328.42 853.47 1325.56C858.86 1322.23 860.94 1323.09 863.25 1320.44C864.6 1318.89 865.52 1316.71 865.58 1309.73C865.67 1298.66 863.48 1287.75 861.86 1287.85L861.87 1287.83Z"
            fill="#3845B8"
          />
          <path
            d="M778.99 1286.89C777.56 1286.91 777.88 1291.78 773.87 1294.34C772.06 1295.5 769.22 1296.28 766.89 1295.27C764.07 1294.05 764.51 1291.29 761.77 1287.82C758.46 1283.63 752.23 1280.56 748.27 1282.23C746.75 1282.87 747.01 1283.6 743.15 1288.75C740.92 1291.72 739.09 1293.8 736.17 1297.13C733.31 1300.38 731.89 1302 730.58 1303.18C728.59 1304.98 725.06 1308.19 719.87 1310.16C713.23 1312.69 710.49 1310.7 707.3 1313.88C704.7 1316.48 704.14 1320.17 704.04 1320.86C703.82 1322.33 703.49 1324.53 704.51 1326.45C705.86 1329.01 709.01 1329.94 713.36 1330.64C720.01 1331.71 724.99 1332.52 733.38 1331.11C741.31 1329.78 740.55 1328.44 751.54 1325.99C760.36 1324.02 767.37 1323.2 767.37 1323.2C777.37 1322.02 779.97 1322.83 782.27 1320.41C784.56 1317.99 784.3 1313.95 783.67 1305.98C783 1297.48 781.12 1286.86 779.01 1286.89H778.99Z"
            fill="#3845B8"
          />
          <path
            d="M849.76 1319.02C844.78 1321.67 840.42 1322.39 838.12 1322.74C836.74 1322.95 831.8 1323.65 825.55 1322.74C821.08 1322.09 819.35 1321.12 813.44 1320.41C811.88 1320.22 807.19 1320.11 803.49 1320.04C802.67 1321.24 801.94 1322.74 801.8 1324.6C801.75 1325.2 801.5 1328.53 803.66 1330.65C805.05 1332.01 806.7 1332.15 809.71 1332.51C813.13 1332.92 816.52 1333.59 819.95 1333.91C831.57 1334.99 830.96 1335.67 834.38 1335.31C836.16 1335.12 840.49 1334.62 845.09 1332.05C849.24 1329.73 848.86 1328.39 853.47 1325.53C858.86 1322.2 860.94 1323.06 863.25 1320.41C864.6 1318.86 865.52 1316.68 865.58 1309.7C865.58 1309.22 865.58 1308.73 865.58 1308.25C860.65 1312.04 853.16 1317.19 849.75 1319.01L849.76 1319.02Z"
            fill="white"
          />
          <path
            d="M765.02 1314.37C744.86 1319.76 739.92 1319.49 737.55 1319.96C724.81 1322.48 711.69 1320.84 704.42 1319.04C704.17 1319.94 704.06 1320.63 704.02 1320.89C703.8 1322.36 703.47 1324.56 704.49 1326.48C705.84 1329.04 708.99 1329.97 713.34 1330.67C719.99 1331.74 724.97 1332.55 733.36 1331.14C741.29 1329.81 740.53 1328.47 751.52 1326.02C760.34 1324.05 767.35 1323.23 767.35 1323.23C777.35 1322.05 779.95 1322.86 782.25 1320.44C784.11 1318.48 784.28 1315.45 783.95 1310.12C776.59 1311.8 767.66 1313.68 765.02 1314.39V1314.37Z"
            fill="white"
          />
          <path
            d="M752.4 797.39C751.06 799.06 741.66 808.55 740.77 812.44C739.39 818.44 738.38 824.33 727.77 837.99C721.18 846.48 687.59 879.51 716.79 901.49C720.9 904.59 753.06 894.23 753.13 852.52C753.18 819.08 766.65 800.01 766.45 790.93C766.41 789.37 756.83 791.87 752.41 797.38L752.4 797.39Z"
            fill="#F8F8FF"
          />
          <path
            d="M735.34 853.531C731.24 860.071 723.44 875.261 725.62 900.491C733.82 897.291 745.26 888.671 750.41 871.801C750.02 869.081 749.85 866.231 749.96 863.281C750.2 856.811 751.74 851.151 753.4 846.541C753.81 841.921 754.66 837.561 755.82 833.461C751.58 834.721 741.93 843.031 735.34 853.531Z"
            fill="#EDEDF9"
          />
          <path
            d="M738.1 808.25C737.43 807.84 734.8 806.24 732.89 807.74C731.99 808.44 731 810.03 730.88 811.82C730.78 813.25 731.3 813.97 730.88 814.88C730.41 815.9 729.49 815.58 728.87 816.41C728.02 817.55 728.6 819.69 729.07 822.02C729.92 826.27 729.07 824.57 730.27 832.22C731.24 838.4 731.65 838.57 731.47 840.38C731.08 844.34 728.81 846.91 727.46 848.54C719.49 858.21 715.21 869.73 713.82 874.05C712.48 878.22 711.11 882.68 711.81 888.34C712.01 889.94 713.01 897.98 718.23 901.35C720.98 903.13 723.66 902.79 724.85 902.63C732.24 901.58 736.82 893.2 738.09 890.89C739.32 888.64 741.56 883.98 743.5 864.87C744.51 854.92 745.4 845.82 744.7 833.49C744.17 824.05 743.35 811.45 738.08 808.23L738.1 808.25Z"
            fill="#DF7C5D"
          />
          <path
            d="M811.56 762.09C806.9 764.9 800.59 767.13 791.89 767.17C792.12 770.2 792.27 773.9 791.92 776.25C793.2 776.29 794.34 776.21 795.83 775.99C812.54 773.53 820.77 758.58 821.95 754.36C821.86 754.06 821.74 753.77 821.55 753.5C820.34 754.55 817.08 758.74 811.55 762.08L811.56 762.09Z"
            fill="#C36252"
          />
          <path
            d="M812.86 697.671C810.49 696.471 801.43 692.311 791.96 696.221C779.17 701.491 778.26 716.491 777.86 719.021C777.26 722.751 777.06 728.531 777.86 736.331C778.53 742.841 776.92 749.061 779.78 756.451C781.92 762.001 784.65 765.621 789.56 768.371C804.07 776.511 823.98 756.711 827.82 746.501C829.04 743.251 833.47 730.921 828.29 716.901C826.82 712.911 823.1 702.851 812.86 697.661V697.671Z"
            fill="#EB8E6C"
          />
          <path
            d="M834 719.18C831.71 712.25 830.15 707.51 825.81 702.7C823.11 699.71 820.41 697.86 818.86 696.93C817.38 696.04 813.43 693.85 808.17 692.85C805.01 692.25 801.39 692.09 797.54 692.9C796.85 693.05 796.17 693.26 795.45 693.43C770.19 699.44 776.28 727.54 777.52 732.44C776.1 716.99 813.97 710.57 813.9 712.51C813.12 734.55 825.61 733.13 835.39 732.62C835.65 730.8 835.75 729.32 835.69 727.87C835.56 724.71 834.96 722.11 834 719.18Z"
            fill="#1C2546"
          />
          <path
            d="M828.35 730.16C825.6 729.38 822.95 732.81 822.82 733C818.91 738.2 820.86 748.59 824.1 749.54C827.01 750.39 832.38 744.01 832.19 737.73C832.11 735.1 831.01 730.92 828.36 730.17L828.35 730.16Z"
            fill="#EB8E6C"
          />
          <path
            d="M825.09 744.15C824.98 744.27 824.9 744.35 824.9 744.36C824.9 744.36 824.98 744.27 825.09 744.15Z"
            fill="#C36252"
          />
          <path
            d="M824.78 736.091C823.77 736.391 822.96 737.281 822.59 738.441C822.45 738.861 822.71 739.321 823.11 739.391C823.42 739.441 823.69 739.231 823.8 738.911C824.04 738.191 824.52 737.641 825.12 737.461C825.94 737.221 826.83 737.731 827.18 738.341C827.57 739.011 827.48 740.151 826.93 741.471C826.53 742.441 825.89 743.261 825.44 743.771C825.77 743.411 826.02 743.131 825.42 743.791C825.32 743.901 825.23 744.001 825.16 744.081C825.08 744.171 825 744.251 824.91 744.361C823.74 745.651 824.76 745.771 824.85 745.771C825.73 745.771 826.64 744.621 827.13 743.881C828.31 742.111 829.31 739.391 828.25 737.571C827.65 736.531 826.22 735.661 824.78 736.091Z"
            fill="#C36252"
          />
          <path
            d="M825.16 744.081C825.26 743.971 825.35 743.871 825.42 743.791C825.42 743.791 825.43 743.781 825.44 743.771C825.32 743.901 825.2 744.041 825.09 744.151C825.11 744.131 825.13 744.111 825.15 744.081H825.16Z"
            fill="#C36252"
          />
          <path
            d="M829.39 730.589C828.04 729.809 826.69 730.159 826.18 730.289C824.29 730.779 823.11 732.259 822.5 733.289C822.29 733.639 822.4 734.109 822.74 734.299C823.03 734.469 823.39 734.369 823.57 734.069C824.06 733.239 825 732.049 826.48 731.669C826.9 731.559 827.88 731.309 828.81 731.839C829.68 732.339 830.06 733.289 830.33 733.979C831.02 735.719 831.15 737.719 830.72 739.919C829.92 744.019 827.43 747.299 826.14 747.519C825.74 747.589 825.61 747.939 825.45 748.339C825.03 749.439 824.48 750.459 823.36 750.459C822.8 750.459 822.57 750.309 822.46 749.419C822.41 749.049 822.12 748.779 821.79 748.799C821.42 748.829 821.15 749.199 821.2 749.609C821.33 750.649 821.75 751.869 823.37 751.869C825.49 751.869 826.32 749.699 826.63 748.889C826.63 748.869 826.65 748.849 826.65 748.829C828.55 748.179 831.12 744.549 831.97 740.209C832.58 737.099 832.05 734.789 831.51 733.399C831.2 732.619 830.68 731.309 829.41 730.569L829.39 730.589Z"
            fill="#C36252"
          />
          <path
            d="M822.7 739.101C822.61 739.311 823.25 739.571 823.73 740.361C824.65 741.881 824.01 743.771 824.26 743.821C824.45 743.861 824.92 742.841 824.97 741.731C824.99 741.221 825.04 740.191 824.4 739.531C823.79 738.901 822.8 738.861 822.7 739.101Z"
            fill="#C36252"
          />
          <path
            d="M810.46 727.961C807.6 727.431 804.69 727.221 801.79 727.341C799.97 727.421 798.14 727.621 796.34 727.961C795.63 728.091 795.17 728.791 795.32 729.491C795.47 730.161 796.12 730.591 796.79 730.471C798.48 730.161 800.19 729.961 801.9 729.891C804.61 729.781 807.34 729.971 810.02 730.471C810.69 730.591 811.34 730.161 811.49 729.491C811.65 728.781 811.18 728.091 810.46 727.951V727.961Z"
            fill="#49302A"
          />
          <path
            d="M794.51 748.881C794.44 748.581 794.11 748.381 793.78 748.451C791.01 748.961 789.12 748.741 788.41 747.831C787.83 747.081 788.08 745.951 788.59 743.701C788.77 742.891 788.98 741.971 789.19 740.881C789.63 738.601 789.94 736.291 790.11 733.991C790.13 733.671 789.86 733.401 789.51 733.381C789.16 733.371 788.86 733.611 788.84 733.931C788.67 736.181 788.37 738.461 787.94 740.701C787.73 741.771 787.53 742.681 787.35 743.481C786.79 745.981 786.48 747.351 787.37 748.501C788.24 749.621 789.96 750.061 792.49 749.801C792.97 749.751 793.48 749.681 794.01 749.581C794.37 749.511 794.6 749.201 794.53 748.881H794.51Z"
            fill="#C36252"
          />
          <path
            d="M801.46 732.621C800.46 732.621 799.65 733.881 799.65 735.441C799.65 737.001 800.46 738.261 801.46 738.261C802.46 738.261 803.27 737.001 803.27 735.441C803.27 733.881 802.46 732.621 801.46 732.621Z"
            fill="#49302A"
          />
          <path
            d="M784.28 732.621C783.28 732.621 782.47 733.881 782.47 735.441C782.47 737.001 783.28 738.261 784.28 738.261C785.28 738.261 786.09 737.001 786.09 735.441C786.09 733.881 785.28 732.621 784.28 732.621Z"
            fill="#49302A"
          />
          <path
            d="M789.4 727.9C787.98 727.63 786.5 727.43 785 727.31C783.04 727.15 781.05 727.12 779.07 727.22C778.35 727.26 777.79 727.88 777.85 728.6C777.91 729.28 778.49 729.81 779.17 729.77C781.04 729.67 782.93 729.7 784.78 729.85C786.19 729.96 787.58 730.15 788.91 730.41C789.58 730.54 790.24 730.11 790.39 729.44C790.55 728.73 790.09 728.04 789.38 727.9H789.4Z"
            fill="#49302A"
          />
          <path
            d="M799.92 753.561L796.49 753.891C793.85 754.151 791.17 754.141 788.53 753.891L786.7 753.711C785.91 753.631 785.31 754.221 785.67 754.731C786.73 756.221 788.94 758.051 792.5 758.021C796.08 757.991 799.91 756.091 800.93 754.571C801.27 754.061 800.69 753.491 799.91 753.561H799.92Z"
            fill="#C36252"
          />
          <path
            d="M807.65 739.85C805.05 740.18 803.1 741.77 803.31 743.4C803.52 745.03 805.8 746.08 808.4 745.75C811 745.42 812.95 743.83 812.74 742.2C812.53 740.57 810.25 739.52 807.65 739.85Z"
            fill="#DD8064"
          />
          <path
            d="M843.33 788.9C843.33 788.9 830.1 803.32 795.29 803.89C770 804.3 766.44 790.93 766.44 790.93C766.44 790.93 734.09 851.05 748.11 876.08C750.95 881.16 740.67 923.74 754.09 969.27C759.15 986.45 850.86 986.85 855.82 967.57C859.44 953.48 857.68 910.22 859.99 854.94C860.66 839.01 879.46 837.46 872.63 806.6C869.45 792.22 843.34 788.91 843.34 788.91L843.33 788.9Z"
            fill="#F8F8FF"
          />
          <path
            d="M762.41 798.039C762.12 795.969 760.39 794.389 758.3 794.279L740.32 793.359C735.37 793.359 733.76 796.299 734.2 799.059L742.02 837.189C742.35 839.239 744.07 840.769 746.14 840.869L763.36 841.669C766.1 841.799 768.28 839.399 767.9 836.679L762.41 798.049V798.039Z"
            fill="#474B4C"
          />
          <path
            d="M760.91 799.141C760.62 797.071 758.89 795.491 756.8 795.381L738.82 794.461C736.04 794.321 733.83 796.781 734.27 799.531L740.51 838.291C740.84 840.341 742.56 841.871 744.63 841.971L761.85 842.771C764.59 842.901 766.77 840.501 766.39 837.781L760.9 799.151L760.91 799.141Z"
            fill="#092226"
          />
          <path
            d="M827.86 894.601C820.8 894.451 814.79 890.571 804.28 883.771C783.12 870.091 776.89 856.081 774.2 857.541C770.21 859.711 781.16 891.951 803.32 916.741C812.51 927.021 819.28 932.511 826.18 930.941C833.38 929.301 850.93 899.621 859.11 882.181C859.55 876.471 858.68 868.201 859.65 861.721C852.64 870.761 837.14 894.791 827.86 894.601Z"
            fill="#97BFFF"
          />
          <path
            d="M862.43 796.641C858.42 795.921 855.26 798.451 851.05 801.661C844.4 806.731 840.58 812.161 839.67 813.471C837.76 816.231 835.04 820.591 829.16 835.901C825.02 846.701 825.2 847.581 820.99 858.631C816.65 870.001 815.99 870.291 813.4 877.821C808.42 892.271 806 899.601 809.02 904.981C812.26 910.741 820.14 913.971 826.53 912.651C831.72 911.591 833.04 913.181 839.02 904.741C851.73 886.811 859.6 872.471 862.13 867.481C866.2 859.471 871.18 849.481 873.8 835.601C873.8 835.601 879.83 799.781 862.42 796.641H862.43Z"
            fill="white"
          />
          <path
            d="M796.47 861.721C795.39 860.601 792.44 857.521 789.25 853.401C786.78 850.221 786.17 849.001 785.75 847.711C784.84 844.901 785.63 844.101 784.87 840.921C784.19 838.051 782.93 836.111 781.37 833.701C778.93 829.941 778.19 830.301 776.12 826.911C775.32 825.611 774.42 823.631 772.62 819.691C770.64 815.371 770.17 814.011 768.9 813.781C767.5 813.521 765.79 814.741 765.18 816.191C764.89 816.881 764.86 817.571 765.18 819.251C765.96 823.401 767.55 826.811 767.81 827.351C769.01 829.881 769.68 830.711 769.34 831.071C768.79 831.671 766.1 830.361 764.09 828.661C761.77 826.711 761.4 825.131 759.27 821.871C756.79 818.081 756.58 819.131 753.36 814.651C750.31 810.401 749.47 808.021 746.57 806.991C746.11 806.831 744.35 806.201 743.51 806.991C742.64 807.801 743.2 809.671 743.51 810.711C744.11 812.731 745.05 814.021 746.14 815.531C749.63 820.381 750.48 821.791 751.17 823.191C752.36 825.581 753.13 827.131 752.48 828.011C751.44 829.421 747.33 828.261 744.82 826.921C742.11 825.461 740.57 823.401 739.79 822.321C738.04 819.921 737.33 817.651 736.94 816.411C735.59 812.021 736.13 809.081 735.41 808.971C734.74 808.871 733.57 811.271 733.22 813.571C732.74 816.751 733.79 820.041 734.1 821.011C734.41 822.001 734.64 822.451 734.76 823.421C735.01 825.591 734.71 826.091 734.54 827.581C733.88 833.311 737.07 832.531 736.95 835.241C736.83 837.751 736.78 839.011 736.95 839.841C737.44 842.151 739.49 843.231 743.08 845.531C750.28 850.141 748.61 850.001 753.15 852.531C758.97 855.781 760.11 855.131 764.09 857.781C766.22 859.201 768.39 861.051 771.97 865.441C782.53 878.361 796.14 899.421 801.48 900.861C806.81 902.301 811.09 901.221 813.82 896.021C814.34 895.041 817.44 884.861 816.44 881.171C815.84 878.961 801.57 866.981 796.49 861.721H796.47Z"
            fill="#EB8E6C"
          />
          <path
            d="M735.36 824.35L734.32 825.1C738.33 830.7 743.55 833.25 746.35 834.63C746.92 834.91 747.41 835.15 747.78 835.36L748.41 834.25C748.01 834.02 747.5 833.77 746.91 833.49C744.02 832.07 739.18 829.71 735.35 824.37L735.36 824.35Z"
            fill="#C36252"
          />
          <path
            d="M736.49 835.69C738.36 837.51 742.06 840.56 745.91 840.56V839.28C742.51 839.28 739.11 836.45 737.38 834.77L736.49 835.69Z"
            fill="#C36252"
          />
          <path
            d="M832.66 885.79C830.82 884.05 829.64 883.52 823.32 880.24C809.5 873.08 807.29 869.29 806.98 870.9C804.89 881.7 801.25 887.61 788.59 890.16C788.59 890.16 797.65 900.99 798.22 901.54C802.38 905.54 809.25 911.98 819.53 914.38C822.8 915.15 824.68 915.56 827.12 914.96C834.45 913.16 840.29 903.8 838.79 895.7C837.86 890.7 834.36 887.39 832.66 885.78V885.79Z"
            fill="white"
          />
          <path
            d="M832.4 827.871H832.38C831.75 827.511 830.96 827.751 830.63 828.391C825.72 838.101 817.93 863.191 815.01 872.821C814.76 873.661 813.74 874.001 813.04 873.471C811.98 872.671 810.58 871.691 808.73 870.511C808.14 870.131 807.35 870.311 806.98 870.911V870.931C806.6 871.521 806.78 872.291 807.36 872.671C812.81 876.161 814.07 877.721 814.08 877.741C814.7 878.601 816.03 878.371 816.33 877.351V877.331C816.44 876.961 827.04 841.171 832.92 829.541C833.23 828.931 833 828.201 832.4 827.871Z"
            fill="#97BFFF"
          />
          <path
            d="M865.92 798.169C863.09 797.179 860.59 797.92 858.59 798.52C853.7 799.97 850.18 803.019 847.93 805.609C847.54 806.059 847.61 806.76 848.08 807.13C848.53 807.49 849.18 807.419 849.55 806.989C851.6 804.629 854.79 801.859 859.19 800.559C860.99 800.029 863.04 799.419 865.21 800.179C868.25 801.239 869.76 804.289 870.37 805.929C870.56 806.449 871.12 806.73 871.65 806.59C872.25 806.42 872.58 805.79 872.37 805.2C871.61 803.13 869.77 799.519 865.91 798.169H865.92Z"
            fill="#97BFFF"
          />
          <path
            d="M796.23 1059.44C792.92 1043.14 788.59 1013.33 787.78 1003.52H786.05C786.05 1012.65 791.23 1043.4 794.56 1059.78C797.1 1072.29 799.51 1084.1 800.06 1091.01C800.34 1094.49 800.06 1097.69 800.06 1097.73C800.03 1098.03 799.99 1098.57 799.93 1099.3C799.51 1104.6 798.24 1120.75 796.4 1129.79L798.07 1130.13C799.94 1120.98 801.21 1104.76 801.63 1099.43C801.69 1098.7 801.73 1098.17 801.76 1097.87C801.77 1097.73 802.05 1094.49 801.76 1090.87C801.2 1083.86 798.79 1072 796.23 1059.44Z"
            fill="#E89F1F"
          />
          <path
            d="M858.51 989.46C858.37 989.04 857.87 988.87 857.51 989.11C857.27 989.27 857.16 989.57 857.24 989.85C863.14 1010.49 862.94 1011.53 863 1016.38C863.03 1019.16 862.84 1021.35 862.52 1024.96C862.39 1026.39 862.08 1028.9 861.67 1032.08C860.56 1040.84 858.72 1055.38 858.66 1065.76C858.66 1066.13 858.96 1066.43 859.33 1066.43H859.73C860.09 1066.43 860.38 1066.15 860.39 1065.8C860.89 1055.78 862.49 1041.67 863.35 1032.3C863.65 1029.09 864.07 1026.57 864.2 1025.11C864.52 1021.44 864.72 1019.23 864.68 1016.36C864.62 1011.42 863.38 1004.28 858.49 989.46H858.51Z"
            fill="#EFB135"
          />
          <path
            d="M842.84 1138.73V1140.43C850.22 1140.43 859.25 1137.81 860.93 1136.75L860.02 1135.31C858.9 1136.02 850.2 1138.73 842.85 1138.73H842.84Z"
            fill="#E89F1F"
          />
          <path
            d="M860.14 1140.4C858.06 1140.74 854.92 1141.24 852.98 1142.05C850.46 1143.09 848.09 1144.47 845.93 1146.13L846.97 1147.48C849.01 1145.9 851.26 1144.61 853.63 1143.62C855.39 1142.89 858.41 1142.4 860.41 1142.08C860.91 1142 861.35 1141.93 861.69 1141.87L861.38 1140.19C861.05 1140.25 860.62 1140.32 860.13 1140.4H860.14Z"
            fill="#E89F1F"
          />
          <path
            d="M793.84 1149.4C793.28 1149.45 792.35 1149.53 792.19 1149.53C789.65 1149.35 787.06 1149.01 784.52 1148.49C781.88 1147.96 779.24 1147.24 776.69 1146.35L776.13 1147.96C778.76 1148.87 781.47 1149.61 784.18 1150.16C786.79 1150.68 789.45 1151.04 792.1 1151.23C792.12 1151.23 792.15 1151.23 792.18 1151.23C792.37 1151.23 792.77 1151.2 793.98 1151.09C794.46 1151.05 794.87 1151.01 794.98 1151.01L794.96 1150.39L795.03 1149.31C794.93 1149.31 794.86 1149.31 793.84 1149.4Z"
            fill="#E89F1F"
          />
          <path
            d="M785.86 1154.25C783.69 1154.11 781.5 1153.99 779.35 1153.89L779.27 1155.59C781.42 1155.69 783.6 1155.81 785.75 1155.95C786.51 1156 787.67 1156.05 788.9 1156.1C790.44 1156.17 792.04 1156.24 792.96 1156.31L793.09 1154.61C792.14 1154.54 790.53 1154.47 788.97 1154.4C787.75 1154.35 786.6 1154.3 785.86 1154.25Z"
            fill="#E89F1F"
          />
          <path
            d="M769.97 1295.91C769.01 1295.98 767.21 1296.1 765.8 1295.19C764.97 1294.66 764.78 1294.09 764.43 1293.07C764.13 1292.19 763.76 1291.09 762.86 1289.69C760.71 1286.34 757.68 1284.61 756.39 1283.87C754.86 1282.99 753.21 1282.32 751.5 1281.87L751.06 1283.52C752.63 1283.94 754.14 1284.55 755.54 1285.35C756.82 1286.08 759.5 1287.61 761.43 1290.61C762.22 1291.84 762.54 1292.78 762.83 1293.62C763.22 1294.77 763.56 1295.77 764.89 1296.62C766.23 1297.48 767.75 1297.66 768.91 1297.66C769.38 1297.66 769.79 1297.63 770.1 1297.61C771.72 1297.5 773.27 1297.03 774.72 1296.23L773.89 1294.74C772.66 1295.42 771.35 1295.82 769.98 1295.91H769.97Z"
            fill="#1C1C70"
          />
          <path
            d="M858.75 1294.93C857.44 1295.55 855.97 1295.07 853.88 1294.27C852.54 1293.76 850.98 1292.9 849.36 1291.8C848.08 1290.93 847.38 1290.32 846.7 1289.73C846.09 1289.2 845.46 1288.65 844.46 1287.96C842.8 1286.81 840.94 1285.85 838.95 1285.09L838.35 1286.69C840.21 1287.39 841.94 1288.29 843.5 1289.36C844.42 1290 844.99 1290.49 845.59 1291.01C846.3 1291.63 847.04 1292.27 848.41 1293.2C850.13 1294.37 851.81 1295.29 853.27 1295.85C854.64 1296.38 856.03 1296.92 857.43 1296.92C858.11 1296.92 858.8 1296.79 859.48 1296.47C860.28 1296.09 860.97 1295.49 861.52 1294.69L860.12 1293.72C859.74 1294.27 859.28 1294.68 858.75 1294.93Z"
            fill="#1C1C70"
          />
          <path
            d="M755.75 798.37C755.21 798.49 754.91 799.17 755.07 799.87C755.23 800.58 755.8 801.05 756.33 800.93C756.87 800.81 757.17 800.13 757.01 799.43C756.85 798.72 756.28 798.25 755.75 798.37Z"
            fill="#474B4C"
          />
          <path
            d="M843.16 789.061C840.75 790.851 838.21 792.491 835.59 793.951C833.15 795.311 826.46 798.741 817.15 801.071C804.86 804.151 794.53 803.711 789.46 803.171C786.93 802.901 784.39 802.501 781.89 801.971C781.2 801.831 780.53 802.251 780.37 802.931C780.21 803.621 780.65 804.321 781.34 804.471C783.92 805.011 786.56 805.431 789.18 805.711C791.12 805.921 793.8 806.111 797.05 806.111C802.59 806.111 809.77 805.551 817.76 803.551C827.37 801.141 834.29 797.591 836.83 796.181C839.55 794.661 842.19 792.961 844.69 791.101C845.26 790.681 845.37 789.861 844.93 789.301C844.5 788.741 843.71 788.641 843.15 789.061H843.16Z"
            fill="#97BFFF"
          />
          <path
            d="M795.93 812.271C796.869 812.271 797.63 811.51 797.63 810.571C797.63 809.632 796.869 808.871 795.93 808.871C794.991 808.871 794.23 809.632 794.23 810.571C794.23 811.51 794.991 812.271 795.93 812.271Z"
            fill="#1C1C70"
          />
          <path
            d="M795.08 815.801C794.14 815.801 793.38 816.561 793.38 817.501C793.38 818.441 794.14 819.201 795.08 819.201C796.02 819.201 796.78 818.441 796.78 817.501C796.78 816.561 796.02 815.801 795.08 815.801Z"
            fill="#1C1C70"
          />
          <path
            d="M794.23 822.641C793.29 822.641 792.53 823.401 792.53 824.341C792.53 825.281 793.29 826.051 794.23 826.051C795.17 826.051 795.93 825.291 795.93 824.341C795.93 823.391 795.17 822.641 794.23 822.641Z"
            fill="#1C1C70"
          />
          <path
            d="M837.99 678.561C832.78 677.541 825.51 678.731 822.71 682.731C819.71 687.001 818.82 699.371 827.95 705.531C830.43 707.201 832.61 708.151 834.38 708.921C839.54 711.171 843.2 712.771 846.6 711.801C851.17 710.501 852.94 705.231 853.29 704.191C856.46 694.751 849.41 680.801 837.99 678.561Z"
            fill="#1C2546"
          />
          <path
            d="M812.827 719.949L821.087 717.062C822.041 716.729 823.085 717.233 823.418 718.186L823.471 718.337C823.804 719.291 823.301 720.335 822.347 720.668L814.096 723.551C813.143 723.885 812.098 723.381 811.765 722.427L811.712 722.276C811.379 721.323 811.883 720.278 812.836 719.945L812.827 719.949Z"
            fill="#FFD147"
          />
          <path
            d="M1637 780.441C1633.71 781.901 1635.41 791.571 1636.65 801.051C1638.38 814.301 1640.19 828.171 1651.11 838.761C1656.44 843.931 1669.36 852.481 1673.74 849.411C1679.81 845.161 1669.04 821.531 1661.81 808.111C1654.74 794.991 1641.93 778.251 1637.01 780.431L1637 780.441Z"
            fill="#00582F"
          />
          <path
            d="M1295.5 669.991C1284.91 667.791 1306.26 704.511 1292.62 731.531C1263.18 789.821 1308.98 769.891 1312.57 778.961C1313.46 781.201 1330.57 821.611 1335.15 829.141C1348.98 851.891 1354.9 858.441 1379.81 890.551C1394.72 909.771 1430.99 935.141 1470.57 935.381C1494.94 935.531 1520.31 907.521 1494.5 881.551C1485.78 872.781 1457.18 821.161 1445.5 802.161C1432.8 781.521 1372.49 685.971 1295.5 669.981V669.991Z"
            fill={theme.palette.primary.main}
          />
          <path
            d="M1658.53 845.491C1662.34 843.261 1666.07 838.491 1675.69 834.501C1680.71 832.421 1685.54 831.291 1688.5 830.621C1696.6 828.771 1702.73 828.381 1704.29 828.241C1717.47 827.081 1725.02 815.471 1757.44 790.431C1766.02 783.811 1773.51 775.821 1782.32 769.511C1788.7 764.941 1795.57 760.581 1795.47 754.431C1795.43 751.791 1794.09 748.771 1791.73 747.251C1788.61 745.251 1785.38 746.941 1778.57 747.981C1770.66 749.201 1770.57 747.601 1762.94 748.501C1756.87 749.221 1756.83 750.241 1744.4 753.761C1735.23 756.361 1735.86 755.631 1724.01 758.861C1719.27 760.151 1714.96 761.411 1708.06 763.091C1695.44 766.161 1693.89 765.831 1692.94 764.901C1689.33 761.371 1694.78 749.801 1697.18 744.691C1700.3 738.071 1701.81 737.631 1703.93 731.551C1705.72 726.421 1707.85 720.001 1704.7 715.401C1703.12 713.091 1700.04 711.001 1697.54 711.661C1694.98 712.341 1694.28 715.561 1692.51 719.331C1691.12 722.291 1687.85 725.971 1681.32 733.331C1670.53 745.481 1670.55 743.061 1666.93 748.301C1661.89 755.591 1659.55 763.621 1656.64 773.601C1654.77 780.011 1654.11 783.951 1650.41 788.031C1646.55 792.281 1641.94 793.861 1639.87 794.601C1621.98 800.971 1603.74 807.461 1601.94 815.021C1598.86 827.991 1641.41 855.501 1658.55 845.471L1658.53 845.491Z"
            fill="#F9AC8A"
          />
          <path
            d="M1795.47 754.43C1795.43 751.93 1794.23 749.08 1792.08 747.5C1792.13 748.52 1792.06 749.6 1791.8 750.7C1790.97 754.23 1788.59 756.44 1787.45 757.47C1777.01 766.93 1753.27 783.39 1751.23 784.82C1737.97 794.05 1740.8 794.9 1726.58 804.51C1724.05 806.22 1714.22 812.78 1700.51 818.81C1699.95 819.06 1691.39 822.77 1679.64 825.28C1673.69 826.55 1672.03 826.42 1670.55 826C1661.13 823.32 1657.85 808.5 1656.97 809.03C1654.19 810.67 1661.89 818.87 1659.12 827.65C1658.15 830.73 1655.82 834.73 1637.65 845.36C1637.55 845.42 1637.45 845.47 1637.35 845.53C1645.44 848.09 1653.21 848.6 1658.52 845.48C1662.33 843.25 1666.06 838.48 1675.68 834.49C1680.7 832.41 1685.53 831.28 1688.49 830.61C1696.59 828.76 1702.72 828.37 1704.28 828.23C1717.46 827.07 1725.01 815.46 1757.43 790.42C1766.01 783.8 1773.5 775.81 1782.31 769.5C1788.69 764.93 1795.56 760.57 1795.46 754.42L1795.47 754.43Z"
            fill="#E58365"
          />
          <path
            d="M1716.44 769.4C1716.28 768.96 1716.5 768.48 1716.94 768.31L1766.09 749.96C1766.53 749.8 1767.01 750.02 1767.18 750.46C1767.34 750.9 1767.12 751.38 1766.68 751.55L1717.53 769.9C1717.09 770.06 1716.61 769.84 1716.44 769.4Z"
            fill="#C36252"
          />
          <path
            d="M1725.16 774.871C1724.96 774.451 1725.15 773.951 1725.57 773.751L1776.8 749.851C1777.22 749.651 1777.72 749.841 1777.92 750.261C1778.12 750.681 1777.93 751.181 1777.51 751.381L1726.28 775.281C1725.86 775.481 1725.36 775.291 1725.16 774.871Z"
            fill="#C36252"
          />
          <path
            d="M1729.36 784.43C1729.15 784.01 1729.32 783.51 1729.73 783.3L1785.35 755.25C1785.77 755.04 1786.27 755.21 1786.48 755.62C1786.69 756.04 1786.52 756.54 1786.11 756.75L1730.49 784.8C1730.07 785.01 1729.57 784.84 1729.36 784.43Z"
            fill="#C36252"
          />
          <path
            d="M1458.18 852.271C1449.53 852.601 1437.34 929.421 1458.18 933.801C1492.92 941.111 1529.57 918.081 1535.7 915.101C1556.44 905.011 1577.95 896.551 1598.61 886.281C1648.79 861.351 1673.5 852.061 1673.74 849.411C1673.83 848.491 1658.82 847.591 1645.33 818.721C1633.52 793.431 1637 780.441 1637 780.441C1561.04 808.071 1487.34 851.161 1458.17 852.271H1458.18Z"
            fill={theme.palette.primary.main}
          />
          <path
            d="M1474.14 849.891C1473.78 851.191 1473.46 852.491 1473.17 853.771C1470.95 863.581 1470.54 873.301 1471.94 882.711C1472.17 884.261 1474.04 885.151 1476.05 884.691C1477.99 884.241 1479.34 882.701 1479.12 881.211C1477.8 872.351 1478.19 863.191 1480.28 853.951C1480.56 852.731 1480.87 851.491 1481.2 850.261C1481.62 848.721 1480.44 847.391 1478.55 847.241C1476.57 847.091 1474.58 848.291 1474.14 849.901V849.891Z"
            fill={theme.palette.primary.main}
          />
          <path
            d="M1320.06 526.541C1317.92 549.731 1300.37 567.061 1280.86 565.261C1261.35 563.461 1247.28 543.201 1249.42 520.011C1251.56 496.821 1269.11 479.491 1288.62 481.291C1308.13 483.091 1322.2 503.351 1320.06 526.541Z"
            fill="#A8B4EF"
          />
          <path
            d="M1325.13 530.241C1321.08 559.781 1293.91 575.401 1273.51 563.631C1262.07 557.031 1263 548.541 1265.27 524.011C1267.54 499.481 1262.21 474.021 1300.02 482.431C1316.61 486.121 1328.48 505.861 1325.13 530.251V530.241Z"
            fill="#F8FAFF"
          />
          <path
            d="M1315.68 526.61C1313.51 550.15 1297.71 567.94 1280.41 566.34C1263.1 564.74 1250.84 544.36 1253.01 520.82C1255.18 497.28 1270.98 479.49 1288.28 481.09C1305.59 482.69 1317.85 503.07 1315.68 526.61Z"
            fill="#CFD8F9"
          />
          <path
            d="M1162.81 335.001C1137.96 332.011 1120.5 351.061 1117.9 353.991C1114.38 357.961 1105.75 367.981 1104.72 383.431C1104.49 386.921 1103.17 406.621 1114.29 414.361C1130.62 425.731 1161.6 402.841 1183.03 387.021C1199.07 375.171 1201.02 370.051 1201.26 366.101C1202.09 351.951 1181.72 337.271 1162.82 335.001H1162.81Z"
            fill="#100C5B"
          />
          <path
            d="M1145.57 374.432C1134.46 366.692 1135.77 346.992 1136 343.502C1136.08 342.252 1136.22 341.032 1136.4 339.852C1126.1 344.962 1119.42 352.272 1117.89 353.992C1114.37 357.962 1105.74 367.982 1104.71 383.432C1104.48 386.922 1103.46 406.212 1114.28 414.362C1139.1 433.072 1161.59 402.842 1183.02 387.022C1199.06 375.172 1201.04 380.002 1201.27 376.052C1201.43 373.282 1204.33 364.852 1199.46 357.832C1180.28 371.152 1158.4 383.372 1145.58 374.432H1145.57Z"
            fill="#07074C"
          />
          <path
            d="M1174.03 379.641C1088.33 408.501 1119.78 511.061 1125.96 523.071C1135.99 542.551 1163.32 570.481 1173.51 566.731C1184.73 562.601 1169.57 529.311 1188.9 492.291C1198.91 473.111 1220.29 448.881 1237.32 451.871C1265.53 456.821 1263.28 533.281 1280.82 533.571C1292.69 533.761 1300.3 498.061 1307.24 477.981C1319.08 443.721 1289.71 340.681 1174.04 379.641H1174.03Z"
            fill="#100C5B"
          />
          <path
            d="M1144.38 486.771C1139.72 474.671 1127.79 443.741 1139.98 413.711C1144.36 402.911 1151.42 393.311 1160.5 385.271C1091.84 419.911 1120.13 511.752 1125.97 523.082C1136 542.562 1163.33 570.491 1173.52 566.741C1179.96 564.371 1177.71 552.372 1178.28 535.572C1166.96 525.382 1153.14 509.471 1144.39 486.781L1144.38 486.771Z"
            fill="#07074C"
          />
          <path
            d="M1032.92 875.15C1033.89 924.04 1034.37 948.49 1027.47 979.75C1021.87 1005.11 1017.27 1025.99 1013.11 1043.27H1294.03C1293.85 1038.27 1293.65 1032.79 1293.33 1026.61C1288.82 937.54 1371.67 779.85 1344.58 694.37C1340.06 680.12 1278.37 661.84 1270.45 659.41C1245.36 651.71 1222.47 648.14 1203.98 645.25C1173.29 640.45 1156.72 633.51 1136.42 640.89C1052.52 671.4 1015.91 674.28 1011.12 677.94C1000.82 685.8 1012.99 715.92 1019.84 737.87C1030.9 773.36 1031.57 807.29 1032.92 875.16V875.15Z"
            fill={theme.palette.primary.main}
          />
          <path
            d="M1032.92 875.152C1033.89 924.042 1034.37 948.492 1027.47 979.752C1021.87 1005.11 1017.27 1025.99 1013.11 1043.27H1087.74C1094.57 1002.25 1101.74 937.132 1086.35 862.772C1070.83 787.842 1037.69 729.092 1007.18 687.682C1006.65 700.512 1014.73 721.462 1019.85 737.862C1030.91 773.352 1031.58 807.282 1032.93 875.152H1032.92Z"
            fill="#004A28"
          />
          <path
            d="M1069.22 799.91C1068.65 788.63 1066.85 748.71 1057.6 706.2C1055.72 697.58 1052.25 682.91 1040.17 676.42C1032.96 672.55 1023.51 672.02 1015.47 674.97C1009.85 677.03 1004.89 680.79 999.49 688.05C985.69 706.58 983.83 728.04 983.51 732.36C978.92 793.68 986.42 852.95 986.42 852.95C990.61 886.1 990.83 884.11 1010.73 974.42C1011.59 978.33 1073.4 990.34 1081.59 952.48C1084.96 936.91 1081.83 931.59 1076.5 884.92C1075.14 872.96 1071.15 838.03 1069.24 799.93L1069.22 799.91Z"
            fill={theme.palette.primary.main}
          />
          <path
            d="M1413.53 1001.21C1386.66 982.282 1351.1 985.292 1326.36 997.822C1314.49 1003.83 1298.46 1024.46 1300.95 1033.36C1301.92 1036.81 1310.42 1030.45 1358.98 1032.6C1409.08 1034.82 1432 1024.01 1431.69 1020.1C1431.27 1014.77 1415.77 1002.79 1413.53 1001.21Z"
            fill="#D36D59"
          />
          <path
            d="M1317.05 993.431C1317.05 993.431 1290.17 1009.52 1072.04 932.201C1043.31 922.021 1012.44 952.081 1017.91 973.181C1027.64 1010.68 1288.76 1037.83 1293.36 1027.41C1295.61 1022.29 1299.09 1027 1301.75 1015.63C1304.08 1005.68 1317.04 993.431 1317.04 993.431H1317.05Z"
            fill="#EB8E6C"
          />
          <path
            d="M1398.63 984.141C1391.23 980.361 1386.07 977.721 1379.74 978.691C1377.24 979.071 1375.63 979.851 1372.11 979.781C1366.57 979.661 1365.75 977.631 1360.12 977.241C1357.47 977.051 1352.8 976.731 1348.86 979.421C1346.2 981.241 1346.41 982.691 1344.14 983.421C1340.93 984.441 1339.09 981.991 1334.7 981.971C1333.59 981.971 1331.63 982.111 1327.44 984.151C1320.36 987.591 1315.62 992.191 1312.91 994.681C1303.76 1003.12 1301.78 1002.27 1296.57 1007.39C1283.73 1019.98 1284.78 1027.44 1287.79 1029.03C1291.44 1030.95 1300.81 1018.85 1325.99 1005.58C1330.58 1003.16 1337.19 1000.26 1343.79 1002.31C1347.23 1003.38 1347.75 1004.89 1355.78 1011.39C1366.87 1020.36 1371.22 1021.8 1372.85 1022.29C1374.69 1022.83 1383.28 1025.37 1386.65 1021.56C1389.07 1018.83 1387.22 1014.61 1388.83 1013.93C1391.12 1012.97 1394.18 1021.83 1402.63 1024.83C1406.48 1026.2 1412.35 1026.65 1414.98 1023.74C1417.05 1021.45 1416.09 1018.19 1417.89 1017.57C1419.6 1016.97 1420.88 1019.79 1424.79 1020.84C1426.9 1021.41 1430.53 1021.66 1431.69 1020.11C1434.08 1016.92 1425.46 1006.72 1422.97 1003.77C1412.93 991.871 1402.48 986.121 1398.63 984.161V984.141Z"
            fill="#EB8E6C"
          />
          <path
            d="M1374.79 998.581C1372.08 996.611 1369.15 994.931 1366.08 993.561C1365.32 993.221 1364.44 993.561 1364.13 994.331C1363.84 995.051 1364.16 995.881 1364.87 996.201C1367.78 997.491 1370.54 999.081 1373.1 1000.94C1377.31 1004 1380.95 1007.74 1383.93 1012.07C1384.38 1012.72 1385.26 1012.92 1385.92 1012.49C1386.6 1012.05 1386.8 1011.13 1386.34 1010.46C1383.17 1005.84 1379.3 1001.85 1374.8 998.591L1374.79 998.581Z"
            fill="#DB765E"
          />
          <path
            d="M1400.22 996.041C1394.73 992.051 1388.72 988.851 1382.34 986.521C1381.58 986.241 1380.74 986.661 1380.48 987.421C1380.22 988.171 1380.62 988.981 1381.37 989.261C1387.5 991.501 1393.26 994.561 1398.52 998.391C1404.84 1002.98 1410.31 1008.57 1414.79 1015C1415.24 1015.65 1416.13 1015.83 1416.79 1015.39C1417.46 1014.94 1417.65 1014.02 1417.18 1013.36C1412.51 1006.66 1406.81 1000.84 1400.22 996.051V996.041Z"
            fill="#DB765E"
          />
          <path
            d="M1346.1 1013.01C1337.92 1008.68 1329.37 1008 1320.39 1008.1C1305.84 1008.26 1298.57 1008.34 1294.46 1012.09C1286.84 1019.05 1270.22 1031.68 1275.18 1035.29C1277.14 1036.71 1294.81 1037.53 1304.31 1035.29C1317.11 1032.28 1323.51 1030.77 1329.35 1030.35C1340.73 1029.52 1345.5 1032.04 1349.67 1028.03C1351.65 1026.12 1353.35 1022.89 1352.72 1019.79C1352.16 1017.05 1349.91 1015.03 1346.1 1013.01Z"
            fill="#EB8E6C"
          />
          <path
            d="M1270.46 659.41C1245.37 651.71 1222.48 648.14 1203.99 645.25C1173.3 640.45 1156.73 633.51 1136.43 640.89C1119.15 647.17 1103.89 652.28 1090.48 656.47C1090.74 663.05 1090.97 671.43 1090.98 681.11C1091 727.29 1094.61 749.4 1094.61 749.4L1136.74 742.14L1104.78 762.48C1104.78 762.48 1119.8 791.86 1145.46 838.03C1158.81 862.06 1175.18 891.51 1185.41 932.47C1190.18 951.58 1195.58 960.8 1195.58 960.8C1195.58 960.8 1241.1 918.14 1286.38 843.12C1309.44 804.92 1312.53 763.94 1312.53 763.94L1284.93 747.23L1317.62 752.31C1317.62 752.31 1327.92 732.67 1309.12 672.61C1291.89 667.66 1274.51 660.68 1270.44 659.43L1270.46 659.41Z"
            fill="#004A28"
          />
          <path
            d="M1281.31 662.94C1282.72 659.56 1259.76 659.43 1248.26 647.6C1244.88 644.13 1234.01 625.87 1241.14 604.3C1245.5 591.12 1250.46 577.39 1250.11 568.66C1248.84 537.72 1186.62 505.59 1168.75 520.27C1162.55 525.36 1168.19 598.65 1153.27 627.89C1143.89 646.26 1115.69 640.84 1116.05 648.06C1116.37 654.44 1118.06 675.91 1137.48 678.57C1151.82 700.07 1160.42 722.4 1164.72 734.51C1176.63 768.02 1198.04 799.85 1198.28 801.61C1203.91 842.87 1204.91 865.32 1208.12 865.57C1211.23 865.81 1273.16 770.08 1281.37 682.93C1284.99 681.46 1277.43 672.3 1281.31 662.95V662.94Z"
            fill="#EB8E6C"
          />
          <path
            d="M1174.26 504.211C1173.31 511.001 1172.83 517.031 1172.6 522.121C1171.56 545.341 1169.45 579.721 1191.92 602.401C1196.71 607.231 1212.16 621.761 1229.83 620.051C1231.67 619.871 1237.09 618.451 1238.85 616.391C1241.18 599.561 1247.32 595.511 1250.23 588.121C1255.36 575.061 1250.57 565.131 1250.21 556.311C1249.07 528.441 1198.1 499.621 1174.27 504.201L1174.26 504.211Z"
            fill="#DB765E"
          />
          <path
            d="M1288.23 452.191C1283.5 444.851 1276.94 441.121 1271.93 438.611C1245.28 425.261 1228.52 416.861 1209.46 422.311C1186.61 428.851 1175.63 450.951 1169.62 463.051C1147.47 507.631 1167.05 551.671 1169.62 557.211C1179.81 579.161 1194.04 589.891 1197.69 592.521C1202.5 595.991 1225.22 612.371 1241.15 604.291C1243.47 603.111 1245.72 600.791 1250.2 596.141C1258.88 587.151 1263.79 578.691 1268.31 570.791C1272.68 563.151 1275.39 557.111 1277.36 552.681C1281.56 543.261 1283.81 538.201 1285.51 530.951C1287.27 523.401 1286.15 523.241 1288.23 510.131C1289.68 500.981 1290.24 500.991 1291.85 491.121C1293.71 479.721 1294.63 473.891 1293.66 467.581C1293.17 464.401 1292.18 458.331 1288.23 452.191Z"
            fill="#EB8E6C"
          />
          <path
            d="M1235.76 493.241C1232.18 492.021 1228.51 491.052 1224.8 490.352C1218.91 489.232 1212.9 488.782 1206.89 489.012C1205.39 489.072 1204.23 490.342 1204.33 491.842C1204.43 493.252 1205.62 494.342 1207.04 494.292C1212.67 494.082 1218.31 494.502 1223.82 495.542C1227.29 496.202 1230.73 497.112 1234.09 498.262C1235.43 498.722 1236.88 498.022 1237.38 496.702C1237.91 495.302 1237.18 493.742 1235.76 493.262V493.241Z"
            fill="#161237"
          />
          <path
            d="M1256.04 528.682C1255.79 522.832 1255.86 516.932 1256.27 511.132C1256.33 510.312 1255.66 509.582 1254.77 509.482C1253.86 509.382 1253.07 509.972 1253.01 510.802C1252.6 516.702 1252.52 522.702 1252.78 528.662C1252.9 531.512 1253.08 533.922 1253.24 536.052C1253.68 541.972 1253.9 544.942 1252.15 546.622C1250 548.682 1245.09 548.522 1238.25 546.192C1237.42 545.912 1236.51 546.282 1236.22 547.022C1235.91 547.812 1236.39 548.702 1237.27 549.002C1238.6 549.452 1239.86 549.832 1241.06 550.132C1247.39 551.732 1251.92 551.272 1254.56 548.742C1257.25 546.162 1256.98 542.542 1256.49 535.992C1256.33 533.882 1256.15 531.492 1256.03 528.692L1256.04 528.682Z"
            fill="#C36252"
          />
          <path
            d="M1224.61 503.071C1222.07 502.701 1219.55 505.601 1218.97 509.561C1218.39 513.521 1219.98 517.031 1222.51 517.401C1225.05 517.771 1227.57 514.871 1228.15 510.911C1228.73 506.951 1227.14 503.441 1224.61 503.071Z"
            fill="#23173D"
          />
          <path
            d="M1273.87 509.141C1271.33 508.771 1268.81 511.671 1268.23 515.631C1267.65 519.591 1269.24 523.101 1271.77 523.471C1274.31 523.841 1276.83 520.941 1277.41 516.981C1277.99 513.021 1276.4 509.511 1273.87 509.141Z"
            fill="#23173D"
          />
          <path
            d="M1285.07 497.921C1280.56 497.251 1275.98 496.811 1271.4 496.631C1267.9 496.491 1264.44 496.511 1261.07 496.671C1259.38 496.751 1258.08 497.951 1258.19 499.321C1258.29 500.621 1259.64 501.581 1261.24 501.501C1264.4 501.351 1267.66 501.341 1270.95 501.471C1275.28 501.641 1279.62 502.051 1283.9 502.691C1285.46 502.921 1287 502.081 1287.38 500.811C1287.78 499.471 1286.73 498.161 1285.08 497.921H1285.07Z"
            fill="#161237"
          />
          <path
            d="M1248.31 565.79L1245.19 565.74C1240.69 565.67 1236.11 564.94 1231.57 563.56L1225.68 561.77C1224.34 561.36 1223.38 562.66 1223.99 564.04C1225.81 568.18 1232.47 574.05 1238.59 575.11C1244.68 576.17 1248.36 572.13 1250.1 568.65C1250.69 567.46 1249.64 565.8 1248.29 565.78L1248.31 565.79Z"
            fill="#FEFDFB"
          />
          <path
            d="M1206.19 519.151C1199.69 517.331 1193.5 519.151 1192.37 523.221C1191.24 527.281 1195.58 532.051 1202.08 533.861C1208.58 535.681 1214.77 533.861 1215.9 529.791C1217.03 525.731 1212.69 520.961 1206.19 519.151Z"
            fill="#DD8064"
          />
          <path
            d="M1274.25 529.88C1268.98 529.72 1264.63 532.26 1264.52 535.55C1264.42 538.84 1268.61 541.65 1273.88 541.81C1279.15 541.97 1283.51 539.43 1283.61 536.14C1283.71 532.84 1279.52 530.04 1274.25 529.88Z"
            fill="#DD8064"
          />
          <path
            d="M1272.7 655.962C1265.23 755.202 1213.22 880.422 1209.63 880.152C1206 879.872 1203.4 863.492 1197.05 816.952C1196.78 814.962 1190.14 767.572 1176.71 729.782C1170.15 711.312 1160.43 673.102 1130.85 637.672C1120.51 641.332 1098.77 650.842 1096.38 654.612C1096.38 685.712 1108.43 737.042 1108.43 737.042C1108.43 737.042 1151.1 734.222 1152.02 737.042C1152.9 739.752 1118.6 761.742 1118.6 761.742C1118.6 761.742 1170.48 841.652 1198.51 944.802C1198.51 944.802 1225.57 914.732 1262.44 860.532C1303.7 799.862 1301.67 766.092 1301.67 766.092C1301.67 766.092 1272.61 744.672 1274.07 741.392C1275.56 738.022 1306.03 742.842 1306.03 742.842C1306.03 742.842 1315.9 721.532 1300.52 667.622C1293.44 661.962 1277.83 657.382 1272.71 655.952L1272.7 655.962Z"
            fill={theme.palette.primary.main}
          />
          <path
            d="M1217.1 749.462C1203.57 749.032 1191.57 746.992 1181.46 744.422C1191.71 778.802 1196.81 815.222 1197.05 816.952C1203.4 863.482 1204.52 888.812 1208.15 889.092C1210.75 889.292 1238.55 821.232 1257.06 745.852C1245.18 748.462 1232.41 749.942 1217.11 749.462H1217.1Z"
            fill="#FFBABA"
          />
          <path
            d="M1228.72 404.67C1200.68 400.59 1175.31 439.45 1165.71 463.34C1155.51 488.73 1156.7 513.21 1159.76 513.94C1162.36 514.56 1164.35 497.59 1179.73 486.64C1181.36 485.48 1184.05 483.74 1202.92 477.6C1228.85 469.17 1231.66 469.89 1239.39 465.23C1245.69 461.44 1259.34 453.22 1260.83 440.64C1262.66 425.2 1245.7 407.14 1228.73 404.67H1228.72Z"
            fill="#100C5B"
          />
          <path
            d="M1256.91 429.73C1252.91 433.38 1256.28 443.46 1256.81 450.66C1257.18 455.68 1294.67 463.89 1289.45 523.88C1289.29 525.75 1292.68 504.57 1299.43 469.65C1301.78 457.47 1302.85 453.47 1300.73 447.96C1294.18 430.88 1265.76 421.69 1256.91 429.74V429.73Z"
            fill="#100C5B"
          />
          <path
            d="M1157.16 488.731C1150.14 489.641 1145.78 497.911 1144.6 504.571C1142.78 514.811 1149.21 525.561 1155.33 533.191C1158.72 537.421 1161.26 542.201 1164.01 541.821C1172.59 540.621 1178.18 510.721 1170.19 496.051C1169.91 495.531 1164.46 487.781 1157.17 488.731H1157.16Z"
            fill="#EB8E6C"
          />
          <path
            d="M1164.03 503.191C1160.52 501.551 1156.58 503.241 1154.65 505.661C1151.28 509.901 1152.82 517.171 1155.15 522.121C1156.12 524.181 1158 527.451 1160.24 527.781C1160.48 527.821 1163.12 527.891 1160.62 524.181C1160.42 523.881 1160.25 523.631 1160.08 523.381C1159.92 523.151 1159.72 522.861 1159.51 522.531C1158.23 520.631 1158.77 521.421 1159.47 522.471C1158.51 520.991 1157.2 518.691 1156.54 516.071C1155.65 512.501 1155.85 509.571 1157.08 508.011C1158.22 506.581 1160.67 505.611 1162.66 506.541C1164.11 507.221 1165.14 508.781 1165.48 510.711C1165.63 511.571 1166.26 512.211 1167.05 512.191C1168.1 512.171 1168.91 511.101 1168.72 509.971C1168.19 506.881 1166.47 504.331 1164.02 503.181L1164.03 503.191Z"
            fill="#C36252"
          />
          <path
            d="M1160.62 524.17C1160.62 524.17 1160.46 523.92 1160.21 523.57C1160.45 523.92 1160.62 524.17 1160.62 524.17Z"
            fill="#C36252"
          />
          <path
            d="M1159.51 522.54C1159.67 522.78 1159.86 523.06 1160.08 523.39C1160.13 523.46 1160.17 523.52 1160.21 523.58C1159.99 523.26 1159.72 522.86 1159.47 522.49C1159.48 522.51 1159.5 522.53 1159.51 522.55V522.54Z"
            fill="#C36252"
          />
          <path
            d="M1162.62 487.932C1161.38 487.412 1158.08 486.012 1154.35 487.492C1150.84 488.882 1149.03 492.022 1147.96 493.892C1146.05 497.222 1143.85 502.902 1144.24 511.042C1144.79 522.402 1149.96 532.582 1154.55 534.942C1154.56 534.992 1154.57 535.042 1154.59 535.102C1155.08 537.292 1156.39 543.111 1161.78 543.911C1165.91 544.521 1167.42 541.552 1168.14 538.962C1168.43 537.942 1167.87 536.892 1166.94 536.682C1166.09 536.492 1165.25 537.082 1165 538.002C1164.38 540.222 1163.74 540.512 1162.32 540.302C1159.47 539.882 1158.46 537.082 1157.8 534.122C1157.55 533.032 1157.34 532.092 1156.36 531.772C1153.17 530.742 1148.06 521.452 1147.55 510.732C1147.28 504.972 1148.35 499.932 1150.75 495.762C1151.7 494.112 1153 491.852 1155.41 490.892C1157.98 489.872 1160.37 490.892 1161.4 491.312C1165.01 492.832 1166.95 496.212 1167.9 498.512C1168.24 499.352 1169.12 499.732 1169.92 499.402C1170.84 499.032 1171.3 497.872 1170.9 496.912C1169.72 494.062 1167.28 489.852 1162.66 487.902L1162.62 487.932Z"
            fill="#C36252"
          />
          <path
            d="M1163.69 512.111C1161.82 513.551 1161.55 516.201 1161.42 517.511C1161.14 520.361 1161.95 523.121 1162.45 523.081C1163.12 523.031 1162.19 517.991 1165.1 514.471C1166.6 512.651 1168.33 512.211 1168.19 511.651C1168.03 511.001 1165.48 510.741 1163.7 512.121L1163.69 512.111Z"
            fill="#C36252"
          />
          <path
            d="M1145.56 546.885C1165.03 544.762 1178.77 524.277 1176.25 501.13C1173.73 477.983 1155.89 460.939 1136.42 463.061C1116.95 465.184 1103.2 485.669 1105.73 508.816C1108.25 531.963 1126.08 549.007 1145.56 546.885Z"
            fill="#F8FAFF"
          />
          <path
            d="M1181.98 503.679C1183.9 533.429 1160.39 554.149 1138.06 546.689C1125.53 542.509 1124.75 533.989 1122.08 509.509C1119.41 485.019 1109.12 461.129 1147.84 461.829C1164.84 462.139 1180.4 479.109 1181.98 503.679Z"
            fill="#CFD8F9"
          />
          <path
            d="M1171.99 502.001C1174.55 525.501 1162.62 546.081 1145.35 547.961C1128.07 549.841 1111.99 532.321 1109.43 508.821C1106.87 485.321 1118.8 464.741 1136.07 462.861C1153.35 460.981 1169.43 478.501 1171.99 502.001Z"
            fill="#EBEFF7"
          />
          <path
            d="M1155.01 503.849C1156.18 514.599 1150.73 523.999 1142.83 524.869C1134.93 525.729 1127.58 517.719 1126.4 506.969C1125.23 496.219 1130.68 486.819 1138.58 485.949C1146.48 485.079 1153.83 493.099 1155.01 503.849Z"
            fill="#AABDF2"
          />
          <path
            d="M1140.59 498.74L1140.35 498.68C1136.66 497.81 1134.4 494.07 1135.34 490.4C1141.38 466.94 1149.68 445.48 1160.06 426.52C1164.75 417.95 1169.69 411.74 1175.65 405.05C1197.69 380.31 1233.22 369.76 1263.85 380.87C1282.38 387.59 1290.06 396.42 1297.4 412.38C1299.21 416.32 1301.56 423.19 1300.2 420.28C1294.59 408.28 1274.37 397.39 1256.34 392.6C1230.05 385.62 1204.39 393.49 1185.93 414.2C1180.44 420.36 1176.22 425.67 1172.14 433.13C1162.31 451.08 1154.43 471.48 1148.68 493.84C1147.76 497.4 1144.17 499.57 1140.59 498.73V498.74Z"
            fill="#F8FAFF"
          />
          <path
            d="M1010.71 974.4C1015.55 1005.7 1268.53 1048.59 1282.38 1036.57C1289.17 1030.69 1292.91 976.56 1287.77 976.24C1270.62 975.18 1233.81 966.55 1216.77 964.31C1208.11 963.17 1191.46 958.52 1158.15 949.2C1126.56 940.37 1110.56 935.85 1100.74 931.07C1073.74 917.92 1072.56 908.97 1060.25 909.32C1031.06 910.13 1006.7 948.54 1010.7 974.39L1010.71 974.4Z"
            fill={theme.palette.primary.main}
          />
          <path
            d="M1209.15 564.47C1208.86 565.63 1207.67 566.33 1206.52 566.02C1196.69 563.39 1187.05 559.92 1177.83 555.7C1164.37 549.54 1151.67 541.71 1140.04 532.43C1139.11 531.69 1138.97 530.32 1139.73 529.4C1140.48 528.49 1141.82 528.35 1142.74 529.09C1154.09 538.15 1166.49 545.78 1179.63 551.8C1188.63 555.92 1198.03 559.3 1207.63 561.87C1208.77 562.18 1209.46 563.33 1209.17 564.47H1209.15Z"
            fill="#EBEFF7"
          />
          <path
            d="M1204.33 571.51C1209.6 571.51 1213.88 567.235 1213.88 561.96C1213.88 556.686 1209.6 552.41 1204.33 552.41C1199.06 552.41 1194.78 556.686 1194.78 561.96C1194.78 567.235 1199.06 571.51 1204.33 571.51Z"
            fill="#EBEFF7"
          />
          <path
            d="M507.01 940.35C506.97 944.67 507.01 950.62 507.36 957.71C507.54 961.45 507.73 965.25 508.25 970.29C509.06 978.16 509.86 985.54 512.68 994.38C513.92 998.26 515.2 1001.32 516.05 1003.24H516.15C516.12 1003.33 516.1 1003.42 516.1 1003.51C516.1 1005.52 524.1 1007.14 533.97 1007.14C543.84 1007.14 551.84 1005.51 551.84 1003.51C551.84 1003.42 551.82 1003.33 551.79 1003.24H551.84C552.69 1001.33 553.97 998.26 555.21 994.38C558.03 985.53 558.83 978.15 559.64 970.29C560.16 965.25 560.34 961.46 560.53 957.71C560.88 950.61 560.92 944.66 560.88 940.35H507.02H507.01Z"
            fill="white"
          />
          <path
            d="M546.65 940.35C547.19 955.75 546.42 974.11 541.3 987.46C537.84 996.5 533.64 999.97 530.62 1001.7C525.91 1004.4 520.8 1004.75 516.53 1004.3C518.31 1005.92 525.44 1007.14 533.96 1007.14C543.83 1007.14 551.83 1005.51 551.83 1003.51C551.83 1003.42 551.81 1003.33 551.78 1003.24H551.83C552.68 1001.33 553.96 998.26 555.2 994.38C558.02 985.53 558.82 978.15 559.63 970.29C560.15 965.25 560.33 961.46 560.52 957.71C560.87 950.61 560.91 944.66 560.87 940.35H546.65Z"
            fill="#F8FAFF"
          />
          <path
            d="M575.4 949.82C572.71 948.15 570.14 947.99 568.22 947.87C566.63 947.77 564.43 947.66 562.02 948.76C561.08 949.18 559.87 949.73 558.92 950.97C556.88 953.63 557.22 957.94 558.65 958.59C559.54 958.99 560.95 958.03 561.57 957.44C562.24 956.81 562.19 956.44 563.25 955.14C563.82 954.43 564.2 953.96 564.76 953.55C566.02 952.6 567.4 952.48 568.39 952.4C569.13 952.34 570.97 952.2 573 953.11C576.2 954.54 577.47 957.49 577.78 958.25C579.18 961.65 578.22 964.74 577.87 965.87C577.25 967.88 576.25 969.21 575.12 970.74C573.96 972.31 572.97 973.25 571.05 975.08C564.94 980.87 560.08 984.08 559 983.94C557.76 983.78 557.49 982.27 556.79 982.26C554.87 982.21 551.99 993.24 554.04 994.22C554.5 994.44 555.04 994.07 558.82 990.77C563.01 987.11 565.67 984.67 567.86 982.71C571.4 979.53 571.95 979.19 573.79 977.31C577.21 973.83 578.37 971.93 578.75 971.29C579.6 969.84 580.79 967.79 581.32 964.82C581.57 963.43 582.04 960.62 580.97 957.29C580.61 956.16 579.29 952.28 575.39 949.85L575.4 949.82Z"
            fill="white"
          />
          <path
            opacity="0.59"
            d="M538.52 876.85C535.92 869.9 542.98 863.261 542.35 862.881C541.5 862.361 529.33 873.711 531.94 883.151C533.94 890.391 542.9 890.281 544.27 898.211C545.03 902.651 543.15 908.081 539.61 910.811C537.78 912.221 525.6 916.841 525.64 927.521C525.67 935.371 532.49 942.311 532.49 942.311C532.49 942.311 531.35 930.811 537.69 924.781C541.72 920.951 545.18 923.481 550.56 919.581C556.58 915.221 560.54 906.25 557.96 899.86C552.21 885.63 541.8 885.63 538.51 876.85H538.52Z"
            fill="white"
          />
          <path
            opacity="0.59"
            d="M515.24 836.609C514.89 836.899 516.72 838.699 517.98 842.909C518.71 845.339 519.64 848.459 518.8 851.679C517.54 856.499 514.44 856.689 512.77 860.719C509.15 869.479 520.25 880.369 520.71 880.169C521.31 879.919 515.06 871.509 517.42 862.909C519.38 855.789 525.46 855.059 525.64 849.489C525.87 842.289 515.96 836.009 515.23 836.619L515.24 836.609Z"
            fill="white"
          />
          <path
            d="M200.47 1274.07C203.73 1273.61 206 1270.6 205.54 1267.34L181.86 1099.03C181.4 1095.77 178.39 1093.5 175.13 1093.96C171.87 1094.42 169.6 1097.43 170.06 1100.69L193.74 1269C194.2 1272.26 197.21 1274.53 200.47 1274.07Z"
            fill="#0E2342"
          />
          <path
            d="M88.45 1269.44L110.8 1100.6C111.23 1097.34 108.94 1094.34 105.67 1093.91C102.41 1093.48 99.41 1095.77 98.98 1099.04L76.63 1267.88C76.2 1271.14 78.49 1274.14 81.76 1274.57C85.02 1275 88.02 1272.71 88.45 1269.44Z"
            fill="#0E2342"
          />
          <path
            d="M189.65 1190.57H84.63V1203.96H189.65V1190.57Z"
            fill="#152B4C"
          />
          <path
            d="M278.28 1265.33L268.44 1264.09L294.99 1011.33L315.38 1013.9L278.28 1265.33Z"
            fill="#46466B"
          />
          <path
            d="M517.24 1265.33L527.08 1264.09L500.53 1011.33L480.14 1013.9L517.24 1265.33Z"
            fill="#46466B"
          />
          <path
            d="M208.93 1298.2C212.19 1297.74 214.46 1294.73 214 1291.47L190.32 1123.16C189.86 1119.9 186.85 1117.63 183.59 1118.09C180.33 1118.55 178.06 1121.56 178.52 1124.82L202.2 1293.13C202.66 1296.39 205.67 1298.66 208.93 1298.2Z"
            fill="#1E3863"
          />
          <path
            d="M79.36 1293.57L101.71 1124.73C102.14 1121.47 99.85 1118.47 96.58 1118.04C93.32 1117.61 90.32 1119.9 89.89 1123.17L67.54 1292.01C67.11 1295.27 69.4 1298.27 72.67 1298.7C75.93 1299.13 78.93 1296.84 79.36 1293.57Z"
            fill="#1E3863"
          />
          <path
            d="M208.93 1298.2C212.19 1297.74 214.46 1294.73 214 1291.47L190.32 1123.16C189.86 1119.9 186.85 1117.63 183.59 1118.09C180.33 1118.55 178.06 1121.56 178.52 1124.82L202.2 1293.13C202.66 1296.39 205.67 1298.66 208.93 1298.2Z"
            fill="#1E3863"
          />
          <path
            d="M79.36 1293.57L101.71 1124.73C102.14 1121.47 99.85 1118.47 96.58 1118.04C93.32 1117.61 90.32 1119.9 89.89 1123.17L67.54 1292.01C67.11 1295.27 69.4 1298.27 72.67 1298.7C75.93 1299.13 78.93 1296.84 79.36 1293.57Z"
            fill="#1E3863"
          />
          <path
            d="M174.88 1111.92H81.36L55.65 927.5H144.5C149.61 927.5 153.91 931.33 154.5 936.4L174.88 1111.91V1111.92Z"
            fill="#29416D"
          />
          <path
            d="M185.38 1122.49H285.74V1102.94H185.38V1122.49Z"
            fill="#1E3863"
          />
          <path
            d="M152.92 1271.87C152.02 1269.32 153.4 1265.22 156.15 1257.02C159.12 1248.16 160.68 1243.7 164.22 1242.17C165.18 1241.75 165.55 1241.83 176.49 1242.82C182.96 1243.4 183.92 1243.48 184.88 1244.43C187.36 1246.91 185.53 1251.06 184.88 1257.99C183.67 1270.84 188.29 1274.21 185.53 1278.01C180.22 1285.31 156.5 1282.03 152.92 1271.88V1271.87Z"
            fill="#EB8E6C"
          />
          <path
            d="M314.18 1271.87C313.28 1269.32 314.66 1265.22 317.41 1257.02C320.38 1248.16 321.94 1243.7 325.48 1242.17C326.44 1241.75 326.74 1244.52 330.72 1245.08C337.15 1245.98 339.91 1263.37 349.81 1275.43C355.54 1282.4 317.76 1282.04 314.18 1271.88V1271.87Z"
            fill="#EB8E6C"
          />
          <path
            d="M144.37 1038.14C149.17 1049.31 181.52 1034.37 269.62 1056.76C282.52 1060.04 289.36 1084.35 290.61 1088.83C290.61 1088.83 297.98 1115.18 314.5 1167.6C329.36 1214.75 344.82 1248.31 340.95 1255.33C338.93 1258.99 319.19 1265.56 315.14 1259.2C247.85 1153.4 264.22 1118.21 248.64 1108.2C243.18 1104.69 240.23 1105.09 229.27 1102.39C229.27 1102.39 194.78 1093.9 164.06 1072.04C140.4 1055.21 118.14 1029.2 123.38 1020.39C123.84 1019.61 124.29 1019.36 140.81 1014.58C153.5 1010.91 156.83 1010.02 161.47 1010.71C167.59 1011.62 136.73 1020.38 144.36 1038.15L144.37 1038.14Z"
            fill="#6898DD"
          />
          <path
            d="M237.19 1078.35C245.32 1080.21 256.62 1081.8 263.41 1090.86C268.59 1097.76 268.68 1105.7 268.77 1108.74C269.94 1145.19 295.65 1197.68 309.29 1225.54C313.57 1234.29 320.05 1246.61 329.18 1260.93C323.38 1262.32 317.22 1262.44 315.15 1259.19C247.86 1153.39 264.23 1118.2 248.65 1108.19C243.19 1104.68 240.24 1105.08 229.28 1102.38C229.28 1102.38 194.79 1093.89 164.07 1072.03C140.41 1055.2 118.15 1029.19 123.39 1020.38C123.78 1019.72 124.17 1019.44 134.5 1016.41C160.24 1039.68 179.35 1050.61 189.51 1055.7C218.27 1070.11 232.65 1077.31 237.18 1078.34L237.19 1078.35Z"
            fill="#608ED8"
          />
          <path
            d="M89.7 1041.41C92.36 1016.04 95.58 985.19 118.9 957.39C129.59 944.64 141.52 936.09 151.56 930.42C153.14 931.98 154.22 934.06 154.49 936.41L174.87 1111.92H93.14C89.08 1091.7 86.93 1067.81 89.69 1041.41H89.7Z"
            fill="#1E3863"
          />
          <path
            d="M187.85 1088.2L147.43 1091.04L91.43 1102.42L231.56 1103.75L187.85 1088.2Z"
            fill="#132C51"
          />
          <path
            d="M107.61 1013.07C101.11 1019.68 94.93 1024.82 92.68 1036.64C90.85 1046.25 93.42 1059.99 97.28 1069.89C104.16 1087.55 126.23 1093.8 136.02 1096.58C173.74 1107.27 206.61 1101.75 206.61 1101.75C206.61 1101.75 206.29 1110.81 195.42 1137.05C185.74 1160.43 162.59 1223.57 157.76 1244.12C156.47 1249.61 177.77 1257.03 185.95 1254.99C195.32 1252.65 227.7 1188.14 250.52 1136.19C265.26 1102.63 275.47 1077.61 252.23 1061.26C232.61 1047.45 167.8 1041.28 159.52 1032.08C155.28 1027.36 170.06 1018.46 167.01 1014.8C155.3 1000.72 122.77 997.659 107.61 1013.08V1013.07Z"
            fill="#8EB7E8"
          />
          <path
            d="M92.68 1036.64C94.93 1024.81 101.1 1019.68 107.61 1013.07C109.84 1010.8 112.46 1008.93 115.32 1007.44C111.87 1017.38 107.25 1037.47 117.71 1055.71C126.67 1071.34 142.34 1078.03 148.7 1080.74C158.88 1085.08 167.59 1086.01 179.69 1087.29C206.77 1090.17 219.62 1090.87 219.62 1090.87C226.4 1098.55 217.33 1115.42 204.72 1143.31C204.72 1143.31 201.84 1149.67 174.33 1217.8C170.71 1226.77 166.73 1237.48 162.81 1249.9C159.47 1248.04 157.33 1245.97 157.76 1244.12C162.6 1223.57 185.74 1160.43 195.42 1137.05C206.29 1110.81 206.61 1101.75 206.61 1101.75C206.61 1101.75 173.73 1107.28 136.02 1096.58C126.23 1093.81 104.16 1087.55 97.28 1069.89C93.42 1060 90.85 1046.26 92.68 1036.64Z"
            fill="#79AEE2"
          />
          <path
            d="M148.92 1271.89C149.96 1267.82 150.19 1265.33 150.93 1265.2C156.53 1264.24 179.88 1264.95 179.88 1264.95C179.88 1264.95 177.62 1258.22 178.39 1254.7C178.76 1253 184.76 1253.14 185.28 1254.06C186.49 1256.21 184.11 1259.03 185.18 1264.47C185.69 1267.04 186.81 1268.83 187.42 1269.79C189.69 1273.33 193.82 1275.42 201.98 1279.46C205.35 1281.13 207.07 1281.97 208.66 1282.35C214.26 1283.68 218.18 1283.5 218.18 1283.5C219.2 1283.45 220.58 1283.33 222.06 1284.07C223.51 1284.79 224.29 1285.97 224.68 1286.57C226.1 1288.76 227.15 1292.56 225.66 1295.05C224.4 1297.16 221.72 1297.69 216.63 1298.14C204.8 1299.2 194.92 1298.51 191.38 1298.25C182.43 1297.59 183.09 1297.41 178.5 1297.25C167.51 1296.87 161.2 1297.09 161.2 1297.09C159.79 1297.14 154.81 1297.33 148.86 1295.74C146.03 1294.98 145.4 1294.47 144.99 1293.94C143.32 1291.76 145.27 1289.09 147.24 1279.84C147.94 1276.55 148 1275.45 148.9 1271.91L148.92 1271.89Z"
            fill="#F9F9F9"
          />
          <path
            d="M175.87 1268.99C177.07 1268.31 178.31 1267.69 179.56 1267.16C181.17 1266.47 182.83 1265.9 184.52 1265.45C184.93 1265.34 185.34 1265.6 185.44 1266.01C185.54 1266.42 185.29 1266.82 184.89 1266.92C183.28 1267.35 181.69 1267.9 180.16 1268.55C178.96 1269.06 177.78 1269.65 176.63 1270.3C176.27 1270.5 175.81 1270.39 175.6 1270.03C175.38 1269.67 175.5 1269.19 175.87 1268.98V1268.99Z"
            fill="#4E5475"
          />
          <path
            d="M181.85 1271.31C182.32 1270.99 182.8 1270.68 183.29 1270.38C184.19 1269.84 185.13 1269.34 186.1 1268.9C186.49 1268.72 186.95 1268.9 187.12 1269.29C187.28 1269.67 187.12 1270.1 186.74 1270.27C185.83 1270.69 184.93 1271.16 184.08 1271.68C183.62 1271.96 183.16 1272.25 182.71 1272.56C182.37 1272.79 181.91 1272.71 181.67 1272.38C181.42 1272.03 181.5 1271.55 181.85 1271.3V1271.31Z"
            fill="#4E5475"
          />
          <path
            d="M187.52 1272.57C187.93 1272.27 188.38 1272 188.84 1271.79C189.25 1271.6 189.74 1271.79 189.89 1272.23C190.01 1272.59 189.85 1273 189.5 1273.16C189.12 1273.34 188.75 1273.55 188.41 1273.8C188.1 1274.03 187.81 1274.28 187.55 1274.56C187.28 1274.85 186.84 1274.89 186.53 1274.66C186.17 1274.38 186.13 1273.86 186.44 1273.53C186.77 1273.18 187.13 1272.86 187.52 1272.58V1272.57Z"
            fill="#4E5475"
          />
          <path
            d="M190.73 1274.64C190.97 1274.47 191.21 1274.31 191.45 1274.16C191.82 1273.93 192.3 1274.06 192.51 1274.44C192.7 1274.8 192.59 1275.24 192.25 1275.45C192.03 1275.59 191.82 1275.73 191.61 1275.88C191.37 1276.05 191.13 1276.24 190.89 1276.43C190.58 1276.69 190.12 1276.66 189.85 1276.36C189.56 1276.04 189.59 1275.54 189.92 1275.26C190.18 1275.04 190.45 1274.84 190.73 1274.64Z"
            fill="#4E5475"
          />
          <path
            d="M195.41 1276.52C195.58 1276.43 195.75 1276.36 195.92 1276.31C196.42 1276.16 196.92 1276.56 196.89 1277.08C196.87 1277.39 196.67 1277.67 196.37 1277.76C196.28 1277.79 196.19 1277.82 196.1 1277.87C195.81 1278.02 195.61 1278.24 195.46 1278.46C195.26 1278.75 194.9 1278.88 194.57 1278.76C194.11 1278.59 193.92 1278.03 194.2 1277.63C194.46 1277.24 194.85 1276.81 195.41 1276.53V1276.52Z"
            fill="#4E5475"
          />
          <path
            d="M148.92 1271.89C149.96 1267.82 150.19 1265.33 150.93 1265.2C152.08 1265 153.97 1264.88 156.25 1264.8C155.49 1267.34 154.73 1271.75 156.62 1276.42C157.17 1277.78 158.68 1280.62 161.62 1283.15C167.81 1288.47 185.18 1290.1 189.5 1290.5C203.41 1291.79 218.26 1290.24 225.93 1289.21C226.54 1291.16 226.67 1293.38 225.68 1295.03C224.42 1297.14 221.74 1297.67 216.65 1298.12C204.82 1299.18 194.94 1298.49 191.4 1298.23C182.45 1297.57 183.11 1297.39 178.52 1297.23C167.53 1296.85 161.22 1297.07 161.22 1297.07C159.81 1297.12 154.83 1297.31 148.88 1295.72C146.05 1294.96 145.42 1294.45 145.01 1293.92C143.34 1291.74 145.29 1289.07 147.26 1279.82C147.96 1276.53 148.02 1275.43 148.92 1271.89Z"
            fill="#EDEFF4"
          />
          <path
            d="M166.94 1289.36C173.92 1290.22 173.43 1290.5 179.46 1291.24C180.28 1291.34 188.28 1292.31 197.28 1292.47C208.06 1292.66 218.05 1291.64 226.22 1290.36C226.54 1292 226.48 1293.7 225.68 1295.04C224.42 1297.15 221.74 1297.68 216.65 1298.13C204.82 1299.19 194.94 1298.5 191.4 1298.24C182.45 1297.58 183.11 1297.4 178.52 1297.24C167.53 1296.86 161.22 1297.08 161.22 1297.08C159.81 1297.13 154.83 1297.32 148.88 1295.73C146.05 1294.97 145.42 1294.46 145.01 1293.93C143.84 1292.4 144.45 1290.63 145.6 1286.52C151.17 1287.32 161.47 1288.7 166.95 1289.37L166.94 1289.36Z"
            fill="#88BDE5"
          />
          <path
            d="M311.89 1271.89C312.93 1267.82 313.16 1265.33 313.9 1265.2C319.5 1264.24 342.85 1264.95 342.85 1264.95C342.85 1264.95 340.59 1258.22 341.36 1254.7C341.73 1253 347.73 1253.14 348.25 1254.06C349.46 1256.21 347.08 1259.03 348.15 1264.47C348.66 1267.04 349.78 1268.83 350.39 1269.79C352.66 1273.33 356.79 1275.42 364.95 1279.46C368.32 1281.13 370.04 1281.97 371.63 1282.35C377.23 1283.68 381.15 1283.5 381.15 1283.5C382.17 1283.45 383.55 1283.33 385.03 1284.07C386.48 1284.79 387.26 1285.97 387.65 1286.57C389.07 1288.76 390.12 1292.56 388.63 1295.05C387.37 1297.16 384.69 1297.69 379.6 1298.14C367.77 1299.2 357.89 1298.51 354.35 1298.25C345.4 1297.59 346.06 1297.41 341.47 1297.25C330.48 1296.87 324.17 1297.09 324.17 1297.09C322.76 1297.14 317.78 1297.33 311.83 1295.74C309 1294.98 308.37 1294.47 307.96 1293.94C306.29 1291.76 308.24 1289.09 310.21 1279.84C310.91 1276.55 310.97 1275.45 311.87 1271.91L311.89 1271.89Z"
            fill="#F9F9F9"
          />
          <path
            d="M338.84 1268.99C340.04 1268.31 341.28 1267.69 342.53 1267.16C344.14 1266.47 345.8 1265.9 347.49 1265.45C347.9 1265.34 348.31 1265.6 348.41 1266.01C348.51 1266.42 348.26 1266.82 347.86 1266.92C346.25 1267.35 344.66 1267.9 343.13 1268.55C341.93 1269.06 340.75 1269.65 339.6 1270.3C339.24 1270.5 338.78 1270.39 338.57 1270.03C338.35 1269.67 338.47 1269.19 338.84 1268.98V1268.99Z"
            fill="#4E5475"
          />
          <path
            d="M344.83 1271.31C345.3 1270.99 345.78 1270.68 346.27 1270.38C347.17 1269.84 348.11 1269.34 349.08 1268.9C349.47 1268.72 349.93 1268.9 350.1 1269.29C350.26 1269.67 350.1 1270.1 349.72 1270.27C348.81 1270.69 347.91 1271.16 347.06 1271.68C346.6 1271.96 346.14 1272.25 345.69 1272.56C345.35 1272.79 344.89 1272.71 344.65 1272.38C344.4 1272.03 344.48 1271.55 344.83 1271.3V1271.31Z"
            fill="#4E5475"
          />
          <path
            d="M350.49 1272.57C350.9 1272.27 351.35 1272 351.81 1271.79C352.22 1271.6 352.71 1271.79 352.86 1272.23C352.98 1272.59 352.82 1273 352.47 1273.16C352.09 1273.34 351.72 1273.55 351.38 1273.8C351.07 1274.03 350.78 1274.28 350.52 1274.56C350.25 1274.85 349.81 1274.89 349.5 1274.66C349.14 1274.38 349.1 1273.86 349.41 1273.53C349.74 1273.18 350.1 1272.86 350.49 1272.58V1272.57Z"
            fill="#4E5475"
          />
          <path
            d="M353.7 1274.64C353.94 1274.47 354.18 1274.31 354.42 1274.16C354.79 1273.93 355.27 1274.06 355.48 1274.44C355.67 1274.8 355.56 1275.24 355.22 1275.45C355 1275.59 354.79 1275.73 354.58 1275.88C354.34 1276.05 354.1 1276.24 353.86 1276.43C353.55 1276.69 353.09 1276.66 352.82 1276.36C352.53 1276.04 352.56 1275.54 352.89 1275.26C353.15 1275.04 353.42 1274.84 353.7 1274.64Z"
            fill="#4E5475"
          />
          <path
            d="M358.38 1276.52C358.55 1276.43 358.72 1276.36 358.89 1276.31C359.39 1276.16 359.89 1276.56 359.86 1277.08C359.84 1277.39 359.64 1277.67 359.34 1277.76C359.25 1277.79 359.16 1277.82 359.07 1277.87C358.78 1278.02 358.58 1278.24 358.43 1278.46C358.23 1278.75 357.87 1278.88 357.54 1278.76C357.08 1278.59 356.89 1278.03 357.17 1277.63C357.43 1277.24 357.82 1276.81 358.38 1276.53V1276.52Z"
            fill="#4E5475"
          />
          <path
            d="M311.89 1271.89C312.93 1267.82 313.16 1265.33 313.9 1265.2C315.05 1265 316.94 1264.88 319.22 1264.8C318.46 1267.34 317.7 1271.75 319.59 1276.42C320.14 1277.78 321.65 1280.62 324.59 1283.15C330.78 1288.47 348.15 1290.1 352.47 1290.5C366.38 1291.79 381.23 1290.24 388.9 1289.21C389.51 1291.16 389.64 1293.38 388.65 1295.03C387.39 1297.14 384.71 1297.67 379.62 1298.12C367.79 1299.18 357.91 1298.49 354.37 1298.23C345.42 1297.57 346.08 1297.39 341.49 1297.23C330.5 1296.85 324.19 1297.07 324.19 1297.07C322.78 1297.12 317.8 1297.31 311.85 1295.72C309.02 1294.96 308.39 1294.45 307.98 1293.92C306.31 1291.74 308.26 1289.07 310.23 1279.82C310.93 1276.53 310.99 1275.43 311.89 1271.89Z"
            fill="#EDEFF4"
          />
          <path
            d="M329.91 1289.36C336.89 1290.22 336.4 1290.5 342.43 1291.24C343.25 1291.34 351.25 1292.31 360.25 1292.47C371.03 1292.66 381.02 1291.64 389.19 1290.36C389.51 1292 389.45 1293.7 388.65 1295.04C387.39 1297.15 384.71 1297.68 379.62 1298.13C367.79 1299.19 357.91 1298.5 354.37 1298.24C345.42 1297.58 346.08 1297.4 341.49 1297.24C330.5 1296.86 324.19 1297.08 324.19 1297.08C322.78 1297.13 317.8 1297.32 311.85 1295.73C309.02 1294.97 308.39 1294.46 307.98 1293.93C306.81 1292.4 307.42 1290.63 308.57 1286.52C314.14 1287.32 324.44 1288.7 329.92 1289.37L329.91 1289.36Z"
            fill="#88BDE5"
          />
          <path
            d="M83.83 1122.49H198.26C200.618 1122.49 202.53 1120.58 202.53 1118.22V1107.21C202.53 1104.85 200.618 1102.94 198.26 1102.94H83.83C81.4717 1102.94 79.56 1104.85 79.56 1107.21V1118.22C79.56 1120.58 81.4717 1122.49 83.83 1122.49Z"
            fill="#3D5586"
          />
          <path
            d="M86.58 1118.67L88.5 1118.41C91.45 1118 93.51 1115.29 93.1 1112.34L68.22 931.849C67.81 928.899 65.1 926.839 62.15 927.249L60.23 927.509C57.28 927.919 55.22 930.629 55.63 933.579L80.51 1114.07C80.92 1117.02 83.63 1119.08 86.58 1118.67Z"
            fill="#3D5586"
          />
          <path
            d="M533.85 1299.87L544.33 1298.54L513.87 1012.16L492.18 1014.9L533.85 1299.87Z"
            fill="#676791"
          />
          <path
            d="M513.87 1012.16L516.06 1032.73L502.81 1034.4L538.09 1299.33L533.85 1299.87L492.18 1014.9L513.87 1012.16Z"
            fill="#55557F"
          />
          <path
            d="M261.83 1299.87L251.36 1298.54L281.81 1012.16L303.5 1014.9L261.83 1299.87Z"
            fill="#676791"
          />
          <path
            d="M281.81 1012.16L279.62 1032.73L292.87 1034.4L257.59 1299.33L261.83 1299.87L303.5 1014.9L281.81 1012.16Z"
            fill="#55557F"
          />
          <path
            d="M599.59 1005.47H195.87V1020.54H599.59V1005.47Z"
            fill="#7E7EA3"
          />
          <path
            d="M222.12 857.659C203.34 867.429 197.8 883.369 191.1 883.219C179.26 882.949 172.41 866.309 170.6 861.919C169.35 858.899 166.76 852.599 169.4 849.669C171.16 847.719 173.96 848.659 177.79 848.469C191.1 847.799 195.81 834.449 202.95 836.619C206.82 837.799 205.18 841.639 212.27 848.339C217.73 853.499 225.02 856.149 222.12 857.659Z"
            fill="#EB8E6C"
          />
          <path
            d="M203.34 836.76C203.21 836.71 203.09 836.66 202.95 836.62C201.6 836.21 200.34 836.35 199.09 836.86C200.08 842.84 203.58 852.71 210.72 860.89C211.54 861.83 212.35 862.68 213.14 863.45C215.3 861.76 217.7 860.12 220.39 858.6C211.5 850.27 206.41 841.95 203.35 836.76H203.34Z"
            fill="#DB765E"
          />
          <path
            d="M301.06 996.86C302.18 997.2 303.17 997.09 304.31 997.58C304.79 997.79 305.03 997.94 305.81 998.25C306.7 998.6 306.98 998.62 307.77 998.98C308.7 999.4 308.56 999.47 308.97 999.56C309.94 999.79 310.37 999.32 311.22 999.63C311.43 999.71 311.66 999.89 312.13 1000.25C313.22 1001.1 313.19 1001.34 313.87 1001.76C314.14 1001.92 314.78 1002.32 315.65 1002.39C316.08 1002.43 316.31 1002.36 316.9 1002.47C317.33 1002.55 317.41 1002.62 317.89 1002.71C318.36 1002.8 318.73 1002.87 319.15 1002.83C319.47 1002.8 320.27 1002.72 320.71 1002.08C321.08 1001.53 320.97 1000.89 320.94 1000.68C320.94 1000.68 320.85 1000.16 320.52 999.7C318.09 996.34 312.86 994.27 312.86 994.27C306.49 991.74 303.26 990.49 301.43 990.97C297.98 991.86 295.24 993.96 295.69 994.98C295.83 995.29 297.77 995.86 301.07 996.86H301.06Z"
            fill="#DB765E"
          />
          <path
            d="M301.19 994.749C302.18 994.899 303.14 995.149 304.07 995.489C305.17 995.889 306.02 996.359 306.34 996.539C306.64 996.709 306.82 996.829 307.01 996.949C307.24 997.099 307.49 997.259 307.97 997.529C308.28 997.699 308.51 997.819 308.71 997.919C308.99 998.059 309.2 998.169 309.51 998.369C309.93 998.639 310.33 998.949 310.7 999.279C310.76 999.339 310.86 999.329 310.92 999.279C310.98 999.219 310.98 999.119 310.92 999.059C310.54 998.709 310.13 998.389 309.69 998.109C309.37 997.899 309.15 997.789 308.86 997.639C308.66 997.539 308.44 997.419 308.13 997.249C307.65 996.979 307.41 996.829 307.19 996.679C307 996.549 306.82 996.439 306.51 996.259C306.19 996.079 305.32 995.599 304.2 995.189C303.26 994.839 302.27 994.589 301.26 994.439C301.18 994.429 301.1 994.489 301.08 994.569C301.07 994.649 301.13 994.729 301.21 994.739L301.19 994.749Z"
            fill="#D36C57"
          />
          <path
            d="M206.69 996.889C207.52 997.059 238.49 1000.23 248.4 1001.25C255.09 1001.94 255.06 1001.56 259.73 1002.24C264.17 1002.88 266.39 1003.2 267.65 1003.59C268.08 1003.72 269.39 1004.15 271.2 1004.32C271.2 1004.32 272.43 1004.44 273.54 1004.38C276.58 1004.22 279.3 1002.36 279.92 1001.93C284.83 998.589 288.26 996.259 292.18 994.679C297.25 992.629 301.15 992.629 303.12 993.479C304.97 994.279 305.92 994.869 305.92 994.869C307.22 995.689 307.51 996.129 308.67 996.549C309.4 996.809 309.72 996.789 310.34 997.159C311.02 997.569 311.08 997.859 311.83 998.539C312.59 999.229 312.66 999.059 314.09 1000.1C315.42 1001.07 315.4 1001.24 316.05 1001.51C316.45 1001.68 317.41 1002.07 318.51 1001.74C318.73 1001.67 319.97 1001.29 320.19 1000.39C320.36 999.679 319.76 999.159 318.68 997.519C317.72 996.059 317.88 995.989 317.22 995.009C316.66 994.179 316.32 993.899 312.83 990.849C311.13 989.359 310.42 988.729 309.24 987.789C308.22 986.969 307.7 986.549 307.16 986.209C306.82 985.989 305.83 985.379 302.89 984.269C301.06 983.579 301.17 983.709 299.46 983.049C297.7 982.369 296.82 982.039 295.69 981.409C293.64 980.279 292.96 979.819 292.96 979.819C292.18 979.289 291.78 978.949 291.06 978.859C290.46 978.789 289.93 978.919 289.23 979.109C288.93 979.189 288.41 979.339 287.63 979.699C286.56 980.189 285.81 980.689 285.63 980.809C284.81 981.359 283.57 981.969 281.1 983.189C278.89 984.289 277.3 984.949 274.5 986.129C273.92 986.369 272.24 987.079 270.15 987.739C269.57 987.929 268.73 988.179 267.62 988.359C267.06 988.449 266.35 988.559 265.5 988.549C264.36 988.529 263.54 988.299 262.73 988.079C259.8 987.279 258.33 986.879 257.22 986.679C255.71 986.409 255.58 986.519 253.51 986.159C253.31 986.129 252.04 985.899 250.53 985.539C246.95 984.679 242.71 983.229 239.64 982.259C234.67 980.689 213.15 975.809 210.58 977.179C206.1 979.579 193.33 994.069 206.64 996.859L206.69 996.889Z"
            fill="#E28366"
          />
          <path
            d="M288.36 981.579C289.81 981.279 290.66 981.229 291.57 981.389C292.11 981.489 292.57 981.649 293.93 982.309C295.99 983.319 296.59 983.769 297.75 984.339C298.97 984.949 298.98 984.789 302 985.879C304.83 986.899 306.24 987.419 307.14 987.979C308.8 989.039 308.74 989.549 311.16 991.479C312.75 992.749 313.93 993.439 314.59 993.879C315.68 994.589 317.02 995.649 318.56 997.319C317.75 996.059 317.86 995.939 317.23 995.009C316.67 994.179 316.33 993.899 312.84 990.849C311.14 989.359 310.43 988.729 309.25 987.789C308.23 986.969 307.71 986.549 307.17 986.209C306.83 985.989 305.84 985.379 302.9 984.269C301.07 983.579 301.18 983.709 299.47 983.049C297.71 982.369 296.83 982.039 295.7 981.409C293.65 980.279 292.97 979.819 292.97 979.819C292.19 979.289 291.79 978.949 291.07 978.859C290.47 978.789 289.94 978.919 289.24 979.109C288.94 979.189 288.42 979.339 287.64 979.699C286.57 980.189 285.82 980.689 285.64 980.809C284.82 981.359 283.58 981.969 281.11 983.189C279.25 984.109 277.83 984.729 275.76 985.609C280.09 984.279 282.65 983.379 284.21 982.739C284.21 982.739 285.81 982.079 288.34 981.559L288.36 981.579Z"
            fill="#E59477"
          />
          <path
            d="M281.11 993.76C295.06 989 297.16 989.88 298.06 990.78C298.45 991.17 298.87 991.83 299 992.98C300.77 992.86 302.18 993.07 303.13 993.48C303.89 993.81 304.49 994.1 304.94 994.33C305.29 994.04 305.71 993.62 306.08 993.05C306.34 992.64 306.8 991.92 306.85 990.96C306.96 989.06 305.41 987.74 305.28 987.63C304.32 986.84 303.31 986.74 301.47 986.59C300.28 986.49 298.6 986.37 296.4 986.84C293.61 987.44 291.31 988.72 290.32 989.28C289.13 989.95 288.59 990.39 287.41 990.73C285.66 991.23 284.21 991.02 283.77 990.97C279.03 990.47 271.13 996.45 271.48 997.11C271.65 997.43 273.7 996.28 281.1 993.76H281.11Z"
            fill="#D36C57"
          />
          <path
            d="M273.2 1005.15C274.61 1005.48 275.81 1005.38 276.64 1005.31C277.77 1005.21 278.53 1005 279.9 1004.62C281.96 1004.05 283.09 1003.74 284.46 1002.95C285.43 1002.39 286.28 1001.73 287.18 1001.03C288.21 1000.23 288.31 1000.06 289.09 999.529C289.68 999.129 290.58 998.519 291.87 998.029C292.68 997.719 293.31 997.589 294.21 997.399C295.47 997.139 295.77 997.169 296.83 996.979C298.69 996.659 300.03 996.159 301.79 995.499C302.17 995.359 302.95 995.059 303.9 994.529C304.6 994.139 304.96 993.929 305.32 993.529C305.97 992.799 306.17 991.949 306.22 991.479C306.25 991.219 306.44 989.709 305.46 988.599C304.81 987.869 303.98 987.689 302.82 987.459C301.43 987.189 300.36 987.279 299.08 987.409C297.85 987.529 296.38 987.669 294.6 988.329C293.51 988.729 293.74 988.799 291.39 989.879C288.72 991.109 287.89 991.279 287.48 991.339C286.17 991.549 285.5 991.339 284.36 991.259C281.92 991.119 280.09 991.829 277.37 992.889C274.1 994.159 272.47 994.799 271.08 996.479C269.83 997.979 268.16 1001.02 269.36 1003.06C270.17 1004.44 272.03 1004.88 273.19 1005.15H273.2Z"
            fill="#E28366"
          />
          <path
            d="M301.33 993.92C302.22 994.6 303.8 994.34 304.76 993.5C305.93 992.47 306.09 990.62 305.33 989.4C305.23 989.25 304.59 988.25 303.41 988.08C302.46 987.94 301.7 988.42 301.26 988.7C300.86 988.95 300.55 989.15 300.34 989.53C299.94 990.24 300.18 991.04 300.47 992.04C300.78 993.07 300.93 993.59 301.34 993.91L301.33 993.92Z"
            fill="#FFDBB6"
          />
          <path
            d="M301.25 993.859C301.43 993.559 301.62 993.129 301.63 992.619C301.67 991.629 301.09 990.659 300.14 990.049C300.03 990.629 300.23 991.279 300.45 992.049C300.74 993.019 300.89 993.529 301.25 993.859Z"
            fill="#FFEBD9"
          />
          <path
            d="M304.99 991.079C305.16 992.309 304.66 993.289 304.29 993.839C304.46 993.739 304.61 993.629 304.76 993.499C305.93 992.469 306.09 990.619 305.33 989.399C305.23 989.249 304.59 988.249 303.41 988.079C303.2 988.049 302.99 988.049 302.8 988.079C303.99 988.679 304.83 989.799 305 991.079H304.99Z"
            fill="#FFEBD9"
          />
          <path
            d="M225.45 787.159C228.86 787.919 232.3 790.139 235.44 792.149C236.92 793.099 238.3 794.139 239.68 795.529C239.74 795.589 240.76 796.619 241.63 797.749C244.57 801.559 245.6 806.299 246.02 808.329C246.79 812.039 247.33 814.629 246.62 817.919C246.16 820.049 245.31 821.809 245.42 824.909C245.45 825.819 245.51 827.119 246.02 828.699C247.1 832.049 249.57 834.629 250.41 835.489C251.76 836.879 252.67 837.429 252.81 838.689C252.98 840.199 251.9 841.389 251.81 841.489C250.47 842.919 248.21 842.899 247.22 842.889C245.75 842.869 245.29 842.509 244.62 842.889C243.79 843.369 243.7 844.419 243.42 846.089C243.42 846.089 242.65 850.649 241.02 854.879C240.53 856.159 240.5 855.979 240.02 857.279C238.75 860.719 239.02 861.799 238.22 862.869C236.73 864.859 233.19 864.579 231.83 864.469C222.1 863.699 212.06 853.879 210.46 852.289C200.8 842.669 195.97 837.859 194.08 830.519C190.1 814.989 199.1 798.269 210.46 791.179C213.29 789.409 219.12 785.769 225.44 787.189L225.45 787.159Z"
            fill="#EB8E6C"
          />
          <path
            d="M215.62 935.141C215.46 932.111 214.67 929.09 213.08 923.16C210.85 914.8 210.26 914.16 209.42 909.581C208.74 905.881 203.23 880.621 201.41 878.591C199.53 876.491 195.95 873.04 193.36 870.7C190.56 868.18 190.06 867.19 184.62 861.38C180.5 856.98 179.79 856.47 178.7 856.05C176.48 855.21 174.23 855.77 168.55 856.85C167.27 857.09 161.2 858.3 154.17 862.18C151.48 863.66 142.26 868.88 135.57 879.22C131.5 885.51 129.66 893.36 125.99 909.04C125.18 912.52 124.47 915.91 123.74 919.42C121.17 931.73 121.3 932.92 119.79 939.66C118.55 945.24 116.82 952.841 113.31 962.031C111.21 967.521 95.18 1020.64 92.09 1031.39C99.73 1036.2 172.44 1040.2 186.43 1040.16C187.36 1031.27 187.82 990.68 190.55 979.88C192.31 972.92 193.7 967.7 198.44 963.37C201.91 960.2 203.94 960.47 208.02 956.18C209.53 954.59 212.73 951.17 214.5 945.8C215.93 941.48 215.77 937.911 215.63 935.151L215.62 935.141Z"
            fill="#FFC639"
          />
          <path
            d="M240.35 790.28C236.68 787.25 233.19 786 227.36 783.97C221.98 782.1 217.52 781.12 214.73 780.6C208.67 779.46 205.2 778.81 200.72 779.2C198.59 779.38 191.59 780.21 184.75 784.86C177.16 790.03 174.11 796.97 170.57 805C166.37 814.54 165.24 822.71 164.71 826.83C163.45 836.49 163.94 845.03 163.94 845.03C164.38 852.71 165.47 854.58 164.42 858.73C162.82 865.05 159.19 865.08 154.74 871.89C152.43 875.42 150.88 879.29 149.86 883.11C153.03 884.05 156.2 884.98 159.37 885.89C161.96 881.46 164.53 878.6 165.38 877.68C174 868.35 178.51 871.47 183.27 864.11C186.17 859.63 187.35 852.15 189.72 837.18C190.48 832.39 190.89 828.84 193.83 826.63C197.16 824.13 203.15 823.76 206.49 826.41C208.33 827.87 208.52 829.59 209.82 829.62C211.57 829.66 220.65 800.6 245.15 801.86C247.12 801.96 243.67 793.03 240.34 790.28H240.35Z"
            fill="#100C5B"
          />
          <path
            d="M168.79 1014.83C168.45 1016.03 166.43 1038.3 166.1 1039.45C171.74 1039.33 180.77 1040.18 186.41 1040.16C187.17 1032.98 187.01 997.44 189.02 986.83C180.93 975.25 171.99 961.42 162.95 945.43C151.2 924.66 145.66 911.53 144 912.19C140.86 913.44 169.95 986.91 171.26 991.65C172.91 997.63 172.52 1001.62 168.79 1014.83Z"
            fill="#FCB81F"
          />
          <path
            d="M239.66 791.48C242.69 790.87 247.07 794.34 248.71 797.67C251.67 803.7 247.86 808.34 247.13 809.33C243.48 814.22 237.12 812.29 232.45 815.46C221.99 822.55 221.48 838.61 221.48 838.61C221.48 838.61 216.32 813.83 234.63 798.48C236.98 796.51 236.97 792.03 239.67 791.48H239.66Z"
            fill="#100C5B"
          />
          <path
            d="M214 813.979C219.24 820.559 219.73 841.679 218.41 846.149C215.56 855.799 204.88 860.079 204.56 859.669C204.29 859.329 211.45 856.129 214.3 848.319C216.92 841.149 214.57 833.749 213.79 831.289C210.95 822.369 205.55 818.349 207.21 816.029C208.18 814.679 212.73 812.379 214 813.979Z"
            fill="#100C5B"
          />
          <path
            d="M183.16 980.989C182.66 982.819 184.24 985.249 187.42 990.039C191.94 996.849 195.3 1001.75 201 1003.09C201.93 1003.31 204.08 1003.78 206.59 1003.09C209.11 1002.39 210.72 1000.86 212.45 999.099C217.05 994.389 220.16 990.329 220.17 990.309C223.98 985.339 225.55 984.389 229.76 979.659C234.19 974.669 237.54 969.539 244.4 959.419C250.5 950.419 250.36 950.119 253.45 946.109C259.54 938.209 261.14 938.039 263.83 933.599C264.13 933.099 264.74 932.059 265.96 931.199C268.25 929.579 270.86 929.899 273.95 930.129C278.74 930.489 283.02 930.499 285.67 930.399C287.94 930.309 291.35 930.149 295.52 929.069C299.67 927.989 299.38 927.349 304.31 925.869C306.18 925.309 310.12 924.239 315.23 923.739C318.64 923.409 321.11 923.889 321.69 922.739C322.16 921.809 321.08 921.209 321.62 920.409C322.34 919.369 325.55 920.859 326.01 920.009C326.31 919.459 326.03 916.419 321.42 915.949C313.08 915.109 306.03 917.049 305.91 916.819C305.79 916.599 307.92 914.899 310.84 913.759C314.04 912.509 317.1 912.029 317.1 912.029C318.95 911.739 320.22 911.729 320.69 910.829C321.03 910.179 320.85 909.279 320.42 908.699C320.05 908.199 319.18 907.499 315.63 907.769C314.49 907.859 310.97 908.209 305.25 910.429C303.79 910.999 303.21 911.289 301.92 911.629C299.78 912.189 298.15 912.229 296.33 912.299C296.33 912.299 295.84 912.319 288.87 912.699C281.89 913.079 279.22 913.749 279.02 913.099C278.84 912.519 280.72 911.309 282.35 910.699C283.74 910.179 284.28 910.329 287.14 910.029C287.76 909.969 289.77 909.589 293.8 908.829C295.26 908.559 296 908.409 296.73 907.759C297.76 906.849 298.48 905.199 297.93 904.299C297.38 903.409 295.78 903.529 294.2 903.629C290.96 903.839 287.68 903.499 284.48 904.029C271.42 906.199 270.24 904.449 265.84 906.959C263.65 908.209 261.91 910.209 258.52 914.149C252.88 920.719 250.19 925.029 247.34 928.929C243 934.859 243.25 933.039 226.57 950.499C219.22 958.189 218.08 959.689 214.19 962.879C210.48 965.929 206.01 969.599 199.41 972.869C189.66 977.699 184.2 977.239 183.17 980.989H183.16Z"
            fill="#EB8E6C"
          />
          <path
            d="M182.04 990.72C182.04 990.72 175.28 984.63 168.76 968.04C165.21 959 161.42 952.17 154.53 938.23C144.99 918.92 142.8 919.64 141.51 912.67C141.05 910.2 138.17 893.151 149.08 878.901C151.41 875.861 154.38 871.72 159.98 869.16C161.03 868.68 164.28 867.291 168.76 867.031C169.18 867.011 176.97 866.641 182.99 870.381C187.34 873.081 190.27 877.61 193.89 891.68C197.61 906.13 196.36 908.511 200.25 929.401C202.86 943.401 204.16 950.401 205.7 954.961C207.79 961.151 210.02 963.19 210 966.23C209.91 977.09 185.46 992.71 182.05 990.72H182.04Z"
            fill="#FFD147"
          />
          <path
            d="M181.17 971.539C176.22 961.039 170.91 950.699 166.3 940.049C160.24 926.059 158.6 926.119 154.05 915.779C150.89 908.579 147.31 898.599 144.98 885.609C139.01 898.059 141.13 910.589 141.52 912.679C142.81 919.649 145 918.929 154.54 938.239C161.43 952.189 165.22 959.019 168.77 968.049C175.29 984.639 182.05 990.729 182.05 990.729C183.56 991.609 189.16 989.049 194.96 984.989C193.85 984.659 192.66 984.209 191.45 983.569C185.44 980.399 182.71 974.809 181.17 971.539Z"
            fill="#FFC639"
          />
          <path
            d="M202.75 834.19C202.29 832.39 184.58 824.84 179.64 831.97C178.89 833.05 178.51 834.07 177.76 840.43C177.63 841.5 177.52 842.5 177.42 843.46C170.83 837.71 167.33 814.51 167.33 814.51C167.33 814.51 160.55 843.56 157.12 848.24C155.05 851.07 152.79 850.98 147.78 853.65C147.05 854.04 140.11 857.81 135 863.97C129.98 870.02 128.39 876.56 127.63 879.69C125.95 886.59 127.34 888.22 125.42 894.43C123.57 900.42 120.85 903.5 119.03 906.47C109.65 921.78 117.6 944.63 119.03 944.55C120.02 944.5 117.29 933.38 123.94 922.44C125.19 920.39 128.9 914.45 135.98 910.89C142.46 907.63 144.5 910.02 150.97 906.47C152.49 905.63 159.14 901.98 162.27 894.68C164.43 889.64 162.62 888.21 164.57 884.87C168.35 879.98 171.7 880.58 176.49 878.74C183.4 876.1 185.19 876.76 188.35 874.05C192.28 870.68 193.48 866.24 193.77 865.06C194.91 860.31 192.93 856.42 192.83 853.54C192.41 841.19 203.04 835.28 202.76 834.19H202.75Z"
            fill="#100C5B"
          />
          <path
            d="M218.32 822.26C219.36 832.63 213.14 841.75 204.41 842.63C195.68 843.51 187.77 835.81 186.72 825.44C185.68 815.07 191.9 805.95 200.63 805.07C209.35 804.19 217.27 811.89 218.32 822.26Z"
            fill="#A8B4EF"
          />
          <path
            d="M222.78 823.039C223.38 836.379 213.52 845.709 201.06 842.529C194.07 840.749 190.05 837.099 188.95 826.129C187.85 815.159 194.69 805.489 204.24 804.529C213.79 803.569 222.29 812.029 222.79 823.049L222.78 823.039Z"
            fill="#CFD8F9"
          />
          <path
            d="M218.32 822.26C219.36 832.63 213.14 841.75 204.41 842.63C195.68 843.51 187.77 835.81 186.72 825.44C185.68 815.07 191.9 805.95 200.63 805.07C209.35 804.19 217.27 811.89 218.32 822.26Z"
            fill="#A8B4EF"
          />
          <path
            d="M201.41 830.599C198.47 830.599 196.07 828.189 196.07 825.259V787.809C196.07 787.339 196.45 786.959 196.92 786.959H205.91C206.38 786.959 206.76 787.339 206.76 787.809V825.259C206.76 828.199 204.35 830.599 201.42 830.599H201.41Z"
            fill="#E1EAFF"
          />
          <path
            d="M200.53 830.599C197.59 830.599 195.19 828.189 195.19 825.259V787.809C195.19 787.339 195.57 786.959 196.04 786.959H205.03C205.5 786.959 205.88 787.339 205.88 787.809V825.259C205.88 828.199 203.47 830.599 200.54 830.599H200.53Z"
            fill="#BBCAF9"
          />
          <path
            d="M195.86 792.149C195.33 792.149 194.93 791.689 195 791.159C195.35 788.519 196.84 780.289 200.57 779.069C200.91 778.959 213.66 778.919 213.9 779.069C214.19 779.239 214.34 780.079 213.92 780.279C213.07 780.689 212.24 781.379 211.13 782.659C209.58 784.439 208.91 789.129 208.78 791.079C208.75 791.539 208.2 792.149 207.74 792.149H195.86Z"
            fill="#CFD8F9"
          />
          <path
            d="M194.11 792.15C193.58 792.15 193.18 791.689 193.25 791.159C193.6 788.519 195.3 779.86 199.03 778.64C199.36 778.53 214.5 778.71 213.9 779.07C212.66 779.81 211.16 780.609 209.37 782.659C207.82 784.439 207.34 789.38 207.22 791.34C207.19 791.8 206.81 792.15 206.35 792.15H194.11Z"
            fill="#A8B4EF"
          />
          <path
            d="M599.59 1005.47H594.07C593.18 1007.34 592.01 1009.08 590.47 1010.52C586.76 1014 582.39 1014.41 580.86 1014.55C573.49 1015.23 491.31 1017.5 367.27 1020.54H599.59V1005.47Z"
            fill="#676791"
          />
          <path
            d="M239.06 824.189C239.93 824.359 240.36 825.889 240.03 827.609C239.7 829.329 238.71 830.569 237.84 830.399C236.97 830.229 236.54 828.699 236.87 826.979C237.21 825.269 238.19 824.019 239.06 824.189Z"
            fill="#543434"
          />
          <path
            d="M243.2 846.819C243.65 846.749 242.64 849.149 242.17 850.149C242.01 850.489 241.66 850.659 241.29 850.619C237.48 850.229 234.44 844.359 234.98 843.859C235.33 843.539 240.05 847.279 243.2 846.819Z"
            fill="#D8745D"
          />
          <path
            d="M236.01 819.179C237.28 819.049 238.58 819.129 239.82 819.419C241.57 819.829 242.94 820.6 243.94 821.33C244.42 821.68 244.49 822.37 244.09 822.82L244.05 822.859C243.7 823.249 243.12 823.31 242.7 823C241.88 822.4 240.76 821.78 239.33 821.44C238.31 821.2 237.25 821.129 236.2 821.239C235.68 821.289 235.22 820.929 235.11 820.419V820.38C234.98 819.79 235.4 819.229 236 819.169L236.01 819.179Z"
            fill="#442138"
          />
          <path
            d="M452.92 1005.69C456.86 1005.69 462.52 1005.16 466.98 1001.04C471.31 997.051 472.71 991.271 473.11 988.971C473.79 985.061 473.28 981.951 473.11 980.931C471.55 971.381 462.32 951.261 454.91 935.101C452.05 928.871 449.49 923.281 447.81 919.281C447.06 917.491 445.03 916.611 443.2 917.281C441.25 918.001 440.29 920.191 441.09 922.101C442.83 926.251 445.41 931.871 448.28 938.141C455.13 953.071 464.51 973.531 465.92 982.111C466.04 982.831 466.4 985.031 465.92 987.731C465.77 988.601 464.87 993.081 462.03 995.701C458.89 998.601 453.99 998.461 451.06 998.381H450.94C440.66 998.091 427.56 998.171 411.64 998.341C409.63 998.361 408.01 1000.01 408.03 1002.02C408.05 1004.03 409.7 1005.65 411.72 1005.62C427.55 1005.45 440.58 1005.37 450.74 1005.66H450.86C451.47 1005.68 452.16 1005.7 452.92 1005.7V1005.69Z"
            fill="#041649"
          />
          <path
            d="M410.04 981.86L413.49 980.82C418.89 979.2 423.29 975.27 425.51 970.08L475.33 853.63C477.4 848.79 477.37 843.31 475.26 838.5L473.34 834.12C472.67 832.6 470.51 832.61 469.86 834.14L407.77 979.29C407.14 980.77 408.52 982.32 410.06 981.86H410.04Z"
            fill="#0D266D"
          />
          <path
            d="M407.74 979.29L412.28 968.67L414.77 967.92C420.17 966.3 424.57 962.37 426.79 957.18L476.27 841.51C477.28 845.52 476.96 849.77 475.31 853.62L425.49 970.07C423.27 975.25 418.87 979.18 413.47 980.81L410.02 981.85C408.48 982.31 407.09 980.77 407.73 979.28L407.74 979.29Z"
            fill="#061F56"
          />
          <path
            d="M368.53 1005.43H295.29C293.8 1005.43 292.6 1004.23 292.6 1002.74C292.6 1001.25 293.8 1000.05 295.29 1000.05H368.53C370.02 1000.05 371.22 1001.25 371.22 1002.74C371.22 1004.23 370.02 1005.43 368.53 1005.43Z"
            fill="#041649"
          />
          <path
            d="M295.89 732.87C292.07 732.87 288.71 732.41 285.54 731.5L293.88 691C285.79 680.43 280.98 667.22 280.98 652.88C280.98 618.2 309.09 590.08 343.78 590.08H429.47C464.15 590.08 492.27 618.19 492.27 652.88C492.27 687.56 464.16 715.68 429.47 715.68H389.5C389.63 713.28 389.64 710.88 389.64 708.48C389.64 710.88 389.64 713.28 389.5 715.68H343.79C339.5 715.68 335.3 715.25 331.25 714.42L286.27 751.1L280.57 755.75L285.56 731.5C288.74 732.41 292.1 732.87 295.91 732.87H295.89Z"
            fill={theme.palette.primary.light}
          />
          <path
            d="M347.33 644.01C354.02 644.01 359.44 649.43 359.44 656.12C359.44 662.81 354.02 668.23 347.33 668.23C340.64 668.23 335.22 662.81 335.22 656.12C335.22 649.43 340.64 644.01 347.33 644.01Z"
            fill="white"
          />
          <path
            d="M424.05 644.01C430.74 644.01 436.16 649.43 436.16 656.12C436.16 662.81 430.74 668.23 424.05 668.23C417.36 668.23 411.94 662.81 411.94 656.12C411.94 649.43 417.36 644.01 424.05 644.01Z"
            fill="white"
          />
          <path
            d="M397.468 658.873C399.004 652.364 394.973 645.841 388.463 644.305C381.954 642.769 375.432 646.8 373.895 653.31C372.359 659.819 376.39 666.341 382.9 667.877C389.409 669.414 395.931 665.382 397.468 658.873Z"
            fill="white"
          />
          <path
            d="M1552.31 75.8809H1325.86C1308.95 75.8809 1295.24 89.5899 1295.24 106.501V186.111C1295.24 203.022 1308.95 216.731 1325.86 216.731H1552.31C1569.22 216.731 1582.93 203.022 1582.93 186.111V106.501C1582.93 89.5899 1569.22 75.8809 1552.31 75.8809Z"
            fill={theme.palette.primary.main}
          />
          <path
            d="M1383.12 173.511H1358.47C1359.19 172.281 1359.91 171.201 1360.6 170.301C1362.38 167.821 1365.7 164.281 1370.49 159.791C1375.29 155.271 1378.76 151.921 1380.8 149.821C1382.86 147.701 1384.9 144.721 1386.87 140.991C1388.85 137.241 1389.85 133.011 1389.85 128.431C1389.85 125.511 1389.37 122.651 1388.42 119.931C1387.47 117.211 1386.12 114.781 1384.42 112.711C1382.71 110.631 1380.7 108.981 1378.44 107.791C1374.97 106.011 1370.71 105.111 1365.8 105.111C1361.72 105.111 1358.11 105.811 1355.07 107.201C1352.03 108.591 1349.48 110.441 1347.5 112.701C1345.52 114.961 1344.01 117.511 1343.01 120.291C1342.01 123.061 1341.51 125.771 1341.51 128.321C1341.51 130.471 1342.06 132.191 1343.15 133.451C1344.25 134.711 1345.65 135.351 1347.31 135.351C1349.21 135.351 1350.67 134.651 1351.66 133.261C1352.61 131.921 1353.48 129.981 1354.24 127.501C1354.98 125.061 1355.52 123.561 1355.83 123.021C1358.17 118.891 1361.43 116.791 1365.51 116.791C1367.44 116.791 1369.25 117.301 1370.88 118.301C1372.51 119.301 1373.83 120.731 1374.78 122.541C1375.73 124.361 1376.22 126.451 1376.22 128.751C1376.22 130.881 1375.77 133.091 1374.87 135.321C1373.97 137.551 1372.64 139.761 1370.92 141.891C1369.19 144.021 1367 146.171 1364.4 148.281C1362.93 149.421 1360.44 151.841 1357.03 155.461C1353.61 159.081 1349.73 163.471 1345.49 168.531C1344.46 169.791 1343.49 171.551 1342.62 173.761C1341.75 175.971 1341.31 177.771 1341.31 179.121C1341.31 181.231 1342.01 183.101 1343.39 184.661C1344.78 186.231 1346.73 187.031 1349.19 187.031H1384.53C1386.71 187.031 1388.36 186.371 1389.44 185.071C1390.51 183.781 1391.06 182.191 1391.06 180.341C1391.06 178.261 1390.37 176.581 1389.01 175.361C1387.66 174.151 1385.68 173.531 1383.14 173.531L1383.12 173.511Z"
            fill="white"
          />
          <path
            d="M1449.09 158.071C1447.57 157.281 1445.54 156.881 1443.05 156.881H1441.22V114.381C1441.22 107.851 1438.68 104.531 1433.68 104.531C1432.11 104.531 1430.75 105.141 1429.64 106.351C1428.56 107.511 1427.17 109.411 1425.51 111.991L1400.06 151.141C1399.36 152.211 1398.76 153.111 1398.28 153.851C1397.8 154.591 1397.32 155.371 1396.88 156.151C1396.42 156.951 1396.08 157.731 1395.85 158.461C1395.62 159.201 1395.5 159.941 1395.5 160.661C1395.5 163.441 1396.29 165.661 1397.85 167.291C1399.41 168.911 1401.77 169.741 1404.86 169.741H1428.73V179.771C1428.73 182.571 1429.3 184.731 1430.44 186.181C1431.59 187.651 1433.11 188.401 1434.97 188.401C1436.83 188.401 1438.4 187.671 1439.53 186.241C1440.65 184.821 1441.21 182.651 1441.21 179.771V169.741H1443.9C1446.38 169.741 1448.27 169.231 1449.52 168.221C1450.79 167.201 1451.43 165.571 1451.43 163.371C1451.43 160.671 1450.64 158.891 1449.07 158.081L1449.09 158.071ZM1428.74 125.851V156.891H1408.76L1428.74 125.851Z"
            fill="white"
          />
          <path
            d="M1474.4 104.211C1472.46 104.211 1471.12 104.891 1470.44 106.221C1469.79 107.481 1469.11 109.851 1468.4 113.241L1455 176.911C1454.35 180.341 1454.04 182.431 1454.04 183.301C1454.04 186.681 1455.77 188.401 1459.18 188.401C1460.55 188.401 1461.62 188.031 1462.35 187.311C1463.06 186.601 1463.6 185.611 1463.95 184.361C1464.28 183.151 1464.68 181.481 1465.13 179.381L1478.57 115.711C1479.24 112.691 1479.58 110.571 1479.58 109.421C1479.58 107.821 1479.13 106.541 1478.24 105.611C1477.35 104.681 1476.06 104.211 1474.4 104.211Z"
            fill="white"
          />
          <path
            d="M1534.72 108.071C1533.31 106.941 1531.01 106.361 1527.9 106.361H1495.92C1493.36 106.361 1491.34 106.741 1489.9 107.491C1488.41 108.271 1487.66 109.991 1487.66 112.621C1487.66 115.081 1488.36 116.911 1489.74 118.071C1491.1 119.221 1493.18 119.811 1495.92 119.811H1521.16C1517.24 125.561 1513.81 131.421 1510.95 137.221C1508.03 143.151 1505.56 149.011 1503.62 154.641C1501.67 160.271 1500.25 165.181 1499.39 169.221C1498.53 173.271 1498.09 176.521 1498.09 178.881C1498.09 181.971 1498.7 184.351 1499.91 185.951C1501.14 187.571 1502.78 188.391 1504.8 188.391C1506.82 188.391 1508.63 187.631 1509.9 186.121C1511.15 184.641 1512.13 181.971 1512.81 178.191C1513.1 176.571 1513.44 174.211 1513.82 171.161C1514.2 168.121 1514.56 165.611 1514.88 163.711C1515.2 161.821 1515.74 159.391 1516.51 156.501C1518.32 149.961 1520.34 144.341 1522.52 139.811C1524.7 135.281 1526.84 131.431 1528.89 128.381C1530.94 125.341 1532.79 122.501 1534.42 119.951C1536.05 117.381 1536.88 115.281 1536.88 113.691C1536.88 111.091 1536.16 109.181 1534.73 108.041L1534.72 108.071Z"
            fill="white"
          />
          <path
            d="M1557.93 76.7402C1559.37 89.3402 1559.43 104.72 1555.72 121.61C1553.03 133.89 1548.12 155.05 1530.76 173.95C1526.53 178.55 1517.32 189.09 1501.77 194.89C1469.86 206.78 1412.91 209.9 1335.96 216.73H1550.5C1568.4 216.73 1582.92 202.22 1582.92 184.31V108.29C1582.92 92.9402 1572.25 80.0902 1557.92 76.7402H1557.93Z"
            fill="#00B560"
          />
          <path
            d="M2207.12 1243.7C2203.88 1246.63 2204.32 1248.82 2199.06 1253.48C2195.81 1256.36 2192.69 1258.13 2187.34 1261.17C2183.43 1263.39 2181.42 1264.52 2178.67 1265.32C2174.04 1266.67 2169.35 1266.78 2169.35 1266.78C2165.39 1266.87 2164.28 1266.23 2162.12 1267.19C2161.68 1267.38 2158.39 1268.9 2157.59 1272.18C2156.9 1274.99 2158.43 1277.43 2159.65 1279.29C2160.54 1280.65 2163.34 1284.56 2170.39 1287.47C2174.88 1289.33 2178.37 1289.66 2184.42 1290.18C2189.75 1290.64 2196.69 1291.2 2205.4 1289.51C2211.96 1288.24 2210.72 1287.4 2216.89 1286.36C2226.36 1284.76 2236.62 1285.21 2236.62 1285.21C2242.2 1285.45 2244.49 1286.02 2245.86 1284.39C2247.5 1282.44 2245.79 1279.74 2245.89 1273.62C2245.96 1268.98 2245.38 1249.54 2240.02 1244.49C2230.81 1235.81 2214.55 1236.99 2207.15 1243.69L2207.12 1243.7Z"
            fill="#554FAA"
          />
          <path
            d="M2245.86 1273.63C2245.93 1268.99 2245.35 1249.55 2239.99 1244.5C2237.62 1242.27 2234.79 1240.69 2231.76 1239.69C2232.98 1248.09 2231.74 1255.78 2227.59 1261.12C2224.81 1264.7 2219.44 1268.88 2214.16 1271.75C2213.31 1272.21 2209.07 1274.48 2202.97 1276.23C2202.97 1276.23 2196.17 1278.17 2188.99 1278.47C2181.41 1278.78 2170.39 1276.35 2158.36 1270.33C2158.01 1270.87 2157.73 1271.49 2157.56 1272.19C2156.87 1275 2158.4 1277.44 2159.62 1279.3C2160.51 1280.66 2163.31 1284.57 2170.36 1287.48C2174.85 1289.34 2178.34 1289.67 2184.39 1290.19C2189.72 1290.65 2196.66 1291.2 2205.37 1289.52C2211.93 1288.25 2210.69 1287.41 2216.86 1286.37C2226.33 1284.77 2236.59 1285.22 2236.59 1285.22C2242.17 1285.46 2244.46 1286.03 2245.83 1284.4C2247.47 1282.45 2245.76 1279.75 2245.86 1273.63Z"
            fill="#4A429B"
          />
          <path
            d="M2233.37 1279.6C2229.98 1279.79 2226.31 1279.56 2219.87 1280.54C2216.48 1281.06 2214.9 1281.52 2208.14 1283.01C2200.02 1284.8 2195.97 1285.7 2194.4 1285.88C2186 1286.88 2179.39 1284.48 2172.05 1281.81C2168.24 1280.43 2163.13 1278.22 2157.49 1274.67C2157.79 1276.44 2158.79 1278.01 2159.63 1279.3C2160.52 1280.66 2163.32 1284.57 2170.37 1287.48C2174.86 1289.34 2178.35 1289.67 2184.4 1290.19C2189.73 1290.65 2196.67 1291.21 2205.38 1289.52C2211.94 1288.25 2210.7 1287.41 2216.87 1286.37C2226.34 1284.77 2236.6 1285.22 2236.6 1285.22C2242.18 1285.46 2244.47 1286.03 2245.84 1284.4C2247.16 1282.84 2246.32 1280.79 2245.98 1276.9C2240.94 1278.75 2236.7 1279.41 2233.37 1279.6Z"
            fill="#8888E2"
          />
          <path
            d="M2169.9 1268.71L2179.47 1267.5L2153.65 1021.72L2133.82 1024.22L2169.9 1268.71Z"
            fill="#46466B"
          />
          <path
            d="M2268.45 1272.91C2265.28 1272.46 2263.07 1269.53 2263.52 1266.36L2286.55 1102.7C2287 1099.53 2289.93 1097.32 2293.1 1097.77C2296.27 1098.22 2298.48 1101.15 2298.03 1104.32L2275 1267.98C2274.55 1271.15 2271.62 1273.36 2268.45 1272.91Z"
            fill="#0E2342"
          />
          <path
            d="M2377.38 1268.41L2355.64 1104.23C2355.22 1101.06 2357.45 1098.15 2360.62 1097.73C2363.79 1097.31 2366.71 1099.54 2367.13 1102.71L2388.87 1266.89C2389.29 1270.06 2387.06 1272.98 2383.89 1273.4C2380.72 1273.82 2377.81 1271.59 2377.39 1268.42L2377.38 1268.41Z"
            fill="#0E2342"
          />
          <path
            d="M2278.97 1204.74H2381.09V1191.72H2278.97V1204.74Z"
            fill="#152B4C"
          />
          <path
            d="M2260.23 1296.38C2257.06 1295.93 2254.85 1293 2255.3 1289.83L2278.33 1126.17C2278.78 1123 2281.71 1120.79 2284.88 1121.24C2288.05 1121.69 2290.26 1124.62 2289.81 1127.79L2266.78 1291.45C2266.33 1294.62 2263.4 1296.83 2260.23 1296.38Z"
            fill="#1E3863"
          />
          <path
            d="M2386.22 1291.88L2364.48 1127.7C2364.06 1124.53 2366.29 1121.61 2369.46 1121.19C2372.63 1120.77 2375.55 1123 2375.97 1126.17L2397.71 1290.35C2398.13 1293.52 2395.9 1296.44 2392.73 1296.86C2389.56 1297.28 2386.65 1295.05 2386.23 1291.88H2386.22Z"
            fill="#1E3863"
          />
          <path
            d="M2260.23 1296.38C2257.06 1295.93 2254.85 1293 2255.3 1289.83L2278.33 1126.17C2278.78 1123 2281.71 1120.79 2284.88 1121.24C2288.05 1121.69 2290.26 1124.62 2289.81 1127.79L2266.78 1291.45C2266.33 1294.62 2263.4 1296.83 2260.23 1296.38Z"
            fill="#1E3863"
          />
          <path
            d="M2386.22 1291.88L2364.48 1127.7C2364.06 1124.53 2366.29 1121.61 2369.46 1121.19C2372.63 1120.77 2375.55 1123 2375.97 1126.17L2397.71 1290.35C2398.13 1293.52 2395.9 1296.44 2392.73 1296.86C2389.56 1297.28 2386.65 1295.05 2386.23 1291.88H2386.22Z"
            fill="#1E3863"
          />
          <path
            d="M2293.34 1115.24H2384.28L2409.28 935.91H2322.88C2317.91 935.91 2313.73 939.63 2313.16 944.57L2293.34 1115.24Z"
            fill="#29416D"
          />
          <path
            d="M2376.16 1046.68C2373.58 1022.01 2370.44 992.02 2347.77 964.98C2337.37 952.58 2325.78 944.27 2316.01 938.75C2314.47 940.27 2313.42 942.29 2313.16 944.58L2293.34 1115.25H2372.81C2376.76 1095.59 2378.85 1072.36 2376.16 1046.68Z"
            fill="#1E3863"
          />
          <path
            d="M2270.82 1106.51H2381.66C2384.07 1106.51 2386.03 1108.47 2386.03 1110.88V1121.16C2386.03 1123.57 2384.07 1125.53 2381.66 1125.53H2270.82C2268.41 1125.53 2266.45 1123.57 2266.45 1121.16V1110.88C2266.45 1108.47 2268.41 1106.51 2270.82 1106.51Z"
            fill="#3D5586"
          />
          <path
            d="M2379.2 1121.8L2377.33 1121.54C2374.46 1121.14 2372.46 1118.5 2372.86 1115.64L2397.05 940.13C2397.45 937.26 2400.09 935.26 2402.95 935.66L2404.82 935.92C2407.69 936.32 2409.69 938.96 2409.29 941.82L2385.1 1117.33C2384.7 1120.2 2382.06 1122.2 2379.2 1121.8Z"
            fill="#3D5586"
          />
          <path
            d="M2198.22 1249.83C2194.98 1252.76 2195.42 1254.95 2190.16 1259.61C2186.9 1262.49 2183.79 1264.26 2178.44 1267.3C2174.53 1269.52 2172.52 1270.65 2169.77 1271.45C2165.14 1272.8 2160.45 1272.91 2160.45 1272.91C2156.49 1273 2155.38 1272.36 2153.22 1273.32C2152.78 1273.51 2149.49 1275.03 2148.69 1278.31C2148 1281.12 2149.53 1283.56 2150.75 1285.42C2151.64 1286.78 2154.44 1290.69 2161.49 1293.6C2165.98 1295.46 2169.47 1295.79 2175.52 1296.31C2180.85 1296.77 2187.79 1297.33 2196.5 1295.64C2203.06 1294.37 2201.82 1293.53 2207.99 1292.49C2217.46 1290.89 2227.72 1291.34 2227.72 1291.34C2233.3 1291.58 2235.59 1292.15 2236.96 1290.52C2238.6 1288.57 2236.89 1285.87 2236.99 1279.75C2237.06 1275.11 2236.48 1255.67 2231.12 1250.62C2221.91 1241.94 2205.65 1243.12 2198.25 1249.82L2198.22 1249.83Z"
            fill="#5F53B7"
          />
          <path
            d="M2236.96 1279.75C2237.03 1275.11 2236.45 1255.67 2231.09 1250.62C2228.72 1248.39 2225.89 1246.81 2222.86 1245.81C2224.08 1254.21 2222.84 1261.9 2218.69 1267.24C2215.91 1270.82 2210.54 1275 2205.27 1277.87C2204.42 1278.33 2200.18 1280.6 2194.08 1282.35C2194.08 1282.35 2187.28 1284.29 2180.1 1284.59C2172.52 1284.9 2161.5 1282.47 2149.47 1276.45C2149.12 1276.99 2148.84 1277.61 2148.67 1278.31C2147.98 1281.12 2149.51 1283.56 2150.73 1285.42C2151.62 1286.78 2154.42 1290.69 2161.47 1293.6C2165.96 1295.46 2169.45 1295.79 2175.5 1296.31C2180.83 1296.77 2187.77 1297.33 2196.48 1295.64C2203.04 1294.37 2201.8 1293.53 2207.97 1292.49C2217.44 1290.89 2227.7 1291.34 2227.7 1291.34C2233.28 1291.58 2235.57 1292.15 2236.94 1290.52C2238.58 1288.57 2236.87 1285.87 2236.97 1279.75H2236.96Z"
            fill="#5949B2"
          />
          <path
            d="M2224.47 1285.72C2221.08 1285.91 2217.41 1285.68 2210.97 1286.66C2207.57 1287.18 2206 1287.64 2199.24 1289.13C2191.12 1290.92 2187.07 1291.82 2185.5 1292C2177.1 1293 2170.49 1290.6 2163.15 1287.93C2159.34 1286.55 2154.23 1284.34 2148.59 1280.79C2148.89 1282.56 2149.89 1284.13 2150.73 1285.42C2151.62 1286.78 2154.42 1290.69 2161.47 1293.6C2165.96 1295.46 2169.45 1295.79 2175.5 1296.31C2180.83 1296.77 2187.77 1297.33 2196.48 1295.64C2203.04 1294.37 2201.8 1293.53 2207.97 1292.49C2217.44 1290.89 2227.7 1291.34 2227.7 1291.34C2233.28 1291.58 2235.57 1292.15 2236.94 1290.52C2238.26 1288.96 2237.42 1286.91 2237.08 1283.02C2232.04 1284.87 2227.8 1285.53 2224.47 1285.72Z"
            fill="#9790F4"
          />
          <path
            d="M2159.33 1076.76C2156.69 1071.25 2157.51 1066.23 2157.51 1066.23C2158.32 1061.27 2161.46 1057.97 2163.32 1056.06C2166.04 1053.27 2170.16 1050.18 2180.39 1046.98C2186.16 1045.17 2191.58 1044.05 2202.54 1042.62C2211.6 1041.44 2218.36 1040.55 2227.23 1040.08C2247.84 1038.98 2262.53 1038.19 2279.16 1042.99C2290.01 1046.12 2319.87 1056.85 2319.11 1067.32C2317.43 1090.51 2167.06 1092.91 2159.32 1076.76H2159.33Z"
            fill="#1C3393"
          />
          <path
            d="M2207.63 1101.82C2210.73 1104.03 2211.19 1107.11 2214.17 1123.25C2217.33 1140.36 2218.9 1148.91 2219.98 1153.39C2220.42 1155.24 2223.3 1164.55 2229.06 1183.17C2229.06 1183.17 2230.1 1186.53 2235.6 1207.5C2238.5 1218.57 2243.57 1244.94 2242.38 1247.36C2238.48 1255.28 2219.35 1248.58 2209.12 1241.87C2198.88 1235.16 2198.95 1208.12 2194.2 1181C2186.48 1136.88 2169.17 1122.27 2178.58 1109.1C2185.08 1099.99 2200.59 1096.82 2207.63 1101.84V1101.82Z"
            fill="#1C3393"
          />
          <path
            d="M2355.59 1076.79C2357.6 1083.58 2348.08 1103.27 2326.24 1106.01C2307.48 1108.36 2285.14 1109.42 2283.58 1109.41C2241.44 1109.02 2212.08 1120.73 2195.4 1122.44C2179.26 1124.09 2171.19 1124.92 2163.43 1123.58C2155.36 1122.18 2146.38 1120.49 2140.43 1112.79C2139.24 1111.25 2134.72 1105.22 2135.38 1096.88C2135.97 1089.43 2140.33 1084.59 2142.11 1082.68C2147.8 1076.56 2154.67 1074.84 2161.74 1073.02C2173.17 1070.09 2184.44 1066.49 2195.96 1063.93C2224.49 1057.6 2222.72 1056.94 2237.47 1054.27C2254.58 1051.18 2294.63 1046.92 2304.3 1047.01C2339.1 1047.35 2351.65 1063.48 2355.6 1076.8L2355.59 1076.79Z"
            fill="#3845B8"
          />
          <path
            d="M2187.03 1257.25C2187.03 1249.62 2160.63 1160.56 2145.37 1133.69C2142.24 1128.17 2136.16 1107.96 2135.56 1101.8C2135.23 1098.42 2133.99 1091.5 2143.72 1084.75C2151.64 1079.26 2161.78 1082.51 2164.78 1083.66C2167.75 1084.8 2172.86 1087.38 2181.49 1099.64C2188.7 1109.89 2194.62 1111.05 2203.07 1131.53C2226.92 1189.25 2240.28 1255.38 2238.57 1261.04C2236.99 1266.27 2187.02 1265.24 2187.02 1257.25H2187.03Z"
            fill="#3845B8"
          />
          <path
            d="M2355.59 1076.79C2353.29 1069.05 2348.09 1060.35 2337.29 1054.36C2334.07 1060.82 2328.74 1069.08 2319.94 1075.94C2313.76 1080.76 2306.24 1084.6 2280.78 1090.48C2266.74 1093.73 2255.06 1095.78 2236.03 1098.87C2196.34 1105.31 2187.53 1106.02 2184.57 1112.85C2181.63 1119.63 2187.24 1125.93 2196.32 1144.18C2196.32 1144.18 2207.3 1166.27 2215.34 1193.41C2220.01 1209.17 2225.39 1233.32 2225.51 1264.11C2232.66 1263.74 2238.08 1262.71 2238.59 1261.04C2240.3 1255.37 2226.94 1189.24 2203.09 1131.53C2201.53 1127.76 2200.06 1124.65 2198.65 1122.01C2215.77 1119.32 2244.06 1109.05 2283.58 1109.41C2285.14 1109.42 2307.48 1108.36 2326.24 1106.01C2348.08 1103.27 2357.61 1083.59 2355.59 1076.79Z"
            fill="#283AA3"
          />
          <path
            d="M2186.06 1302.29L2196.24 1301.01L2166.62 1022.53L2145.53 1025.19L2186.06 1302.29Z"
            fill="#676791"
          />
          <path
            d="M2166.62 1022.53L2168.75 1042.53L2155.87 1044.16L2190.18 1301.77L2186.06 1302.29L2145.53 1025.19L2166.62 1022.53Z"
            fill="#55557F"
          />
          <path
            d="M2166.3 942.119C2167.7 943.339 2169.04 944.049 2170.23 944.689C2171.72 945.489 2172.09 945.509 2173.18 946.069C2175.16 947.099 2176.4 948.319 2177.78 949.709C2181.05 952.989 2183.68 956.629 2183.68 956.629C2184.03 957.109 2184.68 958.029 2185.87 958.599C2187.19 959.239 2187.73 959.529 2197.77 959.369C2199.93 959.329 2202.11 959.299 2204.83 959.179C2204.83 959.179 2206.28 962.309 2205.63 969.949C2205.08 976.449 2203.51 978.909 2203.51 978.909C2196.56 977.609 2188.03 975.569 2187.05 975.579C2185.74 975.589 2184.19 975.669 2181.42 976.039C2175.75 976.789 2176.12 977.259 2173.05 977.409C2169.5 977.589 2166.51 977.309 2166.51 977.309C2165.19 977.189 2164.13 977.019 2162.57 977.229C2161.02 977.439 2159.96 977.879 2158.89 978.299C2158.6 978.419 2156.37 979.199 2151.92 980.779C2150.99 981.109 2148.78 981.639 2144.35 982.709C2143.74 982.859 2142.46 983.149 2141.45 982.469C2141.39 982.429 2140.49 981.809 2140.58 981.079C2140.66 980.429 2141.49 980.049 2142.52 979.609C2144.72 978.669 2145.82 978.199 2146.86 977.839C2151.26 976.349 2150.29 976.269 2152.67 975.619C2153.18 975.479 2154.55 975.119 2155.96 974.109C2156.46 973.749 2157.3 973.129 2157.17 972.609C2157.06 972.149 2156.25 971.989 2155.96 971.929C2154.68 971.669 2153.57 972.129 2153.35 972.219C2153.35 972.219 2151.29 972.539 2147.18 973.179C2142.95 973.829 2143.68 973.489 2140.7 974.019C2138.98 974.329 2137.2 974.279 2135.48 974.609C2135.11 974.679 2134.3 974.839 2133.41 974.509C2133.09 974.389 2132.03 974.009 2131.72 972.979C2131.45 972.079 2131.9 971.139 2132.45 970.629C2133.19 969.949 2134.11 969.999 2135.39 969.939C2137.01 969.859 2138.6 969.469 2140.2 969.229C2143.02 968.819 2142.71 968.609 2147.22 967.799C2149.7 967.349 2150.94 967.129 2151.51 967.169C2152.52 967.249 2153.52 967.489 2153.91 966.969C2154.14 966.659 2154.12 966.129 2153.86 965.829C2153.37 965.259 2152.14 965.619 2151.27 965.809C2151.02 965.859 2149.17 965.819 2145.46 965.739C2140.38 965.629 2140.58 965.409 2138 965.489C2136.58 965.539 2135.15 965.429 2133.74 965.599C2133.39 965.639 2132.64 965.739 2131.66 965.599C2130.73 965.469 2129.92 965.359 2129.52 964.769C2128.93 963.919 2129.41 962.379 2130.29 961.589C2130.71 961.209 2131.2 961.019 2132.92 960.779C2135.3 960.439 2136.57 960.429 2136.57 960.429C2140.56 960.399 2140.21 959.989 2143.44 960.029C2147.09 960.079 2148.92 960.099 2150.59 960.369C2150.59 960.369 2151.69 960.549 2153.4 960.189C2154.25 960.009 2154.52 959.839 2154.57 959.619C2154.67 959.199 2153.91 958.689 2153.69 958.539C2152.51 957.749 2151.24 957.709 2150.72 957.669C2149.07 957.559 2149.91 957.289 2144.67 956.039C2142.58 955.539 2141.54 955.289 2140.46 955.109C2139.19 954.909 2137.73 954.739 2135.84 954.059C2134.67 953.639 2134.03 953.279 2133.73 952.609C2133.48 952.059 2133.44 951.299 2133.82 950.749C2134.08 950.369 2134.6 950.009 2136.45 949.939C2138.28 949.869 2139.54 950.149 2140.79 950.349C2142.38 950.609 2141.87 950.409 2145.23 950.769C2148.68 951.139 2150.41 951.329 2152.45 951.839C2154.33 952.309 2154.53 952.539 2156.24 952.849C2157.79 953.129 2158.97 953.189 2160.58 953.259C2162.69 953.359 2163.77 953.399 2164.95 953.149C2165.16 953.099 2168.34 952.409 2168.36 951.339C2168.36 951.089 2168.2 950.829 2166.67 949.809C2165.31 948.899 2164.24 948.289 2164.15 948.239C2162.21 947.139 2160.94 945.789 2160.35 945.149C2159.22 943.939 2157.86 942.459 2157.47 940.239C2157.33 939.429 2157.05 937.889 2157.93 937.149C2158.87 936.339 2160.53 936.969 2160.84 937.079C2161.66 937.379 2162.14 937.839 2163.05 938.739C2165.49 941.179 2165.36 941.279 2166.32 942.109L2166.3 942.119Z"
            fill="#E28366"
          />
          <path
            d="M2248.61 949.991C2244.69 949.271 2242.77 952.341 2233.33 955.691C2228.02 957.571 2209.25 958.431 2204.65 959.201C2186.34 962.271 2185.26 958.941 2184.36 961.301C2183.27 964.161 2185 975.281 2203.52 978.941C2214.69 981.151 2254.81 980.851 2259.2 970.831C2262.38 963.571 2255.66 951.281 2248.61 949.991Z"
            fill="#E28366"
          />
          <path
            d="M2236.12 952.91C2236.61 951.51 2238.77 947.5 2243.11 942.29C2244.74 940.34 2254.28 930.86 2258.27 921.17C2260.5 915.75 2280.05 877.57 2282.29 877.57C2288.08 877.57 2280.19 930.42 2272.1 952.12C2269.68 958.61 2270.94 965.58 2269.74 967.41C2264.98 974.64 2256.93 977.99 2253.71 978.02C2251.22 978.04 2247.7 972.94 2240.76 962.74C2236.96 957.16 2235.28 955.23 2236.1 952.9L2236.12 952.91Z"
            fill="#7979DB"
          />
          <path
            d="M2285.83 868.499C2284.52 868.959 2282.71 870.959 2279.1 874.969C2275.59 878.869 2274.58 880.529 2273.92 882.479C2273.2 884.609 2273.14 886.36 2273.14 887.14C2273.14 889.24 2273.15 892.2 2274.43 892.84C2276.81 894.02 2280.49 885.64 2291.26 877.82C2295.04 875.07 2297.37 874.09 2297.22 872.38C2296.97 869.66 2290.56 866.839 2285.83 868.499Z"
            fill="#5733AF"
          />
          <path
            d="M2268.29 858.469C2269.18 860.339 2273.18 859.209 2278.78 863.519C2282.57 866.439 2284.43 869.809 2284.8 870.509C2287.99 876.459 2287.59 882.949 2287.32 887.209C2287.02 892.099 2286.16 893.579 2287.13 894.399C2289.97 896.809 2301.49 887.459 2305.38 884.299C2316.42 875.339 2330.45 863.949 2328.1 852.839C2327.72 851.049 2327.39 851.469 2325.77 847.399C2320.74 834.739 2323.43 829.229 2320.72 826.619C2312.29 818.489 2264.99 851.489 2268.29 858.469Z"
            fill="#EB8E6C"
          />
          <path
            d="M2284.98 860.4C2292.87 851.99 2296.07 840.47 2296.35 833.07C2288.34 837.66 2280.18 843.57 2274.71 848.66C2274 849.37 2273.3 850.06 2272.58 850.74C2269.32 854.11 2267.56 856.93 2268.29 858.48C2269.18 860.35 2273.18 859.22 2278.78 863.53C2279.28 863.91 2279.74 864.31 2280.17 864.7C2281.77 863.51 2283.41 862.09 2284.98 860.41V860.4Z"
            fill="#DB765E"
          />
          <path
            d="M2359.75 877.69C2354.37 869.46 2349.26 864.87 2349.26 864.87C2344.27 860.38 2340.8 859.01 2334.5 852.83C2329.21 847.64 2330.18 847.17 2328.29 846.23C2319.81 842 2312.02 859.19 2282.29 880.48C2279.25 882.66 2275.18 884.56 2272.58 892.95C2258.27 939.04 2260.34 986.84 2261.49 994.98C2262.85 1004.58 2262.55 1030.29 2263.46 1039.92C2271.82 1039.92 2289.64 1047.87 2293.34 1049.71C2319.13 1062.52 2354.21 1087.06 2356.21 1086.18C2367.64 1063.74 2363.42 992.83 2364.8 972.07C2366.68 943.83 2367.53 938.75 2367.91 921.19C2368.24 905.78 2368 890.3 2359.75 877.69Z"
            fill="#8989E5"
          />
          <path
            d="M2275.67 783.711C2274.41 784.601 2274.68 784.761 2269.46 791.281C2265.94 795.671 2264.76 796.911 2263.05 799.821C2260.89 803.511 2260.47 805.471 2260.33 806.231C2260.11 807.421 2260.33 812.161 2259.94 813.611C2259.82 814.061 2249.89 827.331 2250.04 828.171C2250.23 829.321 2251.08 830.351 2251.98 830.891C2253.5 831.801 2254.53 830.941 2255.67 831.861C2256.42 832.471 2256.63 833.381 2257.03 835.161C2257.36 836.611 2257.4 837.741 2257.42 838.071C2257.63 842.691 2258.44 842.771 2258.39 846.231C2258.37 847.531 2258.34 849.651 2257.61 852.251C2257.14 853.941 2256.79 854.321 2256.83 855.361C2256.95 858.181 2259.75 860.151 2260.13 860.411C2261.61 861.421 2264.23 862.451 2269.26 861.381C2278.34 859.451 2285.67 852.711 2289.26 849.151C2295.71 842.751 2303.33 835.201 2308.68 822.161C2313.28 810.931 2316.99 801.881 2312.56 793.611C2306.65 782.571 2290.87 781.591 2287.51 781.381C2284.15 781.171 2279.58 780.951 2275.66 783.711H2275.67Z"
            fill="#EB8E6C"
          />
          <path
            d="M2287.34 1047C2288.7 1045.39 2300.14 1020.84 2301.98 1018.69C2305.54 1014.54 2342.05 965.12 2342.05 965.12C2359.2 931.1 2361.41 906.12 2358.64 905.15C2356.33 904.34 2349.08 925.45 2340.35 940.02C2328.78 959.35 2306.68 980.41 2261.48 994.88C2262.85 1004.5 2262.55 1030.25 2263.46 1039.91C2271.82 1039.91 2284.9 1047.18 2287.34 1046.99V1047Z"
            fill="#7D7DDB"
          />
          <path
            d="M2317.22 778.461C2312.26 777.021 2306.93 777.291 2306.93 777.291C2303.02 777.491 2301.06 778.361 2296.83 777.871C2294.62 777.621 2294.66 777.331 2290.81 776.511C2285.31 775.351 2282.56 774.761 2279.94 775.151C2279.62 775.201 2272.6 776.331 2269.65 781.751C2269.14 782.691 2268.25 784.331 2268.87 785.631C2269.45 786.841 2271.29 786.841 2277.03 786.991C2282.56 787.141 2285.36 787.241 2286.74 788.541C2287.84 789.571 2288.63 791.231 2288.49 792.811C2288.44 793.361 2288.27 794.021 2286.55 796.501C2284.1 800.031 2283.41 800.211 2283.44 801.161C2283.52 803.301 2287.03 803.301 2287.91 806.011C2288.36 807.381 2287.67 808.041 2285.77 813.781C2284.34 818.101 2284.32 819.001 2284.8 819.611C2285.59 820.601 2287.16 820.041 2290.04 820.001C2292.31 819.971 2298 819.891 2300.53 822.721C2302.83 825.301 2300.36 827.911 2302.67 831.261C2304.64 834.131 2308.38 835.011 2311.41 835.731C2315.89 836.791 2318.47 835.931 2321.12 838.251C2322.09 839.101 2322.57 839.931 2323.26 839.801C2324.56 839.551 2324.46 836.291 2325.59 832.811C2326.95 828.631 2329 827.431 2331.03 824.271C2334.31 819.151 2334.43 813.701 2334.53 809.511C2334.81 796.961 2327.8 781.511 2317.25 778.441L2317.22 778.461Z"
            fill="#24324C"
          />
          <path
            d="M2316.33 821.976C2317.84 811.954 2312.22 802.802 2303.79 801.535C2295.36 800.267 2287.3 807.363 2285.79 817.385C2284.29 827.407 2289.9 836.559 2298.33 837.827C2306.76 839.095 2314.82 831.998 2316.33 821.976Z"
            fill="#A8B4EF"
          />
          <path
            d="M2281.47 817.961C2280.26 830.891 2289.39 840.421 2301.64 837.931C2308.51 836.531 2312.59 833.181 2314.18 822.571C2315.77 811.971 2309.59 802.251 2300.36 800.861C2291.13 799.471 2282.47 807.291 2281.47 817.961Z"
            fill="#CFD8F9"
          />
          <path
            d="M2316.33 821.976C2317.84 811.954 2312.22 802.802 2303.79 801.535C2295.36 800.267 2287.3 807.363 2285.79 817.385C2284.29 827.407 2289.9 836.559 2298.33 837.827C2306.76 839.095 2314.82 831.998 2316.33 821.976Z"
            fill="#A8B4EF"
          />
          <path
            d="M2301.87 826.31C2304.72 826.45 2307.18 824.23 2307.32 821.37L2309.1 785C2309.12 784.55 2308.77 784.16 2308.31 784.13L2299.58 783.7C2299.13 783.68 2298.74 784.03 2298.71 784.49L2296.93 820.86C2296.79 823.71 2299.01 826.17 2301.87 826.31Z"
            fill="#E1EAFF"
          />
          <path
            d="M2302.72 826.351C2305.57 826.491 2308.03 824.271 2308.17 821.411L2309.95 785.041C2309.97 784.591 2309.62 784.191 2309.16 784.171L2300.43 783.741C2299.98 783.721 2299.58 784.071 2299.56 784.531L2297.78 820.901C2297.64 823.751 2299.86 826.211 2302.72 826.341V826.351Z"
            fill="#BBCAF9"
          />
          <path
            d="M2309.09 789.241C2309.6 789.261 2310.01 788.831 2309.97 788.321C2309.76 785.731 2308.7 777.671 2305.14 776.311C2304.82 776.191 2292.44 775.551 2292.19 775.681C2291.9 775.831 2291.72 776.641 2292.12 776.861C2292.92 777.301 2293.69 778.011 2294.72 779.301C2296.14 781.101 2296.57 785.681 2296.6 787.591C2296.6 788.041 2297.11 788.651 2297.56 788.671L2309.1 789.241H2309.09Z"
            fill="#CFD8F9"
          />
          <path
            d="M2310.79 789.321C2311.3 789.351 2311.71 788.911 2311.67 788.401C2311.46 785.821 2310.22 777.321 2306.65 775.971C2306.33 775.851 2291.62 775.301 2292.19 775.681C2293.36 776.461 2294.77 777.311 2296.41 779.381C2297.83 781.181 2298.06 786.001 2298.09 787.911C2298.09 788.361 2298.45 788.721 2298.89 788.741L2310.78 789.321H2310.79Z"
            fill="#A8B4EF"
          />
          <path
            d="M2272.58 850.73C2273.29 850.06 2274 849.36 2274.71 848.65C2273.95 849.36 2273.24 850.05 2272.58 850.73Z"
            fill="#EB8E6C"
          />
          <path
            d="M2292.51 903.45C2295.27 903.62 2296.6 898.55 2303.78 885.59C2308.44 877.17 2311.17 872.31 2315.9 866.88C2318.02 864.44 2322.22 859.98 2328.45 855.61C2330.26 854.34 2332.07 853.21 2333.85 852.19C2329.3 847.62 2330.1 847.14 2328.29 846.24C2319.81 842.01 2312.02 859.2 2282.29 880.49C2281.09 881.35 2279.72 882.17 2278.35 883.37C2279.34 884.53 2280.47 885.92 2281.65 887.52C2289.09 897.55 2289.6 903.29 2292.5 903.47L2292.51 903.45Z"
            fill="#7474CE"
          />
          <path
            d="M2326.48 841.83C2324.67 841.52 2323.26 842.6 2318.97 846.23C2313.28 851.05 2310.44 853.46 2308.87 855.03C2303 860.92 2300.07 864.26 2297.74 866.68C2288.26 876.54 2282.29 880.47 2279.66 882.46C2279.07 882.91 2279.66 882.46 2283.24 886.61C2290.46 894.99 2291.22 895.94 2292.56 895.93C2295.03 895.91 2296.13 892.67 2300.33 885.31C2300.33 885.31 2306.47 874.53 2315.35 863.56C2319.06 858.97 2320.98 856.64 2323.89 854.76C2327.91 852.17 2332.56 851.8 2331.4 849.58C2330.57 848 2326.48 841.81 2326.48 841.81V841.83Z"
            fill="#A4A3FE"
          />
          <path
            d="M2182.22 1003.2C2182.77 998.022 2183.21 992.842 2183.64 987.652C2183.35 986.322 2183.03 984.991 2182.69 983.681C2181.28 983.411 2179.66 982.931 2178.09 981.921C2177.32 981.431 2176.16 980.252 2173.82 977.892C2170.93 974.972 2169.44 973.192 2166.62 971.212C2165.7 970.572 2164.99 970.142 2164.13 969.782C2162.91 969.272 2162.12 969.181 2159.13 968.791C2153.61 968.071 2153.71 968.041 2153.08 968.051C2152.05 968.061 2150.87 968.151 2149.08 967.941C2148.37 967.861 2147.78 967.792 2146.99 967.582C2145.42 967.172 2143.87 966.481 2143.87 966.481C2142.79 965.991 2142.55 965.771 2142.24 965.921C2141.65 966.201 2141.65 967.521 2141.93 968.601C2142.5 970.761 2146.29 972.052 2146.9 972.322C2148.17 972.872 2149.08 972.831 2149.09 972.981C2149.09 973.261 2146.26 973.512 2143.66 973.642C2141.36 973.752 2140.98 973.682 2137.68 973.772C2133.86 973.882 2132.57 974.031 2132.02 974.101C2130.35 974.311 2130.89 974.362 2127.79 974.892C2125.78 975.232 2124.32 975.421 2122.5 976.251C2121.29 976.801 2120.76 977.251 2120.61 977.871C2120.45 978.531 2120.75 979.251 2121.16 979.691C2121.88 980.471 2123.02 980.502 2124.7 980.402C2127.22 980.252 2128.54 979.961 2129.97 979.791C2131.6 979.591 2140.31 979.361 2142.29 980.161C2142.53 980.261 2143.14 980.511 2143.11 980.731C2143.07 981.011 2142.06 981.091 2141.21 981.161C2138.03 981.401 2136.44 981.531 2135.33 981.561C2133.47 981.621 2132.09 981.721 2131.03 981.801C2126.45 982.141 2127.16 982.431 2124.33 982.551C2122.33 982.631 2120.9 982.871 2119.95 983.311C2119.46 983.541 2118.61 984.152 2118.39 985.202C2118.23 985.942 2118.42 986.881 2119.04 987.411C2119.63 987.921 2120.42 987.881 2120.74 987.861C2122.74 987.761 2124.75 987.961 2126.74 987.751C2128.39 987.571 2127.35 987.822 2133.75 987.702C2135.82 987.662 2137.24 987.612 2139.46 987.702C2140.93 987.762 2143.16 987.841 2143.17 988.061C2143.17 988.201 2142.25 988.341 2136.6 988.991C2132.46 989.471 2130.38 989.711 2129.64 989.691C2128 989.651 2126.36 989.922 2124.73 989.772C2123.98 989.702 2123.24 989.591 2122.58 990.051C2121.85 990.561 2121.4 991.661 2121.73 992.541C2122.03 993.341 2122.86 993.652 2123.75 993.962C2125.05 994.422 2126.08 994.381 2127.4 994.361C2129.47 994.341 2122.93 994.481 2131.64 994.431C2136.38 994.411 2138.74 994.392 2138.97 994.382C2140.44 994.312 2141.91 994.461 2143.38 994.431C2143.38 994.431 2144.55 994.401 2146.08 995.001C2146.55 995.181 2146.66 995.271 2146.66 995.371C2146.66 995.701 2145.26 995.882 2143.1 996.332C2139.25 997.132 2138.95 997.542 2137.37 997.402C2137.35 997.402 2137.37 997.401 2134.49 996.911C2133.29 996.711 2132.28 996.551 2131.1 996.871C2130.45 997.051 2130.16 997.271 2129.97 997.491C2129.51 998.021 2129.35 998.891 2129.68 999.491C2129.96 999.991 2130.5 1000.16 2130.94 1000.3C2133.33 1001.04 2134.52 1001.4 2134.89 1001.46C2137.53 1001.83 2139.61 1001.83 2139.89 1001.82C2143.42 1001.8 2143.74 1001.44 2147.14 1001.33C2147.78 1001.31 2150.44 1001.23 2153.83 1001.55C2157 1001.85 2156.79 1002.11 2160.24 1002.48C2164.53 1002.94 2166.67 1003.17 2168.63 1002.56C2169.64 1002.24 2170.64 1001.77 2172.33 1001.68C2173.63 1001.61 2174.57 1001.81 2175.66 1002.03C2180.14 1002.93 2179.57 1002.59 2181.98 1003.16C2182.04 1003.18 2182.11 1003.19 2182.18 1003.21L2182.22 1003.2Z"
            fill="#EB8E6C"
          />
          <path
            d="M2148.41 971.812C2150.1 972.222 2151.41 972.182 2152.12 972.172C2157.28 972.112 2162.09 973.362 2162.08 973.432C2162.08 973.482 2159.72 973.212 2155.33 972.932C2153.64 972.822 2152.74 972.782 2151.59 972.782C2150.59 972.782 2149.68 972.822 2148.88 972.872C2148.54 972.802 2147.81 972.702 2146.91 972.312C2146.3 972.052 2142.51 970.752 2141.94 968.592C2141.93 968.542 2141.91 968.482 2141.9 968.432C2142.91 969.252 2143.84 969.832 2144.59 970.252C2145.4 970.702 2146.67 971.392 2148.42 971.822L2148.41 971.812Z"
            fill="#E57055"
          />
          <path
            d="M2123.12 976.452C2123.42 976.492 2123.6 976.572 2123.72 976.712C2123.91 976.942 2123.86 977.252 2123.71 978.052C2123.55 978.912 2123.46 979.342 2123.43 979.402C2123.17 979.842 2122.5 980.042 2121.63 980.032C2121.46 979.932 2121.31 979.812 2121.17 979.672C2120.76 979.232 2120.45 978.522 2120.62 977.852C2120.74 977.352 2121.11 976.962 2121.9 976.542C2122.29 976.442 2122.72 976.392 2123.13 976.452H2123.12Z"
            fill="#FFD5CA"
          />
          <path
            d="M2143.88 966.481C2143.88 966.481 2145.43 967.181 2147 967.581C2147.11 967.611 2147.21 967.631 2147.31 967.661C2147.02 968.101 2146.56 968.611 2145.85 968.841C2144.47 969.301 2143.2 968.371 2142.66 967.971C2142.29 967.701 2142 967.411 2141.76 967.121C2141.78 966.541 2141.92 966.071 2142.25 965.911C2142.55 965.771 2142.79 965.991 2143.88 966.471V966.481Z"
            fill="#FFD5CA"
          />
          <path
            d="M2119.68 983.841C2120.44 983.811 2121.15 983.781 2121.48 984.221C2121.58 984.361 2121.61 984.561 2121.66 984.951C2121.78 985.921 2121.87 986.671 2121.48 986.981C2121.39 987.051 2121.14 987.101 2120.64 987.201C2120.38 987.251 2120.25 987.261 2119.87 987.321C2118.83 987.471 2118.81 987.501 2118.7 987.461C2118.11 987.251 2117.99 986.231 2117.96 986.011C2117.94 985.821 2117.79 984.561 2118.55 984.041C2118.79 983.871 2119.1 983.861 2119.7 983.841H2119.68Z"
            fill="#FFD5CA"
          />
          <path
            d="M2122.78 990.211C2123.66 990.191 2124.07 990.311 2124.29 990.401C2124.59 990.511 2124.69 990.621 2124.75 990.671C2124.93 990.861 2124.96 991.081 2125 991.401C2125.1 992.091 2124.93 992.611 2124.87 992.781C2124.79 993.011 2124.75 993.131 2124.63 993.241C2124.44 993.431 2124.2 993.461 2123.65 993.491C2122.79 993.531 2122.36 993.551 2122.15 993.431C2121.68 993.171 2121.51 992.681 2121.45 992.501C2121.16 991.691 2121.38 990.591 2122.01 990.281C2122.11 990.231 2122.33 990.221 2122.78 990.211Z"
            fill="#FFD5CA"
          />
          <path
            d="M2130.9 997.88C2131.07 997.94 2131.38 998.04 2131.58 998.32C2131.74 998.54 2131.75 998.81 2131.76 999.36C2131.77 999.79 2131.78 1000 2131.71 1000.1C2131.38 1000.57 2130.11 1000.24 2129.57 999.83C2129.44 999.73 2129.43 999.58 2129.37 999.4C2129.14 998.7 2129.27 997.91 2129.63 997.76C2129.74 997.72 2130.67 997.81 2130.9 997.89V997.88Z"
            fill="#FFD5CA"
          />
          <path
            d="M2123.39 985.312C2123.4 985.772 2123.47 986.222 2123.58 986.662L2123.37 986.712C2123.25 986.252 2123.18 985.782 2123.17 985.312C2123.17 984.952 2123.19 984.582 2123.24 984.232L2123.45 984.262C2123.39 984.612 2123.37 984.962 2123.38 985.312H2123.39Z"
            fill="#E57055"
          />
          <path
            d="M2123.93 985.281C2123.99 985.791 2124.11 986.291 2124.31 986.771L2124.11 986.851C2123.91 986.351 2123.77 985.831 2123.71 985.301C2123.66 984.831 2123.67 984.351 2123.73 983.881L2123.94 983.911C2123.88 984.361 2123.87 984.821 2123.92 985.281H2123.93Z"
            fill="#E57055"
          />
          <path
            d="M2125.23 977.661C2125.18 978.081 2125.16 978.511 2125.17 978.931H2124.96C2124.96 978.501 2124.96 978.071 2125.02 977.641C2125.06 977.271 2125.12 976.891 2125.21 976.531L2125.42 976.581C2125.34 976.941 2125.28 977.301 2125.24 977.671L2125.23 977.661Z"
            fill="#E57055"
          />
          <path
            d="M2126.22 991.831C2126.2 992.271 2126.21 992.721 2126.26 993.171L2126.05 993.191C2126 992.741 2125.99 992.281 2126.01 991.821C2126.03 991.531 2126.06 991.241 2126.1 990.961L2126.31 990.991C2126.27 991.261 2126.24 991.551 2126.22 991.831Z"
            fill="#E57055"
          />
          <path
            d="M2133.4 974.561C2133.2 975.011 2133.07 975.491 2133 975.971C2132.89 976.721 2132.94 977.471 2133.15 978.211L2132.95 978.271C2132.74 977.501 2132.69 976.721 2132.8 975.941C2132.87 975.441 2133.01 974.941 2133.21 974.471L2133.4 974.551V974.561Z"
            fill="#E57055"
          />
          <path
            d="M2133.76 975.941C2133.7 976.501 2133.69 977.071 2133.74 977.641L2133.53 977.661C2133.48 977.081 2133.49 976.491 2133.55 975.921C2133.58 975.621 2133.64 975.321 2133.7 975.021L2133.91 975.071C2133.84 975.361 2133.79 975.661 2133.76 975.951V975.941Z"
            fill="#E57055"
          />
          <path
            d="M2134.6 975.741C2134.61 976.161 2134.59 976.581 2134.51 977.001C2134.46 977.311 2134.38 977.631 2134.28 977.931L2134.08 977.861C2134.31 977.171 2134.41 976.461 2134.39 975.741C2134.38 975.381 2134.33 975.011 2134.26 974.661L2134.47 974.621C2134.55 974.991 2134.6 975.361 2134.61 975.741H2134.6Z"
            fill="#E57055"
          />
          <path
            d="M2132.67 983.002C2132.52 983.352 2132.42 983.732 2132.38 984.102C2132.33 984.512 2132.34 985.162 2132.6 985.872C2132.67 986.072 2132.76 986.262 2132.87 986.442L2132.69 986.552C2132.58 986.362 2132.48 986.162 2132.41 985.952C2132.13 985.202 2132.13 984.522 2132.17 984.082C2132.21 983.682 2132.32 983.292 2132.48 982.922L2132.68 983.002H2132.67Z"
            fill="#E57055"
          />
          <path
            d="M2133.13 984.111C2133.1 984.811 2133.25 985.531 2133.57 986.181L2133.38 986.271C2133.05 985.581 2132.89 984.831 2132.92 984.101C2132.94 983.741 2133 983.381 2133.1 983.031L2133.3 983.091C2133.2 983.421 2133.14 983.771 2133.13 984.111Z"
            fill="#E57055"
          />
          <path
            d="M2134.23 984.281C2134.32 984.891 2134.32 985.521 2134.24 986.141L2134.03 986.111C2134.11 985.511 2134.1 984.901 2134.02 984.311C2133.96 983.881 2133.85 983.451 2133.71 983.041L2133.91 982.971C2134.06 983.401 2134.17 983.841 2134.23 984.281Z"
            fill="#E57055"
          />
          <path
            d="M2134.29 991.203C2134.29 992.273 2134.8 993.092 2135.11 993.482L2134.94 993.612C2134.61 993.202 2134.07 992.333 2134.08 991.193C2134.08 990.813 2134.15 990.433 2134.27 990.062L2134.47 990.133C2134.35 990.483 2134.29 990.843 2134.29 991.203Z"
            fill="#E57055"
          />
          <path
            d="M2135.26 991.512C2135.4 992.222 2135.59 992.942 2135.81 993.642L2135.61 993.702C2135.39 992.992 2135.2 992.272 2135.05 991.552C2134.95 991.072 2134.87 990.592 2134.81 990.102L2135.02 990.072C2135.08 990.552 2135.16 991.032 2135.26 991.502V991.512Z"
            fill="#E57055"
          />
          <path
            d="M2136.2 991.001C2136.64 991.921 2136.61 992.821 2136.51 993.421L2136.3 993.381C2136.4 992.821 2136.43 991.951 2136.01 991.081C2135.87 990.781 2135.69 990.511 2135.47 990.261L2135.63 990.121C2135.86 990.391 2136.05 990.681 2136.2 990.991V991.001Z"
            fill="#E57055"
          />
          <path
            d="M2149.87 969.572C2149.83 970.052 2149.84 970.532 2149.89 971.012L2149.68 971.032C2149.62 970.542 2149.61 970.042 2149.66 969.552C2149.69 969.182 2149.76 968.802 2149.85 968.432L2150.06 968.482C2149.97 968.842 2149.91 969.202 2149.88 969.562L2149.87 969.572Z"
            fill="#E57055"
          />
          <path
            d="M2151.17 968.602L2151.38 968.662C2151.31 968.932 2151.22 969.212 2151.13 969.492C2150.99 969.922 2150.82 970.352 2150.64 970.762L2150.45 970.682C2150.63 970.272 2150.79 969.852 2150.93 969.422C2151.02 969.152 2151.1 968.882 2151.18 968.612L2151.17 968.602Z"
            fill="#E57055"
          />
          <path
            d="M2152.32 968.461L2152.52 968.531C2152.44 968.751 2152.34 968.971 2152.24 969.191C2152.02 969.671 2151.76 970.141 2151.46 970.581L2151.28 970.461C2151.57 970.031 2151.83 969.571 2152.04 969.101C2152.14 968.891 2152.23 968.671 2152.31 968.451L2152.32 968.461Z"
            fill="#E57055"
          />
          <path
            d="M2138.99 999.681C2139.09 1000.25 2139.34 1000.8 2139.71 1001.27L2139.54 1001.4C2139.15 1000.9 2138.88 1000.32 2138.77 999.721C2138.7 999.351 2138.69 998.981 2138.74 998.611L2138.95 998.641C2138.91 998.991 2138.92 999.351 2138.98 999.691L2138.99 999.681Z"
            fill="#E57055"
          />
          <path
            d="M2140.14 999.802C2140.35 1000.26 2140.55 1000.73 2140.72 1001.2L2140.52 1001.27C2140.35 1000.8 2140.16 1000.34 2139.95 999.892C2139.8 999.572 2139.64 999.262 2139.47 998.952L2139.66 998.852C2139.83 999.162 2140 999.482 2140.15 999.802H2140.14Z"
            fill="#E57055"
          />
          <path
            d="M2127.36 994.11C2130.61 994.14 2133.19 994.05 2133.84 994.03C2140.18 993.81 2138.61 994.09 2141.02 993.9C2142.17 993.81 2143.93 993.64 2146.14 994.18C2146.64 994.3 2148.5 994.75 2148.48 995.28C2148.48 995.56 2147.95 995.72 2145.09 996.54C2142.66 997.23 2142.09 997.38 2141.31 997.57C2138.65 998.2 2138.05 998.18 2137.76 998.15C2136.8 998.07 2136.7 997.86 2135.12 997.54C2134.27 997.37 2133.04 997.13 2132.01 997.17C2131.57 997.19 2130.8 997.28 2129.83 997.72C2129.88 997.64 2129.93 997.57 2129.99 997.5C2130.18 997.28 2130.47 997.07 2131.12 996.88C2132.29 996.55 2133.3 996.71 2134.51 996.92C2137.4 997.41 2137.37 997.41 2137.39 997.41C2138.97 997.54 2139.27 997.13 2143.12 996.34C2145.27 995.89 2146.68 995.71 2146.68 995.38C2146.68 995.29 2146.56 995.19 2146.1 995.01C2144.56 994.42 2143.4 994.44 2143.4 994.44C2141.93 994.47 2140.46 994.33 2138.99 994.39C2138.76 994.4 2136.39 994.41 2131.66 994.44C2122.95 994.49 2129.49 994.35 2127.42 994.37C2126.1 994.38 2125.07 994.42 2123.77 993.97C2123.3 993.81 2122.85 993.64 2122.49 993.41C2123.22 993.65 2124.05 993.86 2124.97 993.99C2125.79 994.11 2126.43 994.12 2127.37 994.13L2127.36 994.11Z"
            fill="#E57055"
          />
          <path
            d="M2123.81 987.421C2124.35 987.381 2123.79 987.431 2128.94 987.321C2136.44 987.161 2135.84 987.101 2137.59 987.121C2138.37 987.121 2145.62 987.211 2145.65 987.841C2145.68 988.341 2141.16 988.981 2140.54 989.071C2139.1 989.281 2138.92 989.221 2135.72 989.541C2133.67 989.751 2133.52 989.791 2131.06 990.041C2128.38 990.311 2127.02 990.451 2126.26 990.411C2125.42 990.371 2124.29 990.231 2122.95 989.831C2123.51 989.611 2124.12 989.691 2124.74 989.741C2126.37 989.891 2128.02 989.621 2129.65 989.661C2130.39 989.681 2132.47 989.441 2136.61 988.961C2142.26 988.301 2143.18 988.171 2143.18 988.031C2143.18 987.811 2140.95 987.731 2139.47 987.671C2137.25 987.581 2135.83 987.631 2133.76 987.671C2127.36 987.781 2128.4 987.541 2126.75 987.721C2124.76 987.941 2122.75 987.741 2120.75 987.831C2120.43 987.851 2119.64 987.891 2119.05 987.381C2118.96 987.311 2118.89 987.221 2118.82 987.141C2119.35 987.281 2119.96 987.401 2120.62 987.471C2121.82 987.591 2122.64 987.501 2123.81 987.421Z"
            fill="#E57055"
          />
          <path
            d="M2119.97 983.291C2120.93 982.851 2122.35 982.611 2124.35 982.531C2127.18 982.411 2126.47 982.131 2131.05 981.781C2132.11 981.701 2133.49 981.601 2135.35 981.541C2136.47 981.511 2138.06 981.381 2141.23 981.141C2142.08 981.071 2143.1 980.991 2143.13 980.711C2143.16 980.491 2142.55 980.241 2142.31 980.141C2140.33 979.341 2131.61 979.571 2129.99 979.771C2128.56 979.951 2127.23 980.241 2124.72 980.381C2123.04 980.481 2121.9 980.451 2121.18 979.671C2121.08 979.561 2120.98 979.431 2120.9 979.291C2121.55 979.591 2122.36 979.851 2123.31 979.961C2123.88 980.021 2124.33 980.001 2125.64 979.871C2128.5 979.581 2129.16 979.391 2130.81 979.241C2131.79 979.151 2132.85 979.151 2134.97 979.141C2137.1 979.141 2138.19 979.131 2139.53 979.271C2140.26 979.351 2139.86 979.331 2142.84 979.781C2144.91 980.091 2145.36 980.131 2145.39 980.321C2145.44 980.741 2143.25 981.411 2141.43 981.751C2140.81 981.861 2140.07 981.971 2137.01 982.081C2133.55 982.201 2133.61 982.101 2131.87 982.231C2129.89 982.371 2127.81 982.651 2127.21 982.731C2126.23 982.861 2125.31 983.001 2123.92 983.091C2122.72 983.171 2122.22 983.141 2121.81 983.161C2121 983.211 2119.95 983.521 2118.69 984.491C2119.05 983.861 2119.62 983.471 2119.98 983.301L2119.97 983.291Z"
            fill="#E57055"
          />
          <path
            d="M2122.51 976.241C2124.34 975.411 2125.79 975.221 2127.8 974.881C2130.9 974.351 2130.35 974.301 2132.03 974.091C2132.58 974.021 2133.86 973.871 2137.69 973.761C2140.99 973.661 2141.37 973.741 2143.67 973.631C2146.27 973.501 2149.1 973.251 2149.1 972.971C2149.1 972.831 2148.18 972.861 2146.91 972.311C2146.61 972.181 2145.54 971.801 2144.47 971.201C2152.18 971.931 2154.12 972.331 2154.11 972.561C2154.11 972.741 2152.93 972.731 2150.1 973.321C2148.43 973.671 2148.16 973.821 2146.97 974.011C2145.84 974.191 2144.93 974.251 2143.12 974.291C2139.48 974.371 2138.5 974.261 2136.15 974.331C2133.55 974.401 2131.75 974.621 2131.35 974.661C2130.67 974.741 2128.96 974.951 2126.77 975.391C2125.51 975.641 2124.84 975.781 2123.97 976.041C2122.81 976.391 2121.81 976.811 2120.97 977.221C2121.27 976.891 2121.76 976.591 2122.51 976.251V976.241Z"
            fill="#E57055"
          />
          <path
            d="M1944.42 947.381C1944.46 951.651 1944.42 957.531 1944.07 964.551C1943.89 968.251 1943.71 972.011 1943.19 976.991C1942.39 984.771 1941.6 992.071 1938.81 1000.82C1937.59 1004.66 1936.32 1007.69 1935.48 1009.58H1935.38C1935.41 1009.67 1935.43 1009.75 1935.43 1009.84C1935.43 1011.82 1927.52 1013.43 1917.76 1013.43C1908 1013.43 1900.09 1011.82 1900.09 1009.84C1900.09 1009.75 1900.11 1009.66 1900.14 1009.58H1900.09C1899.25 1007.69 1897.98 1004.65 1896.76 1000.82C1893.97 992.071 1893.18 984.771 1892.38 976.991C1891.87 972.011 1891.68 968.251 1891.5 964.551C1891.16 957.531 1891.11 951.641 1891.15 947.381H1944.42Z"
            fill="white"
          />
          <path
            d="M1905.21 947.381C1904.67 962.611 1905.44 980.771 1910.5 993.981C1913.92 1002.92 1918.08 1006.35 1921.07 1008.07C1925.73 1010.74 1930.79 1011.09 1935.01 1010.64C1933.25 1012.25 1926.2 1013.45 1917.77 1013.45C1908.01 1013.45 1900.1 1011.84 1900.1 1009.86C1900.1 1009.77 1900.12 1009.68 1900.15 1009.6H1900.1C1899.26 1007.71 1897.99 1004.67 1896.77 1000.84C1893.98 992.091 1893.19 984.791 1892.39 977.011C1891.88 972.031 1891.69 968.271 1891.51 964.571C1891.17 957.551 1891.12 951.661 1891.16 947.401H1905.22L1905.21 947.381Z"
            fill="#F8FAFF"
          />
          <path
            d="M1876.78 956.75C1879.44 955.1 1881.99 954.94 1883.88 954.82C1885.45 954.72 1887.63 954.61 1890.01 955.7C1890.94 956.12 1892.14 956.66 1893.08 957.89C1895.1 960.52 1894.76 964.79 1893.34 965.43C1892.46 965.83 1891.07 964.88 1890.45 964.29C1889.79 963.67 1889.83 963.3 1888.79 962.01C1888.22 961.31 1887.85 960.85 1887.3 960.43C1886.06 959.49 1884.69 959.37 1883.71 959.29C1882.98 959.23 1881.16 959.1 1879.15 959.99C1875.98 961.4 1874.73 964.32 1874.42 965.07C1873.04 968.43 1873.98 971.49 1874.33 972.61C1874.95 974.6 1875.93 975.92 1877.05 977.43C1878.2 978.98 1879.17 979.91 1881.08 981.72C1887.12 987.45 1891.93 990.62 1893 990.48C1894.22 990.32 1894.49 988.83 1895.19 988.82C1897.09 988.77 1899.94 999.68 1897.91 1000.65C1897.45 1000.87 1896.92 1000.5 1893.18 997.23C1889.04 993.61 1886.4 991.19 1884.24 989.26C1880.74 986.12 1880.2 985.78 1878.37 983.92C1874.99 980.48 1873.84 978.6 1873.46 977.96C1872.61 976.53 1871.44 974.49 1870.92 971.56C1870.67 970.18 1870.21 967.4 1871.27 964.11C1871.63 962.99 1872.93 959.16 1876.79 956.75H1876.78Z"
            fill="white"
          />
          <path
            opacity="0.59"
            d="M1913.25 884.571C1915.82 877.691 1908.84 871.131 1909.46 870.751C1910.3 870.241 1922.34 881.461 1919.76 890.801C1917.78 897.961 1908.92 897.851 1907.57 905.701C1906.81 910.101 1908.68 915.461 1912.18 918.161C1913.99 919.561 1926.03 924.121 1926 934.691C1925.97 942.451 1919.23 949.321 1919.23 949.321C1919.23 949.321 1920.36 937.951 1914.08 931.981C1910.09 928.191 1906.67 930.701 1901.35 926.831C1895.4 922.521 1891.48 913.641 1894.03 907.321C1899.72 893.251 1910.01 893.251 1913.27 884.561L1913.25 884.571Z"
            fill="white"
          />
          <path
            opacity="0.59"
            d="M1936.29 844.77C1936.63 845.06 1934.83 846.84 1933.58 851C1932.86 853.4 1931.93 856.49 1932.77 859.67C1934.02 864.44 1937.09 864.63 1938.73 868.61C1942.31 877.28 1931.34 888.04 1930.87 887.85C1930.28 887.6 1936.46 879.28 1934.12 870.78C1932.18 863.73 1926.17 863.02 1925.99 857.5C1925.77 850.38 1935.56 844.16 1936.29 844.77Z"
            fill="white"
          />
          <path
            d="M1934.31 1268.83L1924.58 1267.6L1950.84 1017.59L1971 1020.14L1934.31 1268.83Z"
            fill="#46466B"
          />
          <path
            d="M1917.87 1302.99L1907.52 1301.69L1937.64 1018.41L1959.09 1021.12L1917.87 1302.99Z"
            fill="#676791"
          />
          <path
            d="M1937.64 1018.41L1935.48 1038.76L1948.58 1040.41L1913.68 1302.47L1917.87 1302.99L1959.09 1021.12L1937.64 1018.41Z"
            fill="#55557F"
          />
          <path
            d="M1852.86 1026.71H2252.19V1011.8H1852.86V1026.71Z"
            fill="#7E7EA3"
          />
          <path
            d="M2113.84 1011.7H2068.82C2067.81 1011.7 2067 1010.88 2067 1009.88C2067 1008.87 2067.82 1008.06 2068.82 1008.06H2113.84C2114.85 1008.06 2115.66 1008.88 2115.66 1009.88C2115.66 1010.89 2114.84 1011.7 2113.84 1011.7Z"
            fill="#CFD8F9"
          />
          <path
            d="M1852.85 1011.79H1858.31C1859.19 1013.64 1860.34 1015.36 1861.87 1016.79C1865.54 1020.23 1869.87 1020.63 1871.38 1020.77C1878.67 1021.44 1959.96 1023.69 2082.65 1026.7H1852.85V1011.79Z"
            fill="#676791"
          />
          <path
            d="M2270.76 813.97C2269.66 813.86 2268.59 815.51 2268.36 817.67C2268.13 819.83 2268.84 821.67 2269.94 821.79C2271.04 821.9 2272.11 820.25 2272.34 818.09C2272.57 815.93 2271.86 814.09 2270.76 813.97Z"
            fill="#543434"
          />
          <path
            d="M2257.56 839.319C2257.05 839.079 2257.98 844.439 2258.44 844.529C2263.1 845.469 2268.87 839.609 2268.4 838.809C2268.1 838.289 2261.13 841.009 2257.56 839.319Z"
            fill="#D8745D"
          />
          <path
            d="M2276.22 809.139C2274.76 808.519 2273.19 808.139 2271.61 808.039C2269.38 807.889 2267.47 808.299 2266.02 808.799C2265.32 809.039 2264.98 809.839 2265.29 810.509L2265.32 810.569C2265.59 811.159 2266.26 811.439 2266.87 811.229C2268.06 810.819 2269.62 810.489 2271.44 810.609C2272.73 810.699 2274.03 811.009 2275.23 811.519C2275.82 811.769 2276.51 811.519 2276.82 810.949L2276.84 810.909C2277.2 810.259 2276.91 809.439 2276.22 809.149V809.139Z"
            fill="#442138"
          />
          <path
            d="M1997.92 1012.01C1994.03 1012.01 1988.43 1011.49 1984.01 1007.41C1979.73 1003.46 1978.35 997.75 1977.95 995.47C1977.27 991.6 1977.78 988.52 1977.95 987.51C1979.5 978.06 1988.62 958.17 1995.96 942.18C1998.79 936.01 2001.32 930.49 2002.98 926.53C2003.72 924.76 2005.73 923.89 2007.54 924.55C2009.47 925.26 2010.42 927.43 2009.62 929.32C2007.9 933.43 2005.35 938.99 2002.5 945.18C1995.72 959.95 1986.44 980.18 1985.05 988.67C1984.93 989.38 1984.58 991.56 1985.05 994.22C1985.2 995.08 1986.09 999.51 1988.9 1002.1C1992.01 1004.97 1996.86 1004.83 1999.75 1004.75H1999.86C2010.03 1004.46 2022.99 1004.54 2038.73 1004.71C2040.72 1004.73 2042.32 1006.36 2042.3 1008.35C2042.28 1010.34 2040.64 1011.94 2038.65 1011.92C2022.99 1011.76 2010.1 1011.68 2000.06 1011.96H1999.95C1999.35 1011.98 1998.66 1012 1997.91 1012L1997.92 1012.01Z"
            fill="#041649"
          />
          <path
            d="M2040.35 988.44L2036.94 987.41C2031.6 985.81 2027.25 981.92 2025.06 976.79L1975.79 861.6C1973.74 856.81 1973.77 851.4 1975.86 846.63L1977.76 842.3C1978.42 840.79 1980.56 840.81 1981.21 842.32L2042.63 985.9C2043.26 987.37 2041.89 988.9 2040.36 988.44H2040.35Z"
            fill="#0D266D"
          />
          <path
            d="M2042.61 985.901L2038.12 975.391L2035.66 974.651C2030.32 973.051 2025.97 969.161 2023.78 964.031L1974.84 849.621C1973.84 853.581 1974.16 857.791 1975.79 861.601L2025.06 976.791C2027.25 981.921 2031.61 985.811 2036.94 987.411L2040.35 988.441C2041.88 988.901 2043.24 987.371 2042.62 985.901H2042.61Z"
            fill="#061F56"
          />
          <path
            d="M2081.4 1011.76H2153.85C2155.32 1011.76 2156.51 1010.57 2156.51 1009.1C2156.51 1007.63 2155.32 1006.44 2153.85 1006.44H2081.4C2079.93 1006.44 2078.74 1007.63 2078.74 1009.1C2078.74 1010.57 2079.93 1011.76 2081.4 1011.76Z"
            fill="#041649"
          />
          <path
            d="M2168.17 783.06L2160.16 744.14C2167.93 733.98 2172.56 721.29 2172.56 707.51C2172.56 674.18 2145.54 647.16 2112.21 647.16H2029.86C1996.53 647.16 1969.51 674.18 1969.51 707.51C1969.51 740.84 1996.53 767.86 2029.86 767.86H2068.28H2112.21C2116.34 767.86 2120.37 767.44 2124.26 766.65L2167.49 801.9C2167.85 801.09 2168.09 800.26 2168.09 799.19C2168.09 800.26 2167.85 801.1 2167.49 801.9L2172.97 806.37L2168.17 783.06Z"
            fill={theme.palette.primary.light}
          />
          <path
            d="M2108.77 698.971C2102.34 698.971 2097.13 704.181 2097.13 710.611C2097.13 717.041 2102.34 722.251 2108.77 722.251C2115.2 722.251 2120.41 717.041 2120.41 710.611C2120.41 704.181 2115.2 698.971 2108.77 698.971Z"
            fill="white"
          />
          <path
            d="M2035.04 698.971C2028.61 698.971 2023.4 704.181 2023.4 710.611C2023.4 717.041 2028.61 722.251 2035.04 722.251C2041.47 722.251 2046.68 717.041 2046.68 710.611C2046.68 704.181 2041.47 698.971 2035.04 698.971Z"
            fill="white"
          />
          <path
            d="M2071.91 698.971C2065.48 698.971 2060.27 704.181 2060.27 710.611C2060.27 717.041 2065.48 722.251 2071.91 722.251C2078.34 722.251 2083.55 717.041 2083.55 710.611C2083.55 704.181 2078.34 698.971 2071.91 698.971Z"
            fill="white"
          />
          <path
            d="M2275.56 971.521C2275.16 971.521 2275.23 971.541 2265.88 973.291C2253.56 975.601 2247.34 976.761 2243.98 977.291C2234.93 978.721 2227.65 979.341 2224.14 979.601C2214.77 980.291 2181.55 981.861 2176.57 981.441C2172.71 981.111 2170.86 980.671 2169.81 981.891C2166.51 985.711 2172.97 1001.96 2182.23 1003.2C2184.03 1003.44 2223.05 1010.44 2230.92 1011C2243.25 1011.87 2250.18 1012.36 2259.57 1010.77C2267.1 1009.49 2270.42 1007.85 2278 1007.93C2279.21 1007.94 2284.22 1008.04 2290.81 1007.43C2296.03 1006.95 2297.05 1006.51 2297.69 1006.17C2302.33 1003.7 2304.77 996.911 2304.23 991.551C2303.07 979.961 2287.64 971.231 2275.57 971.521H2275.56Z"
            fill="#EB8E6C"
          />
          <path
            d="M2272.11 971.03C2274.96 966.63 2280.74 954.22 2290.49 928.05C2296.36 912.31 2294.37 908.39 2301.62 895.17C2310.39 879.19 2318.37 875.66 2320.78 874.72C2323.4 873.69 2332.46 870.58 2342.01 874.72C2350.38 878.34 2354.19 885.38 2355.99 888.7C2359.78 895.7 2360.15 902.19 2360.39 906.31C2360.48 907.87 2360.73 913.51 2359.1 920.81C2357.26 929.05 2354.02 934.92 2351.85 938.68C2344.89 950.7 2340.38 955.55 2330.88 968.97C2322.13 981.34 2299.61 1007.59 2296.96 1007.81C2293.33 1008.1 2289.84 1004.12 2284.01 994.35C2276.5 981.75 2269.68 974.78 2272.1 971.05L2272.11 971.03Z"
            fill="#9494ED"
          />
          <path
            d="M2360.4 906.301C2360.16 902.181 2359.79 895.691 2356 888.691C2355.82 888.351 2355.61 887.971 2355.38 887.561C2355.78 890.461 2356.01 893.851 2355.81 897.641C2355.52 903.111 2354.41 907.861 2352.69 912.951C2349.39 922.731 2344.8 930.951 2337.66 941.871C2325.33 960.741 2318.94 970.351 2307.61 979.011C2302.75 982.721 2298.55 985.881 2292.02 988.081C2288.41 989.301 2284.87 989.961 2281.5 990.241C2282.32 991.531 2283.17 992.891 2284.02 994.321C2289.85 1004.09 2293.34 1008.08 2296.97 1007.78C2299.62 1007.56 2322.13 981.311 2330.89 968.941C2340.39 955.521 2344.91 950.661 2351.86 938.651C2354.03 934.901 2357.27 929.021 2359.11 920.781C2360.74 913.481 2360.49 907.841 2360.4 906.281V906.301Z"
            fill="#8989E5"
          />
        </g>
        <defs>
          <clipPath id="clip0_2427_10652">
            <rect width="2483.56" height="1357.27" fill="white" />
          </clipPath>
        </defs>
      </svg>
    </Box>
  );
};

export default SupportImgSvg;
